/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class TestQueryRulesetAction {
    public static final ActionType<Response> TYPE = new ActionType("cluster:admin/xpack/query_rules/test");
    public static final String NAME = TYPE.name();
    public static final ActionType<Response> INSTANCE = new ActionType(NAME);

    private TestQueryRulesetAction() {
    }

    public record MatchedRule(String rulesetId, String ruleId) {
        public MatchedRule(StreamInput in) throws IOException {
            this(in.readString(), in.readString());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.rulesetId);
            out.writeString(this.ruleId);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final int totalMatchedRules;
        private final List<MatchedRule> matchedRules;
        private static final ParseField TOTAL_MATCHED_RULES_FIELD = new ParseField("total_matched_rules", new String[0]);
        private static final ParseField MATCHED_RULES_FIELD = new ParseField("matched_rules", new String[0]);

        public Response(StreamInput in) throws IOException {
            super(in);
            this.totalMatchedRules = in.readVInt();
            this.matchedRules = in.readCollectionAsList(MatchedRule::new);
        }

        public Response(int totalMatchedRules, List<MatchedRule> matchedRules) {
            this.totalMatchedRules = totalMatchedRules;
            this.matchedRules = matchedRules;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.totalMatchedRules);
            out.writeCollection(this.matchedRules, (stream, matchedRule) -> matchedRule.writeTo(stream));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(TOTAL_MATCHED_RULES_FIELD.getPreferredName(), this.totalMatchedRules);
            builder.startArray(MATCHED_RULES_FIELD.getPreferredName());
            for (MatchedRule matchedRule : this.matchedRules) {
                builder.startObject();
                builder.field("ruleset_id", matchedRule.rulesetId());
                builder.field("rule_id", matchedRule.ruleId());
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.totalMatchedRules, response.totalMatchedRules) && Objects.equals(this.matchedRules, response.matchedRules);
        }

        public int hashCode() {
            return Objects.hash(this.totalMatchedRules, this.matchedRules);
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject,
    IndicesRequest {
        private final String rulesetId;
        private final Map<String, Object> matchCriteria;
        private static final ParseField RULESET_ID_FIELD = new ParseField("ruleset_id", new String[0]);
        private static final ParseField MATCH_CRITERIA_FIELD = new ParseField("match_criteria", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("test_query_ruleset_request", false, (p, name) -> {
            Map matchCriteria = (Map)p[0];
            return new Request((String)name, matchCriteria);
        });

        public Request(StreamInput in) throws IOException {
            super(in);
            this.rulesetId = in.readString();
            this.matchCriteria = in.readGenericMap();
        }

        public Request(String rulesetId, Map<String, Object> matchCriteria) {
            this.rulesetId = rulesetId;
            this.matchCriteria = matchCriteria;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.rulesetId)) {
                validationException = ValidateActions.addValidationError((String)"ruleset_id missing", validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.rulesetId);
            out.writeGenericMap(this.matchCriteria);
        }

        public String rulesetId() {
            return this.rulesetId;
        }

        public Map<String, Object> matchCriteria() {
            return this.matchCriteria;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.rulesetId, request.rulesetId) && Objects.equals(this.matchCriteria, request.matchCriteria);
        }

        public int hashCode() {
            return Objects.hash(this.rulesetId, this.matchCriteria);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(RULESET_ID_FIELD.getPreferredName(), this.rulesetId);
            builder.startObject(MATCH_CRITERIA_FIELD.getPreferredName());
            builder.mapContents(this.matchCriteria);
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public static Request parse(XContentParser parser, String name) {
            return (Request)((Object)PARSER.apply(parser, (Object)name));
        }

        public String[] indices() {
            return new String[]{".query-rules"};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.lenientExpandHidden();
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), MATCH_CRITERIA_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), RULESET_ID_FIELD);
        }
    }
}

