/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.walk;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import java.net.URI;

public class WalkEvent {
    private String schemaPath;
    private JsonNode schemaNode;
    private JsonSchema parentSchema;
    private String keyWordName;
    private JsonNode node;
    private JsonNode rootNode;
    private String at;
    private JsonSchemaFactory currentJsonSchemaFactory;

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    public JsonSchema getParentSchema() {
        return this.parentSchema;
    }

    public String getKeyWordName() {
        return this.keyWordName;
    }

    public JsonNode getNode() {
        return this.node;
    }

    public JsonNode getRootNode() {
        return this.rootNode;
    }

    public String getAt() {
        return this.at;
    }

    public JsonSchema getRefSchema(URI schemaUri) {
        return this.currentJsonSchemaFactory.getSchema(schemaUri);
    }

    public static WalkEventBuilder builder() {
        return new WalkEventBuilder();
    }

    static class WalkEventBuilder {
        private WalkEvent keywordWalkEvent = new WalkEvent();

        WalkEventBuilder() {
        }

        public WalkEventBuilder schemaPath(String schemaPath) {
            this.keywordWalkEvent.schemaPath = schemaPath;
            return this;
        }

        public WalkEventBuilder schemaNode(JsonNode schemaNode) {
            this.keywordWalkEvent.schemaNode = schemaNode;
            return this;
        }

        public WalkEventBuilder parentSchema(JsonSchema parentSchema) {
            this.keywordWalkEvent.parentSchema = parentSchema;
            return this;
        }

        public WalkEventBuilder keyWordName(String keyWordName) {
            this.keywordWalkEvent.keyWordName = keyWordName;
            return this;
        }

        public WalkEventBuilder node(JsonNode node) {
            this.keywordWalkEvent.node = node;
            return this;
        }

        public WalkEventBuilder rootNode(JsonNode rootNode) {
            this.keywordWalkEvent.rootNode = rootNode;
            return this;
        }

        public WalkEventBuilder at(String at) {
            this.keywordWalkEvent.at = at;
            return this;
        }

        public WalkEventBuilder currentJsonSchemaFactory(JsonSchemaFactory currentJsonSchemaFactory) {
            this.keywordWalkEvent.currentJsonSchemaFactory = currentJsonSchemaFactory;
            return this;
        }

        public WalkEvent build() {
            return this.keywordWalkEvent;
        }
    }
}

