// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`ListBucketInventoryConfigurations`](crate::operation::list_bucket_inventory_configurations::builders::ListBucketInventoryConfigurationsFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::list_bucket_inventory_configurations::builders::ListBucketInventoryConfigurationsFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::list_bucket_inventory_configurations::builders::ListBucketInventoryConfigurationsFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the bucket containing the inventory configurations to retrieve.</p><br>
    ///   - [`continuation_token(impl Into<String>)`](crate::operation::list_bucket_inventory_configurations::builders::ListBucketInventoryConfigurationsFluentBuilder::continuation_token) / [`set_continuation_token(Option<String>)`](crate::operation::list_bucket_inventory_configurations::builders::ListBucketInventoryConfigurationsFluentBuilder::set_continuation_token):<br>required: **false**<br><p>The marker used to continue an inventory configuration listing that has been truncated. Use the <code>NextContinuationToken</code> from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::list_bucket_inventory_configurations::builders::ListBucketInventoryConfigurationsFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::list_bucket_inventory_configurations::builders::ListBucketInventoryConfigurationsFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`ListBucketInventoryConfigurationsOutput`](crate::operation::list_bucket_inventory_configurations::ListBucketInventoryConfigurationsOutput) with field(s):
    ///   - [`continuation_token(Option<String>)`](crate::operation::list_bucket_inventory_configurations::ListBucketInventoryConfigurationsOutput::continuation_token): <p>If sent in the request, the marker that is used as a starting point for this inventory configuration list response.</p>
    ///   - [`inventory_configuration_list(Option<Vec::<InventoryConfiguration>>)`](crate::operation::list_bucket_inventory_configurations::ListBucketInventoryConfigurationsOutput::inventory_configuration_list): <p>The list of inventory configurations for a bucket.</p>
    ///   - [`is_truncated(Option<bool>)`](crate::operation::list_bucket_inventory_configurations::ListBucketInventoryConfigurationsOutput::is_truncated): <p>Tells whether the returned list of inventory configurations is complete. A value of true indicates that the list is not complete and the NextContinuationToken is provided for a subsequent request.</p>
    ///   - [`next_continuation_token(Option<String>)`](crate::operation::list_bucket_inventory_configurations::ListBucketInventoryConfigurationsOutput::next_continuation_token): <p>The marker used to continue this inventory configuration listing. Use the <code>NextContinuationToken</code> from this response to continue the listing in a subsequent request. The continuation token is an opaque value that Amazon S3 understands.</p>
    /// - On failure, responds with [`SdkError<ListBucketInventoryConfigurationsError>`](crate::operation::list_bucket_inventory_configurations::ListBucketInventoryConfigurationsError)
    pub fn list_bucket_inventory_configurations(
        &self,
    ) -> crate::operation::list_bucket_inventory_configurations::builders::ListBucketInventoryConfigurationsFluentBuilder {
        crate::operation::list_bucket_inventory_configurations::builders::ListBucketInventoryConfigurationsFluentBuilder::new(self.handle.clone())
    }
}
