// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The destination information for the S3 Metadata configuration.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DestinationResult {
    /// <p>The type of the table bucket where the metadata configuration is stored. The <code>aws</code> value indicates an Amazon Web Services managed table bucket, and the <code>customer</code> value indicates a customer-managed table bucket. V2 metadata configurations are stored in Amazon Web Services managed table buckets, and V1 metadata configurations are stored in customer-managed table buckets.</p>
    pub table_bucket_type: ::std::option::Option<crate::types::S3TablesBucketType>,
    /// <p>The Amazon Resource Name (ARN) of the table bucket where the metadata configuration is stored.</p>
    pub table_bucket_arn: ::std::option::Option<::std::string::String>,
    /// <p>The namespace in the table bucket where the metadata tables for a metadata configuration are stored.</p>
    pub table_namespace: ::std::option::Option<::std::string::String>,
}
impl DestinationResult {
    /// <p>The type of the table bucket where the metadata configuration is stored. The <code>aws</code> value indicates an Amazon Web Services managed table bucket, and the <code>customer</code> value indicates a customer-managed table bucket. V2 metadata configurations are stored in Amazon Web Services managed table buckets, and V1 metadata configurations are stored in customer-managed table buckets.</p>
    pub fn table_bucket_type(&self) -> ::std::option::Option<&crate::types::S3TablesBucketType> {
        self.table_bucket_type.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the table bucket where the metadata configuration is stored.</p>
    pub fn table_bucket_arn(&self) -> ::std::option::Option<&str> {
        self.table_bucket_arn.as_deref()
    }
    /// <p>The namespace in the table bucket where the metadata tables for a metadata configuration are stored.</p>
    pub fn table_namespace(&self) -> ::std::option::Option<&str> {
        self.table_namespace.as_deref()
    }
}
impl DestinationResult {
    /// Creates a new builder-style object to manufacture [`DestinationResult`](crate::types::DestinationResult).
    pub fn builder() -> crate::types::builders::DestinationResultBuilder {
        crate::types::builders::DestinationResultBuilder::default()
    }
}

/// A builder for [`DestinationResult`](crate::types::DestinationResult).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct DestinationResultBuilder {
    pub(crate) table_bucket_type: ::std::option::Option<crate::types::S3TablesBucketType>,
    pub(crate) table_bucket_arn: ::std::option::Option<::std::string::String>,
    pub(crate) table_namespace: ::std::option::Option<::std::string::String>,
}
impl DestinationResultBuilder {
    /// <p>The type of the table bucket where the metadata configuration is stored. The <code>aws</code> value indicates an Amazon Web Services managed table bucket, and the <code>customer</code> value indicates a customer-managed table bucket. V2 metadata configurations are stored in Amazon Web Services managed table buckets, and V1 metadata configurations are stored in customer-managed table buckets.</p>
    pub fn table_bucket_type(mut self, input: crate::types::S3TablesBucketType) -> Self {
        self.table_bucket_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The type of the table bucket where the metadata configuration is stored. The <code>aws</code> value indicates an Amazon Web Services managed table bucket, and the <code>customer</code> value indicates a customer-managed table bucket. V2 metadata configurations are stored in Amazon Web Services managed table buckets, and V1 metadata configurations are stored in customer-managed table buckets.</p>
    pub fn set_table_bucket_type(mut self, input: ::std::option::Option<crate::types::S3TablesBucketType>) -> Self {
        self.table_bucket_type = input;
        self
    }
    /// <p>The type of the table bucket where the metadata configuration is stored. The <code>aws</code> value indicates an Amazon Web Services managed table bucket, and the <code>customer</code> value indicates a customer-managed table bucket. V2 metadata configurations are stored in Amazon Web Services managed table buckets, and V1 metadata configurations are stored in customer-managed table buckets.</p>
    pub fn get_table_bucket_type(&self) -> &::std::option::Option<crate::types::S3TablesBucketType> {
        &self.table_bucket_type
    }
    /// <p>The Amazon Resource Name (ARN) of the table bucket where the metadata configuration is stored.</p>
    pub fn table_bucket_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.table_bucket_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the table bucket where the metadata configuration is stored.</p>
    pub fn set_table_bucket_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.table_bucket_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the table bucket where the metadata configuration is stored.</p>
    pub fn get_table_bucket_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.table_bucket_arn
    }
    /// <p>The namespace in the table bucket where the metadata tables for a metadata configuration are stored.</p>
    pub fn table_namespace(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.table_namespace = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The namespace in the table bucket where the metadata tables for a metadata configuration are stored.</p>
    pub fn set_table_namespace(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.table_namespace = input;
        self
    }
    /// <p>The namespace in the table bucket where the metadata tables for a metadata configuration are stored.</p>
    pub fn get_table_namespace(&self) -> &::std::option::Option<::std::string::String> {
        &self.table_namespace
    }
    /// Consumes the builder and constructs a [`DestinationResult`](crate::types::DestinationResult).
    pub fn build(self) -> crate::types::DestinationResult {
        crate::types::DestinationResult {
            table_bucket_type: self.table_bucket_type,
            table_bucket_arn: self.table_bucket_arn,
            table_namespace: self.table_namespace,
        }
    }
}
