package keyvaultapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/keyvault/mgmt/2015-06-01/keyvault"
	"github.com/Azure/go-autorest/autorest"
)

// VaultsClientAPI contains the set of methods on the VaultsClient type.
type VaultsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, vaultName string, parameters keyvault.VaultCreateOrUpdateParameters) (result keyvault.Vault, err error)
	Delete(ctx context.Context, resourceGroupName string, vaultName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, vaultName string) (result keyvault.Vault, err error)
	List(ctx context.Context, top *int32) (result keyvault.ResourceListResultPage, err error)
	ListComplete(ctx context.Context, top *int32) (result keyvault.ResourceListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, top *int32) (result keyvault.VaultListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, top *int32) (result keyvault.VaultListResultIterator, err error)
}

var _ VaultsClientAPI = (*keyvault.VaultsClient)(nil)
