package timeseriesinsightsapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/timeseriesinsights/mgmt/2020-05-15/timeseriesinsights"
	"github.com/Azure/go-autorest/autorest"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result timeseriesinsights.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result timeseriesinsights.OperationListResultIterator, err error)
}

var _ OperationsClientAPI = (*timeseriesinsights.OperationsClient)(nil)

// EnvironmentsClientAPI contains the set of methods on the EnvironmentsClient type.
type EnvironmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, environmentName string, parameters timeseriesinsights.BasicEnvironmentCreateOrUpdateParameters) (result timeseriesinsights.EnvironmentsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, environmentName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, environmentName string, expand string) (result timeseriesinsights.EnvironmentResourceModel, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result timeseriesinsights.EnvironmentListResponse, err error)
	ListBySubscription(ctx context.Context) (result timeseriesinsights.EnvironmentListResponse, err error)
	Update(ctx context.Context, resourceGroupName string, environmentName string, environmentUpdateParameters timeseriesinsights.EnvironmentUpdateParameters) (result timeseriesinsights.EnvironmentsUpdateFuture, err error)
}

var _ EnvironmentsClientAPI = (*timeseriesinsights.EnvironmentsClient)(nil)

// EventSourcesClientAPI contains the set of methods on the EventSourcesClient type.
type EventSourcesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, environmentName string, eventSourceName string, parameters timeseriesinsights.BasicEventSourceCreateOrUpdateParameters) (result timeseriesinsights.EventSourceResourceModel, err error)
	Delete(ctx context.Context, resourceGroupName string, environmentName string, eventSourceName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, environmentName string, eventSourceName string) (result timeseriesinsights.EventSourceResourceModel, err error)
	ListByEnvironment(ctx context.Context, resourceGroupName string, environmentName string) (result timeseriesinsights.EventSourceListResponse, err error)
	Update(ctx context.Context, resourceGroupName string, environmentName string, eventSourceName string, eventSourceUpdateParameters timeseriesinsights.EventSourceUpdateParameters) (result timeseriesinsights.EventSourceResourceModel, err error)
}

var _ EventSourcesClientAPI = (*timeseriesinsights.EventSourcesClient)(nil)

// ReferenceDataSetsClientAPI contains the set of methods on the ReferenceDataSetsClient type.
type ReferenceDataSetsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, environmentName string, referenceDataSetName string, parameters timeseriesinsights.ReferenceDataSetCreateOrUpdateParameters) (result timeseriesinsights.ReferenceDataSetResource, err error)
	Delete(ctx context.Context, resourceGroupName string, environmentName string, referenceDataSetName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, environmentName string, referenceDataSetName string) (result timeseriesinsights.ReferenceDataSetResource, err error)
	ListByEnvironment(ctx context.Context, resourceGroupName string, environmentName string) (result timeseriesinsights.ReferenceDataSetListResponse, err error)
	Update(ctx context.Context, resourceGroupName string, environmentName string, referenceDataSetName string, referenceDataSetUpdateParameters timeseriesinsights.ReferenceDataSetUpdateParameters) (result timeseriesinsights.ReferenceDataSetResource, err error)
}

var _ ReferenceDataSetsClientAPI = (*timeseriesinsights.ReferenceDataSetsClient)(nil)

// AccessPoliciesClientAPI contains the set of methods on the AccessPoliciesClient type.
type AccessPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, environmentName string, accessPolicyName string, parameters timeseriesinsights.AccessPolicyCreateOrUpdateParameters) (result timeseriesinsights.AccessPolicyResource, err error)
	Delete(ctx context.Context, resourceGroupName string, environmentName string, accessPolicyName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, environmentName string, accessPolicyName string) (result timeseriesinsights.AccessPolicyResource, err error)
	ListByEnvironment(ctx context.Context, resourceGroupName string, environmentName string) (result timeseriesinsights.AccessPolicyListResponse, err error)
	Update(ctx context.Context, resourceGroupName string, environmentName string, accessPolicyName string, accessPolicyUpdateParameters timeseriesinsights.AccessPolicyUpdateParameters) (result timeseriesinsights.AccessPolicyResource, err error)
}

var _ AccessPoliciesClientAPI = (*timeseriesinsights.AccessPoliciesClient)(nil)
