package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMetaTableLineage invokes the dataworks_public.GetMetaTableLineage API synchronously
func (client *Client) GetMetaTableLineage(request *GetMetaTableLineageRequest) (response *GetMetaTableLineageResponse, err error) {
	response = CreateGetMetaTableLineageResponse()
	err = client.DoAction(request, response)
	return
}

// GetMetaTableLineageWithChan invokes the dataworks_public.GetMetaTableLineage API asynchronously
func (client *Client) GetMetaTableLineageWithChan(request *GetMetaTableLineageRequest) (<-chan *GetMetaTableLineageResponse, <-chan error) {
	responseChan := make(chan *GetMetaTableLineageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMetaTableLineage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMetaTableLineageWithCallback invokes the dataworks_public.GetMetaTableLineage API asynchronously
func (client *Client) GetMetaTableLineageWithCallback(request *GetMetaTableLineageRequest, callback func(response *GetMetaTableLineageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMetaTableLineageResponse
		var err error
		defer close(result)
		response, err = client.GetMetaTableLineage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMetaTableLineageRequest is the request struct for api GetMetaTableLineage
type GetMetaTableLineageRequest struct {
	*requests.RpcRequest
	DataSourceType string           `position:"Query" name:"DataSourceType"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	TableGuid      string           `position:"Query" name:"TableGuid"`
	NextPrimaryKey string           `position:"Query" name:"NextPrimaryKey"`
	DatabaseName   string           `position:"Query" name:"DatabaseName"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	TableName      string           `position:"Query" name:"TableName"`
	Direction      string           `position:"Query" name:"Direction"`
}

// GetMetaTableLineageResponse is the response struct for api GetMetaTableLineage
type GetMetaTableLineageResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetMetaTableLineageRequest creates a request to invoke GetMetaTableLineage API
func CreateGetMetaTableLineageRequest() (request *GetMetaTableLineageRequest) {
	request = &GetMetaTableLineageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetMetaTableLineage", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMetaTableLineageResponse creates a response to parse from GetMetaTableLineage response
func CreateGetMetaTableLineageResponse() (response *GetMetaTableLineageResponse) {
	response = &GetMetaTableLineageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
