package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAckNamespaces invokes the elasticsearch.ListAckNamespaces API synchronously
func (client *Client) ListAckNamespaces(request *ListAckNamespacesRequest) (response *ListAckNamespacesResponse, err error) {
	response = CreateListAckNamespacesResponse()
	err = client.DoAction(request, response)
	return
}

// ListAckNamespacesWithChan invokes the elasticsearch.ListAckNamespaces API asynchronously
func (client *Client) ListAckNamespacesWithChan(request *ListAckNamespacesRequest) (<-chan *ListAckNamespacesResponse, <-chan error) {
	responseChan := make(chan *ListAckNamespacesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAckNamespaces(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAckNamespacesWithCallback invokes the elasticsearch.ListAckNamespaces API asynchronously
func (client *Client) ListAckNamespacesWithCallback(request *ListAckNamespacesRequest, callback func(response *ListAckNamespacesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAckNamespacesResponse
		var err error
		defer close(result)
		response, err = client.ListAckNamespaces(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAckNamespacesRequest is the request struct for api ListAckNamespaces
type ListAckNamespacesRequest struct {
	*requests.RoaRequest
	Size      requests.Integer `position:"Query" name:"size"`
	Page      requests.Integer `position:"Query" name:"page"`
	ClusterId string           `position:"Path" name:"ClusterId"`
}

// ListAckNamespacesResponse is the response struct for api ListAckNamespaces
type ListAckNamespacesResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateListAckNamespacesRequest creates a request to invoke ListAckNamespaces API
func CreateListAckNamespacesRequest() (request *ListAckNamespacesRequest) {
	request = &ListAckNamespacesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListAckNamespaces", "/openapi/ack-clusters/[ClusterId]/namespaces", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListAckNamespacesResponse creates a response to parse from ListAckNamespaces response
func CreateListAckNamespacesResponse() (response *ListAckNamespacesResponse) {
	response = &ListAckNamespacesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
