package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindImagePackage invokes the market.BindImagePackage API synchronously
// api document: https://help.aliyun.com/api/market/bindimagepackage.html
func (client *Client) BindImagePackage(request *BindImagePackageRequest) (response *BindImagePackageResponse, err error) {
	response = CreateBindImagePackageResponse()
	err = client.DoAction(request, response)
	return
}

// BindImagePackageWithChan invokes the market.BindImagePackage API asynchronously
// api document: https://help.aliyun.com/api/market/bindimagepackage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindImagePackageWithChan(request *BindImagePackageRequest) (<-chan *BindImagePackageResponse, <-chan error) {
	responseChan := make(chan *BindImagePackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindImagePackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindImagePackageWithCallback invokes the market.BindImagePackage API asynchronously
// api document: https://help.aliyun.com/api/market/bindimagepackage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindImagePackageWithCallback(request *BindImagePackageRequest, callback func(response *BindImagePackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindImagePackageResponse
		var err error
		defer close(result)
		response, err = client.BindImagePackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindImagePackageRequest is the request struct for api BindImagePackage
type BindImagePackageRequest struct {
	*requests.RpcRequest
	EcsInstanceId          string `position:"Query" name:"EcsInstanceId"`
	ImagePackageInstanceId string `position:"Query" name:"ImagePackageInstanceId"`
}

// BindImagePackageResponse is the response struct for api BindImagePackage
type BindImagePackageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateBindImagePackageRequest creates a request to invoke BindImagePackage API
func CreateBindImagePackageRequest() (request *BindImagePackageRequest) {
	request = &BindImagePackageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "BindImagePackage", "yunmarket", "openAPI")
	return
}

// CreateBindImagePackageResponse creates a response to parse from BindImagePackage response
func CreateBindImagePackageResponse() (response *BindImagePackageResponse) {
	response = &BindImagePackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
