/* OpenCL built-in library: wait_group_events()

   Copyright (c) 2012 Pekka Jääskeläinen / Tampere University of Technology
   
   Permission is hereby granted, free of charge, to any person obtaining a copy
   of this software and associated documentation files (the "Software"), to deal
   in the Software without restriction, including without limitation the rights
   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
   copies of the Software, and to permit persons to whom the Software is
   furnished to do so, subject to the following conditions:
   
   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
   THE SOFTWARE.
*/

/* The default implementation for "async copies" is a 
   blocking one which doesn't actually need events for 
   anything. The event waiting is therefore a dummy function. */

void _CL_OVERLOADABLE wait_group_events (int num_events,
                                         private event_t * event_list)
{
}

void _CL_OVERLOADABLE wait_group_events (int num_events,
                                         local event_t * event_list)
{
}

void _CL_OVERLOADABLE wait_group_events (int num_events,
                                         global event_t * event_list)
{
}

#ifdef __opencl_c_generic_address_space
void _CL_OVERLOADABLE wait_group_events (int num_events,
                                         generic event_t * event_list)
{
}
#endif
