package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePolicy invokes the kms.CreatePolicy API synchronously
func (client *Client) CreatePolicy(request *CreatePolicyRequest) (response *CreatePolicyResponse, err error) {
	response = CreateCreatePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePolicyWithChan invokes the kms.CreatePolicy API asynchronously
func (client *Client) CreatePolicyWithChan(request *CreatePolicyRequest) (<-chan *CreatePolicyResponse, <-chan error) {
	responseChan := make(chan *CreatePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePolicyWithCallback invokes the kms.CreatePolicy API asynchronously
func (client *Client) CreatePolicyWithCallback(request *CreatePolicyRequest, callback func(response *CreatePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePolicyResponse
		var err error
		defer close(result)
		response, err = client.CreatePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePolicyRequest is the request struct for api CreatePolicy
type CreatePolicyRequest struct {
	*requests.RpcRequest
	AccessControlRules string `position:"Query" name:"AccessControlRules"`
	Description        string `position:"Query" name:"Description"`
	Resources          string `position:"Query" name:"Resources"`
	KmsInstance        string `position:"Query" name:"KmsInstance"`
	Permissions        string `position:"Query" name:"Permissions"`
	Name               string `position:"Query" name:"Name"`
}

// CreatePolicyResponse is the response struct for api CreatePolicy
type CreatePolicyResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	Arn                string `json:"Arn" xml:"Arn"`
	Name               string `json:"Name" xml:"Name"`
	Description        string `json:"Description" xml:"Description"`
	KmsInstance        string `json:"KmsInstance" xml:"KmsInstance"`
	Permissions        string `json:"Permissions" xml:"Permissions"`
	Resources          string `json:"Resources" xml:"Resources"`
	AccessControlRules string `json:"AccessControlRules" xml:"AccessControlRules"`
}

// CreateCreatePolicyRequest creates a request to invoke CreatePolicy API
func CreateCreatePolicyRequest() (request *CreatePolicyRequest) {
	request = &CreatePolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "CreatePolicy", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreatePolicyResponse creates a response to parse from CreatePolicy response
func CreateCreatePolicyResponse() (response *CreatePolicyResponse) {
	response = &CreatePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
