## RabbitMQ 3.6.10

RabbitMQ `3.6.10` is a maintenance release.

### Upgrades and Compatibility

See the ["Upgrading clusters" section of the documentation](https://www.rabbitmq.com/clustering.html#upgrading)
for general documentation on upgrades.

:warning: This release introduces stricter validation for `rabbitmq_management_agent.sample_retention_policies` values.
In case your installation overrides default sample retention policies, please make sure to read
the discussion in [rabbitmq-management-agent#41](https://github.com/rabbitmq/rabbitmq-management-agent/issues/41) before
upgrading to make sure your configuration passes validation.

This release has no other known incompatibilities with versions 3.6.7 through 3.6.9. See [3.6.7 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/rabbitmq_v3_6_7)
upgrade and compatibility notes if upgrading from an earlier release.


### Core Server

#### Bug Fixes

 * `rabbitmqctl wait` exited with the status code of 0 when node stopped because it could
    not contact any cluster peers to [re-]join.

    GitHub issue: [rabbitmq-server#1214](https://github.com/rabbitmq/rabbitmq-server/issues/1214)

 * `rabbitmqctl forget_cluster_node` used in offline mode could result in promotion of a node that's no longer a cluster member.

    GitHub issue: [rabbitmq-server#1213](https://github.com/rabbitmq/rabbitmq-server/issues/1213)

 * Queue status (e.g. `running` vs. `idle`) was reported incorrectly in some cases.

    GitHub issue: [rabbitmq-common#196](https://github.com/rabbitmq/rabbitmq-common/issues/196)

 * queue leader locator could not be set using optional queue arguments (`x-arguments`).

   GitHub issue: [rabbitmq-server#1172](https://github.com/rabbitmq/rabbitmq-server/issues/1172)

 * CLI tool (e.g. `rabbitmqctl`) man pages were not rendered correctly.

   GitHub issue: [rabbitmq-server#1180](https://github.com/rabbitmq/rabbitmq-server/issues/1180)

#### Enhancements

 * Disk space monitor will periodically retry (every 2 minutes by default, up to 10 times)
   before going into disabled state as external tools used to monitor available disk space
   can fail or produce unexpected output temporarily.

   GitHub issue: [rabbitmq-server#1178](https://github.com/rabbitmq/rabbitmq-server/issues/1178)

 * Memory relative free disk space limits now support integer values as well as floats.

   GitHub issue: [rabbitmq-server#1194](https://github.com/rabbitmq/rabbitmq-server/issues/1194)


### Management and Management Agent Plugins

#### Bug Fixes

 * TLS-related settings in HTTP API listeners could break JSON serialisation for the `GET /api/overview` endpoint.

   GitHub issue: [rabbitmq-management#393](https://github.com/rabbitmq/rabbitmq-management/issues/393)

 * Non-numerical values for numerical stats are now handled safety by stats aggregation. For example, if
   free disk space monitor had to stop reporting data because it could not parse external tool output
   that would break HTTP API `GET /api/overview` responses.

   GitHub issue: [rabbitmq-management#375](https://github.com/rabbitmq/rabbitmq-management/issues/375).

 * Stats are no longer emitted for connections that are not considered to be in the fully initialised
   state.

   GitHub issue: [rabbitmq-management-agent#42](https://github.com/rabbitmq/rabbitmq-management-agent/issues/42)

 * `POST` requests now instruct clients to close TCP connections.

    In some popular browsers (Chrome, Internet Explorer) a `POST` request followed by an immediate `GET` request
    would result in a 400 response. Other browsers do no exhibit this behaviour.

    GitHub issue: [rabbitmq-management#377](https://github.com/rabbitmq/rabbitmq-management/issues/377)

 * I/O average time per operation graph didn't match the legend.

    GitHub issue: [rabbitmq-management#384](https://github.com/rabbitmq/rabbitmq-management/issues/384)

 *  Definitions import and export forms are now separte to reduce the chance of user confusion.

    GitHub issue: [rabbitmq-management#389](https://github.com/rabbitmq/rabbitmq-management/issues/389)

 * Sample retention policies are now validated more strictly to avoid configurations that
   are not supported and will lead to exceptions.

   GitHub issue: [rabbitmq-management-agent#41](https://github.com/rabbitmq/rabbitmq-management-agent/issues/41)

 * Certain stats for connections were not initialised as numerical values, which resulted in log noise.

   GitHub issue: [rabbitmq-management-agent#45](https://github.com/rabbitmq/rabbitmq-management-agent/issues/45)

 * UI operation for binding deletion did not respect optional (extra) binding arguments.

   GitHub issue: [rabbitmq-management#243](https://github.com/rabbitmq/rabbitmq-management/issues/243)

#### Enhancements

 * Current virtual host is pre-selected on the "Add/update policy" form.

   GitHub issue: [rabbitmq-management#382](https://github.com/rabbitmq/rabbitmq-management/issues/382)


### MQTT Plugin

#### Bug Fixes

 * A non-initialized connection (e.g. one that failed early because client-provided
   payload wasn't a valid MQTT payload) produced a crash report log entry during termination.

   GitHub issue: [rabbitmq-mqtt#134](https://github.com/rabbitmq/rabbitmq-mqtt/issues/134)


### LDAP Plugin

#### Bug Fixes

 * Stale connection purging in LDAP connection pool could fail
   with a `badmatch`.

   GitHub issue: [rabbitmq-auth-backend-ldap#66](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/66)


### Trust Store Plugin

#### Enhancements

 * Certificate change detection algorithm no longer uses `stat(2)` on certificate directory because
   of its limitations that could lead to undetected changes in certain scenarios.

   GitHub issue: [rabbitmq-trust-store#58](https://github.com/rabbitmq/rabbitmq-trust-store/issues/58)


### Web STOMP Plugin

#### Bug Fixes

 * The plugin failed to start after being stopped and re-enabled.

   GitHub issue: [rabbitmq-web-stomp#72](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/72)

 * Server-initiated [consumer cancellation](https://www.rabbitmq.com/consumer-cancel.html) failed with
   an exception.

   GitHub issue: [rabbitmq-web-stomp#75](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/75)


### Top Plugin

#### Bug Fixes

 * Node selection control used the wrong HTTP API path.

   GitHub issue: [rabbitmq-top#15](https://github.com/rabbitmq/rabbitmq-top/issues/15)


### Management Visualiser Plugin

#### Bug Fixes

  * The plugin wasn't compatible with recent `3.6.x` releases.

    GitHub issue: [rabbitmq-management-visualiser#8](https://github.com/rabbitmq/rabbitmq-management-visualiser/issues/8)



## Upgrading

To upgrade a non-clustered RabbitMQ simply install the new version. All configuration and persistent message data are retained. When upgrading using definitions export/import from versions earlier than 3.6.0, see http://rabbitmq.com/passwords.html.

To upgrade a RabbitMQ cluster, follow the instructions [in RabbitMQ documentation](https://www.rabbitmq.com/clustering.html#upgrading).

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.6.10.tar.gz`.
