package hardwaresecuritymodules

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// IdentityTypeApplication ...
	IdentityTypeApplication IdentityType = "Application"
	// IdentityTypeKey ...
	IdentityTypeKey IdentityType = "Key"
	// IdentityTypeManagedIdentity ...
	IdentityTypeManagedIdentity IdentityType = "ManagedIdentity"
	// IdentityTypeUser ...
	IdentityTypeUser IdentityType = "User"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{IdentityTypeApplication, IdentityTypeKey, IdentityTypeManagedIdentity, IdentityTypeUser}
}

// JSONWebKeyType enumerates the values for json web key type.
type JSONWebKeyType string

const (
	// JSONWebKeyTypeAllocating A device is currently being allocated for the dedicated HSM resource.
	JSONWebKeyTypeAllocating JSONWebKeyType = "Allocating"
	// JSONWebKeyTypeCheckingQuota Validating the subscription has sufficient quota to allocate a dedicated HSM
	// device.
	JSONWebKeyTypeCheckingQuota JSONWebKeyType = "CheckingQuota"
	// JSONWebKeyTypeConnecting The dedicated HSM is being connected to the virtual network.
	JSONWebKeyTypeConnecting JSONWebKeyType = "Connecting"
	// JSONWebKeyTypeDeleting The dedicated HSM is currently being deleted.
	JSONWebKeyTypeDeleting JSONWebKeyType = "Deleting"
	// JSONWebKeyTypeFailed Provisioning of the dedicated HSM has failed.
	JSONWebKeyTypeFailed JSONWebKeyType = "Failed"
	// JSONWebKeyTypeProvisioning The dedicated HSM is currently being provisioned.
	JSONWebKeyTypeProvisioning JSONWebKeyType = "Provisioning"
	// JSONWebKeyTypeSucceeded The dedicated HSM has been full provisioned.
	JSONWebKeyTypeSucceeded JSONWebKeyType = "Succeeded"
)

// PossibleJSONWebKeyTypeValues returns an array of possible values for the JSONWebKeyType const type.
func PossibleJSONWebKeyTypeValues() []JSONWebKeyType {
	return []JSONWebKeyType{JSONWebKeyTypeAllocating, JSONWebKeyTypeCheckingQuota, JSONWebKeyTypeConnecting, JSONWebKeyTypeDeleting, JSONWebKeyTypeFailed, JSONWebKeyTypeProvisioning, JSONWebKeyTypeSucceeded}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNamePayShield10KLMK1CPS250 The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware
	// Platform device with 1 local master key which supports up to 250 calls per second.
	SkuNamePayShield10KLMK1CPS250 SkuName = "payShield10K_LMK1_CPS250"
	// SkuNamePayShield10KLMK1CPS2500 The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet
	// Hardware Platform device with 1 local master key which supports up to 2500 calls per second.
	SkuNamePayShield10KLMK1CPS2500 SkuName = "payShield10K_LMK1_CPS2500"
	// SkuNamePayShield10KLMK1CPS60 The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware
	// Platform device with 1 local master key which supports up to 60 calls per second.
	SkuNamePayShield10KLMK1CPS60 SkuName = "payShield10K_LMK1_CPS60"
	// SkuNamePayShield10KLMK2CPS250 The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware
	// Platform device with 2 local master keys which supports up to 250 calls per second.
	SkuNamePayShield10KLMK2CPS250 SkuName = "payShield10K_LMK2_CPS250"
	// SkuNamePayShield10KLMK2CPS2500 The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet
	// Hardware Platform device with 2 local master keys which supports up to 2500 calls per second.
	SkuNamePayShield10KLMK2CPS2500 SkuName = "payShield10K_LMK2_CPS2500"
	// SkuNamePayShield10KLMK2CPS60 The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware
	// Platform device with 2 local master keys which supports up to 60 calls per second.
	SkuNamePayShield10KLMK2CPS60 SkuName = "payShield10K_LMK2_CPS60"
	// SkuNameSafeNetLunaNetworkHSMA790 The dedicated HSM is a Safenet Luna Network HSM A790 device.
	SkuNameSafeNetLunaNetworkHSMA790 SkuName = "SafeNet Luna Network HSM A790"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNamePayShield10KLMK1CPS250, SkuNamePayShield10KLMK1CPS2500, SkuNamePayShield10KLMK1CPS60, SkuNamePayShield10KLMK2CPS250, SkuNamePayShield10KLMK2CPS2500, SkuNamePayShield10KLMK2CPS60, SkuNameSafeNetLunaNetworkHSMA790}
}
