// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>An image block that contains images that you want to assess with a guardrail.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct GuardrailConverseImageBlock {
    /// <p>The format details for the image type of the guardrail converse image block.</p>
    pub format: crate::types::GuardrailConverseImageFormat,
    /// <p>The image source (image bytes) of the guardrail converse image block.</p>
    pub source: ::std::option::Option<crate::types::GuardrailConverseImageSource>,
}
impl GuardrailConverseImageBlock {
    /// <p>The format details for the image type of the guardrail converse image block.</p>
    pub fn format(&self) -> &crate::types::GuardrailConverseImageFormat {
        &self.format
    }
    /// <p>The image source (image bytes) of the guardrail converse image block.</p>
    pub fn source(&self) -> ::std::option::Option<&crate::types::GuardrailConverseImageSource> {
        self.source.as_ref()
    }
}
impl ::std::fmt::Debug for GuardrailConverseImageBlock {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("GuardrailConverseImageBlock");
        formatter.field("format", &"*** Sensitive Data Redacted ***");
        formatter.field("source", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
impl GuardrailConverseImageBlock {
    /// Creates a new builder-style object to manufacture [`GuardrailConverseImageBlock`](crate::types::GuardrailConverseImageBlock).
    pub fn builder() -> crate::types::builders::GuardrailConverseImageBlockBuilder {
        crate::types::builders::GuardrailConverseImageBlockBuilder::default()
    }
}

/// A builder for [`GuardrailConverseImageBlock`](crate::types::GuardrailConverseImageBlock).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct GuardrailConverseImageBlockBuilder {
    pub(crate) format: ::std::option::Option<crate::types::GuardrailConverseImageFormat>,
    pub(crate) source: ::std::option::Option<crate::types::GuardrailConverseImageSource>,
}
impl GuardrailConverseImageBlockBuilder {
    /// <p>The format details for the image type of the guardrail converse image block.</p>
    /// This field is required.
    pub fn format(mut self, input: crate::types::GuardrailConverseImageFormat) -> Self {
        self.format = ::std::option::Option::Some(input);
        self
    }
    /// <p>The format details for the image type of the guardrail converse image block.</p>
    pub fn set_format(mut self, input: ::std::option::Option<crate::types::GuardrailConverseImageFormat>) -> Self {
        self.format = input;
        self
    }
    /// <p>The format details for the image type of the guardrail converse image block.</p>
    pub fn get_format(&self) -> &::std::option::Option<crate::types::GuardrailConverseImageFormat> {
        &self.format
    }
    /// <p>The image source (image bytes) of the guardrail converse image block.</p>
    /// This field is required.
    pub fn source(mut self, input: crate::types::GuardrailConverseImageSource) -> Self {
        self.source = ::std::option::Option::Some(input);
        self
    }
    /// <p>The image source (image bytes) of the guardrail converse image block.</p>
    pub fn set_source(mut self, input: ::std::option::Option<crate::types::GuardrailConverseImageSource>) -> Self {
        self.source = input;
        self
    }
    /// <p>The image source (image bytes) of the guardrail converse image block.</p>
    pub fn get_source(&self) -> &::std::option::Option<crate::types::GuardrailConverseImageSource> {
        &self.source
    }
    /// Consumes the builder and constructs a [`GuardrailConverseImageBlock`](crate::types::GuardrailConverseImageBlock).
    /// This method will fail if any of the following fields are not set:
    /// - [`format`](crate::types::builders::GuardrailConverseImageBlockBuilder::format)
    pub fn build(self) -> ::std::result::Result<crate::types::GuardrailConverseImageBlock, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::GuardrailConverseImageBlock {
            format: self.format.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "format",
                    "format was not specified but it is required when building GuardrailConverseImageBlock",
                )
            })?,
            source: self.source,
        })
    }
}
impl ::std::fmt::Debug for GuardrailConverseImageBlockBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("GuardrailConverseImageBlockBuilder");
        formatter.field("format", &"*** Sensitive Data Redacted ***");
        formatter.field("source", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
