/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.tools.ant.BuildException;
import org.dita.dost.invoker.CliException;
import org.dita.dost.invoker.Main;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.LangUtils;

abstract class Arguments {
    boolean useColor;
    File logFile;
    int msgOutputLevel = 2;
    File buildFile;
    Vector<String> listeners;
    boolean allowInput;
    boolean keepGoingMode;
    String loggerClassname;
    String inputHandlerClassname;
    boolean emacsMode = Configuration.configuration.getOrDefault("cli.log-format", "legacy").equals("fancy");
    Integer threadPriority;
    boolean proxy;
    boolean justPrintUsage;
    boolean justPrintVersion;
    boolean justPrintDiagnostics;
    final Map<String, Object> definedProps = new HashMap<String, Object>();
    int repeat = 1;

    Arguments() {
        this.useColor = this.getUseColor();
    }

    abstract String getUsage(boolean var1);

    abstract Arguments parse(String[] var1);

    boolean getUseColor() {
        String os = System.getProperty("os.name");
        if (os != null && os.startsWith("Windows")) {
            return false;
        }
        if (System.getenv("NO_COLOR") != null) {
            return false;
        }
        if (Objects.equals(System.getenv("TERM"), "dumb")) {
            return false;
        }
        if (System.console() == null) {
            return false;
        }
        return Boolean.parseBoolean(Configuration.configuration.getOrDefault("cli.color", "true"));
    }

    boolean isLongForm(String arg, String property) {
        String name = arg.contains("=") ? arg.substring(0, arg.indexOf(61)) : arg;
        return name.equals(property) || name.equals("-" + property);
    }

    void parseCommonOptions(String arg, Deque<String> args) {
        if (this.isLongForm(arg, "-help") || arg.equals("-h")) {
            this.justPrintUsage = true;
        } else if (this.isLongForm(arg, "-verbose") || arg.equals("-v")) {
            this.msgOutputLevel = 3;
        } else if (this.isLongForm(arg, "-debug") || arg.equals("-d")) {
            this.msgOutputLevel = 4;
        } else if (this.isLongForm(arg, "-emacs") || arg.equals("-e")) {
            this.emacsMode = true;
        } else if (this.isLongForm(arg, "-logfile") || arg.equals("-l")) {
            this.handleArgLogFile(arg, args);
        } else if (this.isLongForm(arg, "-buildfile") || this.isLongForm(arg, "-file")) {
            this.handleArgBuildFile(args);
        } else if (this.isLongForm(arg, "-listener")) {
            this.handleArgListener(args);
        } else if (this.isLongForm(arg, "-logger")) {
            this.handleArgLogger(args);
        } else if (this.isLongForm(arg, "-no-color")) {
            this.useColor = false;
        } else {
            throw new CliException(Main.locale.getString("help.error.unsupported_argument").formatted(arg), this.getUsage(false));
        }
    }

    void handleArgLogFile(String arg, Deque<String> args) {
        Map.Entry<String, String> entry = this.parse(arg, args);
        if (entry.getValue() == null || entry.getValue().isBlank()) {
            throw new BuildException("Missing value for log file " + entry.getKey());
        }
        this.logFile = new File(entry.getValue());
        this.useColor = false;
    }

    Map.Entry<String, String> parse(String arg, Deque<String> args) {
        String value;
        String name = arg;
        int posEq = name.indexOf("=");
        if (posEq > 0) {
            value = name.substring(posEq + 1);
            name = name.substring(0, posEq);
        } else {
            value = args.pop();
        }
        return LangUtils.pair(name, value);
    }

    void handleArgBuildFile(Deque<String> args) {
        String value = args.pop();
        if (value == null) {
            throw new BuildException("You must specify a buildfile when using the --buildfile argument");
        }
        this.buildFile = new File(value.replace('/', File.separatorChar));
    }

    void handleArgListener(Deque<String> args) {
        String value = args.pop();
        if (value == null) {
            throw new BuildException("You must specify a classname when using the --listener argument");
        }
        this.listeners.addElement(value);
    }

    private void handleArgLogger(Deque<String> args) {
        if (this.loggerClassname != null) {
            throw new BuildException("Only one logger class may be specified.");
        }
        this.loggerClassname = args.pop();
        if (this.loggerClassname == null) {
            throw new BuildException("You must specify a classname when using the -logger argument");
        }
    }

    String getArgumentName(String arg) {
        int pos = arg.indexOf("=");
        if (pos == -1) {
            pos = arg.indexOf(":");
        }
        return arg.substring(0, pos != -1 ? pos : arg.length());
    }

    static class FileOrUriArgument
    extends Argument {
        FileOrUriArgument(String property, String desc) {
            super(property, desc);
        }

        @Override
        String getValue(String value) {
            try {
                Path f = Paths.get(value, new String[0]).toAbsolutePath().normalize();
                if (Files.exists(f, new LinkOption[0])) {
                    return f.toString();
                }
                return value;
            }
            catch (InvalidPathException e) {
                return value;
            }
        }
    }

    static class AbsoluteFileListArgument
    extends Argument {
        AbsoluteFileListArgument(String property, String desc) {
            super(property, desc);
        }

        @Override
        String getValue(String value) {
            return Arrays.stream(value.split(File.pathSeparator)).map(oneFile -> new File((String)oneFile).getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
        }
    }

    static class AbsoluteFileArgument
    extends Argument {
        AbsoluteFileArgument(String property, String desc) {
            super(property, desc);
        }

        @Override
        String getValue(String value) {
            return Paths.get(value, new String[0]).toAbsolutePath().normalize().toString();
        }
    }

    static class FileArgument
    extends Argument {
        FileArgument(String property, String desc) {
            super(property, desc);
        }

        @Override
        String getValue(String value) {
            return Paths.get(value, new String[0]).normalize().toString();
        }
    }

    static class EnumArgument
    extends Argument {
        final Set<String> values;

        EnumArgument(String property, String desc, Set<String> values) {
            super(property, desc);
            this.values = values;
        }

        @Override
        String getValue(String value) {
            if (!this.values.contains(value)) {
                throw new BuildException("Invalid value for property " + this.property + ": " + value);
            }
            return value;
        }
    }

    static class BooleanArgument
    extends Argument {
        final String trueValue;
        final String falseValue;

        BooleanArgument(String property, String desc, String trueValue, String falseValue) {
            super(property, desc);
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        String getValue(String value) {
            return switch (value.toLowerCase()) {
                case "true", "yes", "on", "1" -> this.trueValue;
                default -> this.falseValue;
            };
        }
    }

    static class StringArgument
    extends Argument {
        StringArgument(String property, String desc) {
            super(property, desc);
        }

        @Override
        String getValue(String value) {
            return value;
        }
    }

    static abstract class Argument {
        final String property;
        final String desc;

        Argument(String property, String desc) {
            this.property = property;
            this.desc = desc;
        }

        abstract String getValue(String var1);
    }
}

