/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.trialPromotion;

import com.intellij.ide.ui.laf.darcula.DarculaNewUIUtil;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 *2\u00020\u0001:\u0002)*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010!\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\b\u0010(\u001a\u00020&H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR2\u0010\u0016\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00152\r\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/platform/trialPromotion/TrialStateButton;", "Ljavax/swing/JComponent;", "<init>", "()V", "borderColor", "Ljava/awt/Color;", "getBorderColor", "()Ljava/awt/Color;", "setBorderColor", "(Ljava/awt/Color;)V", "hoverForeground", "getHoverForeground", "setHoverForeground", "hoverBackground", "getHoverBackground", "setHoverBackground", "hoverBorderColor", "getHoverBorderColor", "setHoverBorderColor", "value", "", "Lcom/intellij/openapi/util/NlsContexts$Button;", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "hovered", "", "colorState", "Lcom/intellij/platform/trialPromotion/TrialStateButton$ColorState;", "setColorState", "", "updateUI", "paintComponent", "g", "Ljava/awt/Graphics;", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "getTextDimension", "ColorState", "Companion", "intellij.platform.trialPromotion"})
@ApiStatus.Internal
public final class TrialStateButton
extends JComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Color borderColor;
    @Nullable
    private Color hoverForeground;
    @Nullable
    private Color hoverBackground;
    @Nullable
    private Color hoverBorderColor;
    @Nullable
    private String text;
    private boolean hovered;
    @Nullable
    private ColorState colorState;
    public static final double FACTOR = 0.8;
    @NotNull
    private static final UnscaledGaps TEXT_GAPS = UnscaledGapsKt.UnscaledGaps((int)4, (int)16, (int)3, (int)16);
    private static final int DEFAULT_FONT_SIZE = 13;
    private static final float BORDER_SIZE = 1.5f;

    public TrialStateButton() {
        this.setOpaque(false);
        this.setFont((Font)JBFont.regular().deriveFont(13.0f));
        this.setColorState(ColorState.DEFAULT);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                hovered = true;
                this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                hovered = false;
                this.repaint();
            }
        });
    }

    @Nullable
    public final Color getBorderColor() {
        return this.borderColor;
    }

    public final void setBorderColor(@Nullable Color color) {
        this.borderColor = color;
    }

    @Nullable
    public final Color getHoverForeground() {
        return this.hoverForeground;
    }

    public final void setHoverForeground(@Nullable Color color) {
        this.hoverForeground = color;
    }

    @Nullable
    public final Color getHoverBackground() {
        return this.hoverBackground;
    }

    public final void setHoverBackground(@Nullable Color color) {
        this.hoverBackground = color;
    }

    @Nullable
    public final Color getHoverBorderColor() {
        return this.hoverBorderColor;
    }

    public final void setHoverBorderColor(@Nullable Color color) {
        this.hoverBorderColor = color;
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String value) {
        if (!Intrinsics.areEqual((Object)this.text, (Object)value)) {
            this.text = value;
            this.revalidate();
            this.repaint();
        }
    }

    public final void setColorState(@NotNull ColorState colorState) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorState), (String)"colorState");
        if (colorState == this.colorState) {
            return;
        }
        this.colorState = colorState;
        boolean themeHasColor = UIManager.get("TrialWidget.Default.foreground") != null;
        switch (WhenMappings.$EnumSwitchMapping$0[colorState.ordinal()]) {
            case 1: {
                if (themeHasColor) {
                    this.setForeground(JBUI.CurrentTheme.TrialWidget.Default.FOREGROUND);
                    this.setBackground(JBUI.CurrentTheme.TrialWidget.Default.BACKGROUND);
                    this.borderColor = JBUI.CurrentTheme.TrialWidget.Default.BORDER_COLOR;
                    this.hoverForeground = JBUI.CurrentTheme.TrialWidget.Default.HOVER_FOREGROUND;
                    this.hoverBackground = JBUI.CurrentTheme.TrialWidget.Default.HOVER_BACKGROUND;
                    this.hoverBorderColor = JBUI.CurrentTheme.TrialWidget.Default.HOVER_BORDER_COLOR;
                    break;
                }
                this.setForeground(UIManager.getColor("Panel.foreground"));
                this.setBackground(UIManager.getColor("Panel.background"));
                this.borderColor = UIManager.getColor("Panel.foreground");
                this.hoverForeground = UIManager.getColor("Panel.foreground");
                this.hoverBackground = JBUI.CurrentTheme.ActionButton.hoverBackground();
                this.hoverBorderColor = UIManager.getColor("Panel.foreground");
                break;
            }
            case 2: {
                if (themeHasColor) {
                    this.setForeground(JBUI.CurrentTheme.TrialWidget.Active.FOREGROUND);
                    this.setBackground(JBUI.CurrentTheme.TrialWidget.Active.BACKGROUND);
                    this.borderColor = JBUI.CurrentTheme.TrialWidget.Active.BORDER_COLOR;
                    this.hoverForeground = JBUI.CurrentTheme.TrialWidget.Active.HOVER_FOREGROUND;
                    this.hoverBackground = JBUI.CurrentTheme.TrialWidget.Active.HOVER_BACKGROUND;
                    this.hoverBorderColor = JBUI.CurrentTheme.TrialWidget.Active.HOVER_BORDER_COLOR;
                    break;
                }
                Color color = UIManager.getColor("Panel.foreground");
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
                this.setForeground(Companion.greener(color));
                Color color2 = UIManager.getColor("Panel.background");
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getColor(...)");
                this.setBackground(Companion.greener(color2));
                this.borderColor = this.getForeground();
                this.hoverForeground = this.getForeground();
                Color color3 = JBUI.CurrentTheme.ActionButton.hoverBackground();
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"hoverBackground(...)");
                this.hoverBackground = Companion.greener(color3);
                this.hoverBorderColor = this.getForeground();
                break;
            }
            case 3: {
                if (themeHasColor) {
                    this.setForeground(JBUI.CurrentTheme.TrialWidget.Alert.FOREGROUND);
                    this.setBackground(JBUI.CurrentTheme.TrialWidget.Alert.BACKGROUND);
                    this.borderColor = JBUI.CurrentTheme.TrialWidget.Alert.BORDER_COLOR;
                    this.hoverForeground = JBUI.CurrentTheme.TrialWidget.Alert.HOVER_FOREGROUND;
                    this.hoverBackground = JBUI.CurrentTheme.TrialWidget.Alert.HOVER_BACKGROUND;
                    this.hoverBorderColor = JBUI.CurrentTheme.TrialWidget.Alert.HOVER_BORDER_COLOR;
                    break;
                }
                Color color = UIManager.getColor("Panel.foreground");
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
                this.setForeground(Companion.yellower(color));
                this.setBackground(JBUI.CurrentTheme.Banner.WARNING_BACKGROUND);
                this.borderColor = JBUI.CurrentTheme.Banner.WARNING_BORDER_COLOR;
                this.hoverForeground = this.getForeground();
                this.hoverBackground = JBUI.CurrentTheme.Banner.WARNING_BACKGROUND.brighter();
                this.hoverBorderColor = JBUI.CurrentTheme.Banner.WARNING_BORDER_COLOR.brighter();
                break;
            }
            case 4: {
                if (themeHasColor) {
                    this.setForeground(JBUI.CurrentTheme.TrialWidget.Expiring.FOREGROUND);
                    this.setBackground(JBUI.CurrentTheme.TrialWidget.Expiring.BACKGROUND);
                    this.borderColor = JBUI.CurrentTheme.TrialWidget.Expiring.BORDER_COLOR;
                    this.hoverForeground = JBUI.CurrentTheme.TrialWidget.Expiring.HOVER_FOREGROUND;
                    this.hoverBackground = JBUI.CurrentTheme.TrialWidget.Expiring.HOVER_BACKGROUND;
                    this.hoverBorderColor = JBUI.CurrentTheme.TrialWidget.Expiring.HOVER_BORDER_COLOR;
                    break;
                }
                Color color = UIManager.getColor("Panel.foreground");
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
                this.setForeground(Companion.redder(color));
                this.setBackground(JBUI.CurrentTheme.Banner.ERROR_BACKGROUND);
                this.borderColor = this.getBackground();
                this.hoverForeground = this.getForeground();
                this.hoverBorderColor = this.hoverBackground = JBUI.CurrentTheme.Banner.ERROR_BACKGROUND.brighter();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.repaint();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        ColorState currentColorState = this.colorState;
        if (currentColorState != null) {
            this.colorState = null;
            this.setColorState(currentColorState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle rect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        float arc = this.getHeight();
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            Color background;
            DarculaNewUIUtil.INSTANCE.setupRenderingHints(g2);
            Color borderColor = this.hovered ? this.hoverBorderColor : this.borderColor;
            Color color = background = this.hovered ? this.hoverBackground : this.getBackground();
            if (borderColor == null || borderColor.getAlpha() == 0 || Intrinsics.areEqual((Object)background, (Object)borderColor)) {
                Color color2 = background;
                if (color2 != null) {
                    Color it = color2;
                    boolean bl = false;
                    DarculaNewUIUtil.INSTANCE.fillRoundedRectangle((Graphics)g2, rect, it, arc);
                }
            } else {
                Color color3 = background;
                if (color3 != null) {
                    Color it = color3;
                    boolean bl = false;
                    DarculaNewUIUtil.INSTANCE.fillInsideComponentBorder((Graphics)g2, rect, it, arc);
                }
                DarculaNewUIUtil.INSTANCE.drawRoundedRectangle((Graphics)g2, rect, borderColor, arc, 1.5f);
            }
            String string = this.text;
            if (string != null) {
                String it = string;
                boolean bl = false;
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int offset = (rect.height - TEXT_GAPS.getHeight() - this.getFontMetrics(this.getFont()).getHeight()) / 2;
                g2.setColor(this.hovered ? this.hoverForeground : this.getForeground());
                g2.setFont(this.getFont());
                g2.drawString(it, TEXT_GAPS.getLeft(), TEXT_GAPS.getTop() + offset + fontMetrics.getAscent());
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension textDimension = this.getTextDimension();
        return new Dimension(textDimension.width + TEXT_GAPS.getWidth(), textDimension.height + TEXT_GAPS.getHeight());
    }

    private final Dimension getTextDimension() {
        Font font = this.getFont();
        if (font == null) {
            return new Dimension(0, 13);
        }
        Font font2 = font;
        String text = this.text;
        FontMetrics fontMetrics = this.getFontMetrics(font2);
        String string = text;
        int width = string == null ? 0 : fontMetrics.stringWidth(string);
        return new Dimension(width, fontMetrics.getHeight());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/trialPromotion/TrialStateButton$ColorState;", "", "<init>", "(Ljava/lang/String;I)V", "DEFAULT", "ACTIVE_OR_AVAILABLE", "ALERT", "EXPIRING", "intellij.platform.trialPromotion"})
    public static final class ColorState
    extends Enum<ColorState> {
        public static final /* enum */ ColorState DEFAULT = new ColorState();
        public static final /* enum */ ColorState ACTIVE_OR_AVAILABLE = new ColorState();
        public static final /* enum */ ColorState ALERT = new ColorState();
        public static final /* enum */ ColorState EXPIRING = new ColorState();
        private static final /* synthetic */ ColorState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ColorState[] values() {
            return (ColorState[])$VALUES.clone();
        }

        public static ColorState valueOf(String value) {
            return Enum.valueOf(ColorState.class, value);
        }

        @NotNull
        public static EnumEntries<ColorState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = colorStateArray = new ColorState[]{ColorState.DEFAULT, ColorState.ACTIVE_OR_AVAILABLE, ColorState.ALERT, ColorState.EXPIRING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0007J\n\u0010\b\u001a\u00020\u0007*\u00020\u0007J\n\u0010\t\u001a\u00020\u0007*\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/trialPromotion/TrialStateButton$Companion;", "", "<init>", "()V", "FACTOR", "", "greener", "Ljava/awt/Color;", "redder", "yellower", "TEXT_GAPS", "Lcom/intellij/ui/dsl/gridLayout/UnscaledGaps;", "DEFAULT_FONT_SIZE", "", "BORDER_SIZE", "", "intellij.platform.trialPromotion"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color greener(@NotNull Color $this$greener) {
            Intrinsics.checkNotNullParameter((Object)$this$greener, (String)"<this>");
            return new Color($this$greener.getRed(), Math.min((int)((double)$this$greener.getGreen() / 0.8), 255), $this$greener.getBlue(), $this$greener.getAlpha());
        }

        @NotNull
        public final Color redder(@NotNull Color $this$redder) {
            Intrinsics.checkNotNullParameter((Object)$this$redder, (String)"<this>");
            return new Color(Math.min((int)((double)$this$redder.getRed() / 0.8), 255), $this$redder.getGreen(), $this$redder.getBlue(), $this$redder.getAlpha());
        }

        @NotNull
        public final Color yellower(@NotNull Color $this$yellower) {
            Intrinsics.checkNotNullParameter((Object)$this$yellower, (String)"<this>");
            return new Color(Math.min((int)((double)$this$yellower.getRed() / 0.8), 255), Math.min((int)((double)$this$yellower.getGreen() / 0.8), 255), $this$yellower.getBlue(), $this$yellower.getAlpha());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorState.values().length];
            try {
                nArray[ColorState.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorState.ACTIVE_OR_AVAILABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorState.ALERT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorState.EXPIRING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

