/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.impl.view.transformation;

import com.intellij.dataWrangler.impl.view.transformation.TransformationsNode;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0003\b\t\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/dataWrangler/impl/view/transformation/TransformationsTree;", "Lcom/intellij/ui/treeStructure/Tree;", "<init>", "()V", "treeMouseAdapter", "Lcom/intellij/dataWrangler/impl/view/transformation/TransformationsTree$TransformationTreeMouseAdapter;", "getToggleClickCount", "", "TransformationCellRenderer", "TransformationTreeMouseAdapter", "Companion", "intellij.dataWrangler.impl"})
public final class TransformationsTree
extends Tree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransformationTreeMouseAdapter treeMouseAdapter = new TransformationTreeMouseAdapter(this);
    public static final int CLICK_TO_SWIPE_COUNT = 1;
    public static final int CLICK_TO_EXPAND_COUNT = 1;
    private static final int POPUP_WIDTH = 250;
    private static final int POPUP_RIGHT_SHIFT = 3;

    public TransformationsTree() {
        this.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        this.setRootVisible(false);
        this.selectionModel.setSelectionMode(1);
        this.showsRootHandles = true;
        this.addMouseListener(this.treeMouseAdapter);
        this.addMouseMotionListener(this.treeMouseAdapter);
        UIUtil.setCursor((Component)((Component)((Object)this)), (Cursor)Cursor.getPredefinedCursor(12));
        this.cellRenderer = (TreeCellRenderer)((Object)new TransformationCellRenderer());
        this.updateUI();
    }

    public int getToggleClickCount() {
        return 1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/dataWrangler/impl/view/transformation/TransformationsTree$Companion;", "", "<init>", "()V", "CLICK_TO_SWIPE_COUNT", "", "CLICK_TO_EXPAND_COUNT", "POPUP_WIDTH", "POPUP_RIGHT_SHIFT", "intellij.dataWrangler.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/dataWrangler/impl/view/transformation/TransformationsTree$TransformationCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "<init>", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.dataWrangler.impl"})
    private static final class TransformationCellRenderer
    extends ColoredTreeCellRenderer {
        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            TransformationsNode transformationsNode = value instanceof TransformationsNode ? (TransformationsNode)value : null;
            if (transformationsNode == null) {
                return;
            }
            TransformationsNode node = transformationsNode;
            TransformationsNode.TransformationsNodeDescriptor transformationsNodeDescriptor = ((TransformationsNode)value).getUserObject();
            if (transformationsNodeDescriptor == null) {
                return;
            }
            TransformationsNode.TransformationsNodeDescriptor item = transformationsNodeDescriptor;
            this.append(item.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
            if (!node.isLeaf()) {
                this.append(" " + node.getChildCount(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            this.setIcon(item.getIcon());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\b\b\u0001\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u00020\t*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/dataWrangler/impl/view/transformation/TransformationsTree$TransformationTreeMouseAdapter;", "Ljava/awt/event/MouseAdapter;", "tree", "Lcom/intellij/dataWrangler/impl/view/transformation/TransformationsTree;", "<init>", "(Lcom/intellij/dataWrangler/impl/view/transformation/TransformationsTree;)V", "descriptionBalloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "mouseMoved", "", "event", "Ljava/awt/event/MouseEvent;", "mouseExited", "e", "createDescriptionBalloonIfPossible", "path", "Ljavax/swing/tree/TreePath;", "createDescriptionBalloon", "description", "", "calculateBalloonLocation", "Lcom/intellij/ui/awt/RelativePoint;", "balloon", "nodeBounds", "Ljava/awt/Rectangle;", "showNextToNodeBounds", "intellij.dataWrangler.impl"})
    @SourceDebugExtension(value={"SMAP\nTransformationsTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransformationsTree.kt\ncom/intellij/dataWrangler/impl/view/transformation/TransformationsTree$TransformationTreeMouseAdapter\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,146:1\n19#2:147\n*S KotlinDebug\n*F\n+ 1 TransformationsTree.kt\ncom/intellij/dataWrangler/impl/view/transformation/TransformationsTree$TransformationTreeMouseAdapter\n*L\n83#1:147\n*E\n"})
    private static final class TransformationTreeMouseAdapter
    extends MouseAdapter {
        @NotNull
        private final TransformationsTree tree;
        @Nullable
        private Balloon descriptionBalloon;

        public TransformationTreeMouseAdapter(@NotNull TransformationsTree tree) {
            Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
            this.tree = tree;
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TreePath path = this.tree.getClosestPathForLocation(event.getX(), event.getY());
            if (!Intrinsics.areEqual((Object)path, (Object)this.tree.getSelectionPath())) {
                this.tree.setSelectionPath(path);
                Rectangle rectangle = this.tree.getPathBounds(path);
                if (rectangle == null) {
                    return;
                }
                Rectangle nodeBounds = rectangle;
                Balloon balloon = this.descriptionBalloon;
                if (balloon != null) {
                    balloon.hide();
                }
                Balloon balloon2 = this.descriptionBalloon = this.createDescriptionBalloonIfPossible(path);
                if (balloon2 != null) {
                    this.showNextToNodeBounds(balloon2, nodeBounds);
                }
                event.consume();
            }
        }

        @Override
        public void mouseExited(@Nullable MouseEvent e) {
            block1: {
                Balloon balloon = this.descriptionBalloon;
                if (balloon != null) {
                    balloon.hide();
                }
                this.tree.setSelectionPath(null);
                MouseEvent mouseEvent = e;
                if (mouseEvent == null) break block1;
                mouseEvent.consume();
            }
        }

        private final Balloon createDescriptionBalloonIfPossible(TreePath path) {
            TreePath treePath = path;
            Object $this$asSafely$iv = treePath != null ? treePath.getLastPathComponent() : null;
            boolean $i$f$asSafely = false;
            Object object = $this$asSafely$iv;
            if (!(object instanceof TransformationsNode)) {
                object = null;
            }
            TransformationsNode transformationsNode = (TransformationsNode)object;
            if (transformationsNode == null) {
                return null;
            }
            TransformationsNode node = transformationsNode;
            TransformationsNode.TransformationsNodeDescriptor transformationsNodeDescriptor = node.getUserObject();
            if (transformationsNodeDescriptor == null) {
                return null;
            }
            TransformationsNode.TransformationsNodeDescriptor item = transformationsNodeDescriptor;
            if (item instanceof TransformationsNode.CommandNodeDescriptor) {
                String string = ((TransformationsNode.CommandNodeDescriptor)item).getCommand().getDescription();
                if (string == null) {
                    return null;
                }
                String description = string;
                return this.createDescriptionBalloon(description);
            }
            return null;
        }

        @NotNull
        public final Balloon createDescriptionBalloon(@NlsContexts.DetailedDescription @NotNull String description) {
            JBTextArea jBTextArea;
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            JBTextArea $this$createDescriptionBalloon_u24lambda_u240 = jBTextArea = new JBTextArea(description);
            boolean bl = false;
            $this$createDescriptionBalloon_u24lambda_u240.setEditable(false);
            $this$createDescriptionBalloon_u24lambda_u240.setOpaque(false);
            $this$createDescriptionBalloon_u24lambda_u240.setLineWrap(true);
            $this$createDescriptionBalloon_u24lambda_u240.setWrapStyleWord(true);
            $this$createDescriptionBalloon_u24lambda_u240.setFont(RelativeFont.NORMAL.derive(UIUtil.getToolTipFont()));
            JBTextArea textArea = jBTextArea;
            int popupWidth = JBUI.scale((int)250);
            FontMetrics fontMetrics = textArea.getFontMetrics(textArea.getFont());
            int textWidth = fontMetrics.stringWidth(description);
            int lineHeight = fontMetrics.getHeight();
            int estimatedLines = (int)Math.ceil((double)textWidth / (double)popupWidth);
            int requiredHeight = estimatedLines * lineHeight;
            textArea.setPreferredSize(new Dimension(popupWidth, requiredHeight));
            JBTextArea content = textArea;
            Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)content).setFillColor(UIUtil.getToolTipBackground()).setBorderColor(UIUtil.getToolTipBackground()).setAnimationCycle(0).setHideOnAction(false).setHideOnKeyOutside(false).setHideOnLinkClick(false).setHideOnClickOutside(true).setShowCallout(false).setShadow(false).setCornerRadius(JBUI.CurrentTheme.GotItTooltip.CORNER_RADIUS.get()).createBalloon();
            Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
            return balloon;
        }

        private final RelativePoint calculateBalloonLocation(Balloon balloon, Rectangle nodeBounds) {
            int balloonHeight = balloon.getPreferredSize().height;
            int balloonWidth = balloon.getPreferredSize().width;
            int shiftToRight = JBUI.scale((int)3);
            return new RelativePoint((Component)((Object)this.tree), new Point(-balloonWidth / 2 + shiftToRight, nodeBounds.y + balloonHeight / 2));
        }

        public final void showNextToNodeBounds(@NotNull Balloon $this$showNextToNodeBounds, @NotNull Rectangle nodeBounds) {
            Intrinsics.checkNotNullParameter((Object)$this$showNextToNodeBounds, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)nodeBounds, (String)"nodeBounds");
            RelativePoint point = this.calculateBalloonLocation($this$showNextToNodeBounds, nodeBounds);
            $this$showNextToNodeBounds.show(point, Balloon.Position.atLeft);
        }
    }
}

