/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TestHackHelper;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDateCheckWithSuggestionsFilter
extends RuleFilter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDateCheckWithSuggestionsFilter.class);
    protected static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d+).*");

    protected abstract int getDayOfWeek(String var1);

    protected abstract String getDayOfWeek(Calendar var1);

    protected int getDayOfMonth(String localizedDayOfMonth) {
        return 0;
    }

    protected abstract int getMonth(String var1);

    protected abstract Calendar getCalendar();

    protected abstract String getErrorMessageWrongYear();

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> args, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) {
        try {
            String yearStr;
            String monthStr;
            String dayStr;
            int yearPos;
            int monthPos;
            int dayPos;
            int dayOfWeekPos = this.getSkipCorrectedReference(tokenPositions, Integer.parseInt(this.getRequired("weekDay", args)));
            String dayOfWeekStr = patternTokens[dayOfWeekPos].getToken().replace("\u00ad", "");
            boolean isFullDateToken = false;
            int fullDatePos = this.getSkipCorrectedReference(tokenPositions, Integer.parseInt(this.getOptional("date", args, "-1")));
            if (fullDatePos > -1) {
                String[] parts = patternTokens[fullDatePos].getToken().split("-");
                isFullDateToken = true;
                dayPos = fullDatePos;
                monthPos = fullDatePos;
                yearPos = fullDatePos;
                dayStr = parts[2];
                monthStr = parts[1];
                yearStr = parts[0];
            } else {
                dayPos = this.getSkipCorrectedReference(tokenPositions, Integer.parseInt(this.getRequired("day", args)));
                monthPos = this.getSkipCorrectedReference(tokenPositions, Integer.parseInt(this.getRequired("month", args)));
                yearPos = this.getSkipCorrectedReference(tokenPositions, Integer.parseInt(this.getOptional("year", args, "-1")));
                dayStr = patternTokens[dayPos].getToken();
                monthStr = patternTokens[monthPos].getToken();
                yearStr = yearPos > -1 ? patternTokens[yearPos].getToken() : null;
            }
            int dayOfWeekFromString = this.getDayOfWeek(dayOfWeekStr);
            int day = this.getDayOfMonthFromStr(dayStr);
            int month = this.getMonthFromStr(monthStr);
            int year = this.getYearFromStr(yearStr);
            Calendar dateFromDate = this.getDate(day, month, year);
            int dayOfWeekFromDate = this.getdayOfWeekFromDate(dateFromDate);
            if (dayOfWeekFromDate == -1) {
                return null;
            }
            if (dayOfWeekFromString != dayOfWeekFromDate) {
                String correctedDayofMonth;
                int endIndex;
                int startIndex;
                Calendar calFromDateString = Calendar.getInstance();
                calFromDateString.set(7, dayOfWeekFromString);
                int currentYear = this.getYearFromStr(null);
                Calendar dateFromDateChangeYear = this.getDate(day, month, currentYear);
                int dayOfWeekFromDateChangeYear = this.getdayOfWeekFromDate(dateFromDateChangeYear);
                if (dayOfWeekFromString == dayOfWeekFromDateChangeYear) {
                    String message = this.getErrorMessageWrongYear().replace("{currentYear}", String.valueOf(currentYear));
                    RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), patternTokens[yearPos].getStartPos(), patternTokens[yearPos].getEndPos(), message, match.getShortMessage());
                    ruleMatch.setType(match.getType());
                    ruleMatch.setUrl(Tools.getUrl("https://www.timeanddate.com/calendar/?year=" + dateFromDateChangeYear.get(1)));
                    if (isFullDateToken) {
                        ruleMatch.setSuggestedReplacement(String.valueOf(currentYear) + "-" + monthStr + "-" + dayStr);
                    } else {
                        ruleMatch.setSuggestedReplacement(String.valueOf(currentYear));
                    }
                    return ruleMatch;
                }
                String message = match.getMessage().replace("{realDay}", this.getDayOfWeek(dateFromDate)).replace("{day}", this.getDayOfWeek(calFromDateString)).replace("{currentYear}", Integer.toString(Calendar.getInstance().get(1)));
                if (dayOfWeekPos < dayPos) {
                    startIndex = dayOfWeekPos;
                    endIndex = dayPos;
                } else {
                    startIndex = dayPos;
                    endIndex = dayOfWeekPos;
                }
                RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), patternTokens[startIndex].getStartPos(), patternTokens[endIndex].getEndPos(), message, match.getShortMessage());
                ruleMatch.setType(match.getType());
                ruleMatch.setUrl(Tools.getUrl("https://www.timeanddate.com/calendar/?year=" + dateFromDate.get(1)));
                StringBuilder suggestion = new StringBuilder();
                boolean isFirst = true;
                for (int j = startIndex; j <= endIndex; ++j) {
                    if (isFirst) {
                        isFirst = false;
                    } else if (patternTokens[j].isWhitespaceBefore()) {
                        suggestion.append(" ");
                    }
                    if (j == dayOfWeekPos) {
                        suggestion.append(StringTools.preserveCase(this.getDayOfWeek(dateFromDate), dayOfWeekStr));
                        continue;
                    }
                    suggestion.append(patternTokens[j].getToken());
                }
                if (!suggestion.toString().isEmpty()) {
                    ruleMatch.setSuggestedReplacement(this.adjustSuggestion(suggestion.toString()));
                }
                if (!(correctedDayofMonth = this.findNewDayOfMonth(day, month, year, dayOfWeekFromString)).isEmpty()) {
                    suggestion = new StringBuilder();
                    isFirst = true;
                    for (int j = startIndex; j <= endIndex; ++j) {
                        if (isFirst) {
                            isFirst = false;
                        } else if (patternTokens[j].isWhitespaceBefore()) {
                            suggestion.append(" ");
                        }
                        if (j == dayPos) {
                            if (isFullDateToken) {
                                suggestion.append(yearStr + "-" + monthStr + "-" + correctedDayofMonth);
                                continue;
                            }
                            suggestion.append(this.getDayStrLikeOriginal(correctedDayofMonth, dayStr));
                            continue;
                        }
                        suggestion.append(patternTokens[j].getToken());
                    }
                    if (!suggestion.toString().isEmpty()) {
                        ruleMatch.addSuggestedReplacement(this.adjustSuggestion(suggestion.toString()));
                    }
                }
                return ruleMatch;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String findNewDayOfMonth(int day, int month, int year, int dayOfWeekFromString) {
        for (int difference = 1; difference < 7; ++difference) {
            Calendar dateFromDate;
            int dayOfWeekFromDate;
            if (day - difference > 0 && dayOfWeekFromString == (dayOfWeekFromDate = this.getdayOfWeekFromDate(dateFromDate = this.getDate(day - difference, month, year)))) {
                return String.valueOf(day - difference);
            }
            if (day + difference >= 32 || dayOfWeekFromString != (dayOfWeekFromDate = this.getdayOfWeekFromDate(dateFromDate = this.getDate(day + difference, month, year)))) continue;
            return String.valueOf(day + difference);
        }
        return "";
    }

    private int getdayOfWeekFromDate(Calendar dateFromDate) {
        int dayOfWeekFromDate;
        try {
            dayOfWeekFromDate = dateFromDate.get(7);
        }
        catch (IllegalArgumentException ignore) {
            return -1;
        }
        return dayOfWeekFromDate;
    }

    protected Calendar getDate(int dayOfMonth, int month, int year) {
        Calendar calendar = this.getCalendar();
        calendar.setLenient(false);
        calendar.set(year, month, dayOfMonth, 0, 0, 0);
        return calendar;
    }

    private int getYearFromStr(String yearArg) {
        int year = yearArg == null && TestHackHelper.isJUnitTest() ? 2014 : (yearArg == null ? this.getCalendar().get(1) : Integer.parseInt(yearArg));
        return year;
    }

    private int getDayOfMonthFromStr(String dayOfMonthString) {
        Matcher matcherDayOfMonth = DAY_OF_MONTH_PATTERN.matcher(dayOfMonthString);
        int dayOfMonth = matcherDayOfMonth.matches() ? Integer.parseInt(matcherDayOfMonth.group(1)) : this.getDayOfMonth(dayOfMonthString);
        return dayOfMonth;
    }

    private int getMonthFromStr(String monthStr) {
        int month = StringUtils.isNumeric((CharSequence)monthStr) ? Integer.parseInt(monthStr) : this.getMonth(StringTools.trimSpecialCharacters(monthStr));
        return month - 1;
    }

    protected String getDayStrLikeOriginal(String day, String original) {
        return day;
    }

    protected String adjustSuggestion(String sugg) {
        return sugg;
    }
}

