/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.debugger;

import com.intellij.database.DbmsExtension;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.debugger.SqlDebugController;
import com.intellij.database.debugger.SqlDebugFunKt;
import com.intellij.database.debugger.SqlDebugProfile;
import com.intellij.database.debugger.SqlDebuggerFacade;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.run.audit.DatabaseSessionLogger;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0003\u000e\u000f\u0010J\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\f\u001a\u00020\rH&R \u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/debugger/SqlDebugSessionRunner;", "", "onFinish", "Lkotlin/Function0;", "", "getOnFinish", "()Lkotlin/jvm/functions/Function0;", "setOnFinish", "(Lkotlin/jvm/functions/Function0;)V", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "Handler", "SqlDebugAvailability", "Runner", "intellij.database.impl"})
public interface SqlDebugSessionRunner {
    @Nullable
    public Function0<Unit> getOnFinish();

    public void setOnFinish(@Nullable Function0<Unit> var1);

    @NotNull
    public Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0006*\u00020\nH\u0007J0\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cJV\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0018\u0010&\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0006\u0012\u0004\u0018\u00010(0'H\u0007JN\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0018\u0010&\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0006\u0012\u0004\u0018\u00010(0'H\u0002JB\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010+\u001a\u00020(2\u0006\u0010!\u001a\u00020\u001a2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#JL\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001a2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0,H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/database/debugger/SqlDebugSessionRunner$Handler;", "", "<init>", "()V", "FACADE_EP", "Lcom/intellij/database/DbmsExtension;", "Lcom/intellij/database/debugger/SqlDebuggerFacade;", "checkDebuggerAvailability", "Lcom/intellij/database/debugger/SqlDebugSessionRunner$SqlDebugAvailability;", "localDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "facade", "element", "Lcom/intellij/psi/PsiElement;", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "routine", "Lcom/intellij/database/model/basic/BasicSourceAware;", "obtainDebuggerFacadeWhenApplicable", "obtainActualScriptModel", "Lcom/intellij/database/script/ScriptModel;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "firstOnly", "", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "startDebugProcess", "", "transactionOwner", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "scriptIsMeaningful", "searchPath", "Lcom/intellij/database/util/SearchPath;", "consoleTitle", "", "requestFactory", "Lkotlin/Function1;", "Lcom/intellij/database/datagrid/GridDataRequest;", "createRunner", "Lcom/intellij/database/debugger/SqlDebugSessionRunner;", "request", "Lkotlin/Function0;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlDebugSessionRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlDebugSessionRunner.kt\ncom/intellij/database/debugger/SqlDebugSessionRunner$Handler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1#2:262\n*E\n"})
    public static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();
        @NotNull
        private static final DbmsExtension<SqlDebuggerFacade> FACADE_EP = new DbmsExtension("com.intellij.database.debuggerFacade");

        private Handler() {
        }

        @JvmStatic
        @NotNull
        public static final SqlDebugAvailability checkDebuggerAvailability(@NotNull LocalDataSource localDataSource, @NotNull SqlDebuggerFacade facade, @NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)localDataSource, (String)"localDataSource");
            Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            SqlStatement statement2 = (SqlStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, SqlStatement.class);
            if (statement2 == null) {
                return SqlDebugAvailability.DEBUGGER_INAPPLICABLE;
            }
            if (!facade.isApplicableToDebugStatement(statement2)) {
                return SqlDebugAvailability.DEBUGGER_INAPPLICABLE;
            }
            return facade.canDebug(localDataSource) ? SqlDebugAvailability.DEBUGGER_ENABLED : SqlDebugAvailability.DEBUGGER_DISABLED;
        }

        @JvmStatic
        @NotNull
        public static final SqlDebugAvailability checkDebuggerAvailability(@Nullable DasDataSource dataSource, @Nullable BasicSourceAware routine2) {
            SqlDebuggerFacade sqlDebuggerFacade;
            LocalDataSource localDataSource;
            block8: {
                block7: {
                    DasDataSource dasDataSource = dataSource;
                    if (dasDataSource != null) {
                        DasDataSource it = dasDataSource;
                        boolean bl = false;
                        v1 = DbImplUtil.getMaybeLocalDataSource((DasDataSource)it);
                    } else {
                        v1 = localDataSource = null;
                    }
                    if (localDataSource == null) break block7;
                    sqlDebuggerFacade = Handler.obtainDebuggerFacadeWhenApplicable(localDataSource);
                    if (sqlDebuggerFacade != null) break block8;
                }
                return SqlDebugAvailability.DEBUGGER_ABSENT;
            }
            SqlDebuggerFacade facade = sqlDebuggerFacade;
            if (routine2 == null) {
                return SqlDebugAvailability.DEBUGGER_INAPPLICABLE;
            }
            if (!facade.isApplicableToDebugRoutine(routine2)) {
                return SqlDebugAvailability.DEBUGGER_INAPPLICABLE;
            }
            return facade.canDebug(localDataSource) ? SqlDebugAvailability.DEBUGGER_ENABLED : SqlDebugAvailability.DEBUGGER_DISABLED;
        }

        @JvmStatic
        @Nullable
        public static final SqlDebuggerFacade obtainDebuggerFacadeWhenApplicable(@NotNull LocalDataSource $this$obtainDebuggerFacadeWhenApplicable) {
            Intrinsics.checkNotNullParameter((Object)$this$obtainDebuggerFacadeWhenApplicable, (String)"<this>");
            if (!SqlDebugFunKt.sqlDebuggerIsEnabled()) {
                return null;
            }
            return (SqlDebuggerFacade)FACADE_EP.forDbms($this$obtainDebuggerFacadeWhenApplicable.getDbms());
        }

        @Nullable
        public final ScriptModel<?> obtainActualScriptModel(@NotNull Project project, @NotNull VirtualFile virtualFile, boolean firstOnly, @Nullable RangeMarker rangeMarker) {
            RangeMarker range;
            Object object;
            FileDocumentManager fileDocumentManager;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            FileDocumentManager $this$obtainActualScriptModel_u24lambda_u243 = fileDocumentManager = FileDocumentManager.getInstance();
            boolean bl = false;
            Document document = $this$obtainActualScriptModel_u24lambda_u243.getCachedDocument(virtualFile);
            if (document != null) {
                Document doc = document;
                boolean bl2 = false;
                WriteAction.runAndWait(() -> Handler.obtainActualScriptModel$lambda$3$lambda$2$lambda$1($this$obtainActualScriptModel_u24lambda_u243, doc));
            }
            ScriptModel scriptModel = SqlPsiFacade.getInstance((Project)project).createScriptModel(virtualFile, null);
            Intrinsics.checkNotNullExpressionValue((Object)scriptModel, (String)"createScriptModel(...)");
            ScriptModel sm = scriptModel;
            if (firstOnly) {
                object = rangeMarker;
                if (object == null || (object = RangeMarkersKt.getAsTextRange((RangeMarker)object)) == null) {
                    JBIterable jBIterable = sm.statements();
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"statements(...)");
                    ScriptModel.StatementIt statementIt = (ScriptModel.StatementIt)CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable));
                    object = statementIt != null ? statementIt.range() : null;
                }
            } else {
                object = rangeMarker;
                if ((object == null || (object = RangeMarkersKt.getAsTextRange((RangeMarker)object)) == null) && (object = sm.getTextRange()) == null) {
                    object = new TextRange(0, (int)virtualFile.getLength());
                }
            }
            if ((range = object) == null) {
                return null;
            }
            return sm.subModel((TextRange)range);
        }

        public static /* synthetic */ ScriptModel obtainActualScriptModel$default(Handler handler2, Project project, VirtualFile virtualFile, boolean bl, RangeMarker rangeMarker, int n, Object object) {
            if ((n & 8) != 0) {
                rangeMarker = null;
            }
            return handler2.obtainActualScriptModel(project, virtualFile, bl, rangeMarker);
        }

        @JvmStatic
        public static final void startDebugProcess(@NotNull DatabaseSessionClient transactionOwner, boolean scriptIsMeaningful, @NotNull VirtualFile virtualFile, @Nullable RangeMarker rangeMarker, @Nullable SearchPath searchPath, @NotNull String consoleTitle, @NotNull Function1<? super ScriptModel<?>, ? extends GridDataRequest> requestFactory) {
            Intrinsics.checkNotNullParameter((Object)transactionOwner, (String)"transactionOwner");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)consoleTitle, (String)"consoleTitle");
            Intrinsics.checkNotNullParameter(requestFactory, (String)"requestFactory");
            DatabaseSession session = (DatabaseSession)transactionOwner.getSession();
            Project project = session.getProject();
            Object object = session.getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTarget(...)");
            DatabaseConnectionPoint connectionPoint = (DatabaseConnectionPoint)object;
            SqlDebugSessionRunner runner = INSTANCE.createRunner(transactionOwner, scriptIsMeaningful, virtualFile, rangeMarker, searchPath, requestFactory);
            Set set = JBIterable.from((Iterable)RunContentManager.getInstance((Project)project).getAllDescriptors()).map(arg_0 -> Handler.startDebugProcess$lambda$5(Handler::startDebugProcess$lambda$4, arg_0)).toSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
            Set existingTitles = set;
            String string = UniqueNameGenerator.generateUniqueName((String)consoleTitle, (String)"", (String)"", (String)" (", (String)")", arg_0 -> Handler.startDebugProcess$lambda$7(arg_0 -> Handler.startDebugProcess$lambda$6(existingTitles, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateUniqueName(...)");
            String uniqueTitle = string;
            Executor debugExecutor = DefaultDebugExecutor.getDebugExecutorInstance();
            try {
                AsyncProgramRunner<RunnerSettings> asyncRunner2 = new AsyncProgramRunner<RunnerSettings>(runner){
                    final /* synthetic */ SqlDebugSessionRunner $runner;
                    {
                        this.$runner = $runner;
                    }

                    protected Promise<RunContentDescriptor> execute(ExecutionEnvironment environment, RunProfileState state) {
                        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
                        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                        return this.$runner.execute(environment);
                    }

                    public String getRunnerId() {
                        return "sqlDebugSessionRunner";
                    }

                    public boolean canRun(String executorId, RunProfile profile) {
                        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
                        return false;
                    }
                };
                Intrinsics.checkNotNull((Object)debugExecutor);
                ExecutionEnvironmentBuilder executionEnvironmentBuilder = new ExecutionEnvironmentBuilder(project, debugExecutor);
                Icon icon = connectionPoint.getDataSource().getIcon();
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
                ExecutionEnvironment environment = ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)executionEnvironmentBuilder.runProfile((RunProfile)new SqlDebugProfile(consoleTitle, icon)).runner((ProgramRunner)asyncRunner2), null, (int)1, null);
                asyncRunner2.execute(environment);
            }
            catch (ExecutionException e) {
                ExecutionUtil.handleExecutionError((Project)project, (String)debugExecutor.getToolWindowId(), (String)uniqueTitle, (Throwable)e);
            }
        }

        private final SqlDebugSessionRunner createRunner(DatabaseSessionClient transactionOwner, boolean scriptIsMeaningful, VirtualFile virtualFile, RangeMarker rangeMarker, SearchPath searchPath, Function1<? super ScriptModel<?>, ? extends GridDataRequest> requestFactory) {
            return this.createRunner(transactionOwner, scriptIsMeaningful, virtualFile, rangeMarker, searchPath, (Function0<? extends GridDataRequest>)((Function0)() -> Handler.createRunner$lambda$9(transactionOwner, virtualFile, rangeMarker, requestFactory)));
        }

        @NotNull
        public final SqlDebugSessionRunner createRunner(@NotNull DatabaseSessionClient transactionOwner, @NotNull GridDataRequest request2, boolean scriptIsMeaningful, @Nullable VirtualFile virtualFile, @Nullable RangeMarker rangeMarker, @Nullable SearchPath searchPath) {
            Intrinsics.checkNotNullParameter((Object)transactionOwner, (String)"transactionOwner");
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            return this.createRunner(transactionOwner, scriptIsMeaningful, virtualFile, rangeMarker, searchPath, (Function0<? extends GridDataRequest>)((Function0)() -> Handler.createRunner$lambda$10(request2)));
        }

        public static /* synthetic */ SqlDebugSessionRunner createRunner$default(Handler handler2, DatabaseSessionClient databaseSessionClient, GridDataRequest gridDataRequest, boolean bl, VirtualFile virtualFile, RangeMarker rangeMarker, SearchPath searchPath, int n, Object object) {
            if ((n & 8) != 0) {
                virtualFile = null;
            }
            if ((n & 0x10) != 0) {
                rangeMarker = null;
            }
            if ((n & 0x20) != 0) {
                searchPath = null;
            }
            return handler2.createRunner(databaseSessionClient, gridDataRequest, bl, virtualFile, rangeMarker, searchPath);
        }

        private final SqlDebugSessionRunner createRunner(DatabaseSessionClient transactionOwner, boolean scriptIsMeaningful, VirtualFile virtualFile, RangeMarker rangeMarker, SearchPath searchPath, Function0<? extends GridDataRequest> requestFactory) {
            DatabaseSession session = (DatabaseSession)transactionOwner.getSession();
            SqlDebuggerFacade facade = (SqlDebuggerFacade)FACADE_EP.forDbms(((DatabaseConnectionPoint)session.getTarget()).getDbms());
            SqlDebugController sqlDebugController = facade.createController(session.getProject(), (DatabaseConnectionPoint)session.getTarget(), transactionOwner, scriptIsMeaningful, virtualFile, rangeMarker, searchPath);
            Intrinsics.checkNotNullExpressionValue((Object)sqlDebugController, (String)"createController(...)");
            SqlDebugController controller = sqlDebugController;
            GridDataRequest executingRequest = (GridDataRequest)requestFactory.invoke();
            DatabaseSessionLogger.SILENT_REQUEST.set((UserDataHolder)executingRequest, (Object)true);
            return new Runner(rangeMarker, transactionOwner, controller, executingRequest);
        }

        static /* synthetic */ SqlDebugSessionRunner createRunner$default(Handler handler2, DatabaseSessionClient databaseSessionClient, boolean bl, VirtualFile virtualFile, RangeMarker rangeMarker, SearchPath searchPath, Function0 function0, int n, Object object) {
            if ((n & 4) != 0) {
                virtualFile = null;
            }
            if ((n & 8) != 0) {
                rangeMarker = null;
            }
            if ((n & 0x10) != 0) {
                searchPath = null;
            }
            return handler2.createRunner(databaseSessionClient, bl, virtualFile, rangeMarker, searchPath, (Function0<? extends GridDataRequest>)function0);
        }

        private static final void obtainActualScriptModel$lambda$3$lambda$2$lambda$1(FileDocumentManager $this_apply, Document $doc) {
            $this_apply.saveDocument($doc);
        }

        private static final String startDebugProcess$lambda$4(RunContentDescriptor it) {
            return it.getDisplayName();
        }

        private static final String startDebugProcess$lambda$5(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        private static final boolean startDebugProcess$lambda$6(Set $existingTitles, String it) {
            return !$existingTitles.contains(it);
        }

        private static final boolean startDebugProcess$lambda$7(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final GridDataRequest createRunner$lambda$9(DatabaseSessionClient $transactionOwner, VirtualFile $virtualFile, RangeMarker $rangeMarker, Function1 $requestFactory) {
            GridDataRequest gridDataRequest;
            ScriptModel<?> scriptModel = INSTANCE.obtainActualScriptModel(((DatabaseSession)$transactionOwner.getSession()).getProject(), $virtualFile, true, $rangeMarker);
            if (scriptModel != null) {
                ScriptModel<?> it = scriptModel;
                boolean bl = false;
                gridDataRequest = (GridDataRequest)$requestFactory.invoke(it);
            } else {
                gridDataRequest = null;
            }
            return gridDataRequest;
        }

        private static final GridDataRequest createRunner$lambda$10(GridDataRequest $request) {
            return $request;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001 B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00060\u0016R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/debugger/SqlDebugSessionRunner$Runner;", "Lcom/intellij/database/debugger/SqlDebugSessionRunner;", "marker", "Lcom/intellij/openapi/editor/RangeMarker;", "transactionOwner", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "controller", "Lcom/intellij/database/debugger/SqlDebugController;", "executingRequest", "Lcom/intellij/database/datagrid/GridDataRequest;", "<init>", "(Lcom/intellij/openapi/editor/RangeMarker;Lcom/intellij/database/console/client/DatabaseSessionClient;Lcom/intellij/database/debugger/SqlDebugController;Lcom/intellij/database/datagrid/GridDataRequest;)V", "onFinish", "Lkotlin/Function0;", "", "getOnFinish", "()Lkotlin/jvm/functions/Function0;", "setOnFinish", "(Lkotlin/jvm/functions/Function0;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "auditor", "Lcom/intellij/database/debugger/SqlDebugSessionRunner$Runner$MyAdapter;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "startTheRequestSequence", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "close", "MyAdapter", "intellij.database.impl"})
    private static final class Runner
    implements SqlDebugSessionRunner {
        @NotNull
        private final DatabaseSessionClient transactionOwner;
        @NotNull
        private final SqlDebugController controller;
        @Nullable
        private final GridDataRequest executingRequest;
        @Nullable
        private Function0<Unit> onFinish;
        @NotNull
        private final Disposable disposable;
        @NotNull
        private final MyAdapter auditor;

        public Runner(@Nullable RangeMarker marker, @NotNull DatabaseSessionClient transactionOwner, @NotNull SqlDebugController controller, @Nullable GridDataRequest executingRequest) {
            Intrinsics.checkNotNullParameter((Object)transactionOwner, (String)"transactionOwner");
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            this.transactionOwner = transactionOwner;
            this.controller = controller;
            this.executingRequest = executingRequest;
            this.disposable = () -> Runner.disposable$lambda$0(marker);
            this.auditor = new MyAdapter();
            this.transactionOwner.getMessageBus().addAuditor((DataAuditor)this.auditor);
            Disposer.register((Disposable)this.disposable, (Disposable)this.auditor);
        }

        @Override
        @Nullable
        public Function0<Unit> getOnFinish() {
            return this.onFinish;
        }

        @Override
        public void setOnFinish(@Nullable Function0<Unit> function0) {
            this.onFinish = function0;
        }

        @Override
        @NotNull
        public Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            if (!((DatabaseSession)this.transactionOwner.getSession()).isIdle()) {
                Disposer.dispose((Disposable)this.disposable);
                if (this.getOnFinish() != null) {
                    Function0<Unit> function0 = this.getOnFinish();
                    Intrinsics.checkNotNull(function0);
                    function0.invoke();
                }
                return Promises.resolvedPromise(null);
            }
            XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)((DatabaseSession)this.transactionOwner.getSession()).getProject());
            XDebugProcessStarter xDebugProcessStarter = this.controller.getStarter();
            Intrinsics.checkNotNullExpressionValue((Object)xDebugProcessStarter, (String)"getStarter(...)");
            XDebugProcessStarter debugProcessStarter = xDebugProcessStarter;
            XDebugSession xDebugSession = debuggerManager.startSession(environment, debugProcessStarter);
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"startSession(...)");
            XDebugSession xDebugSession2 = xDebugSession;
            Disposer.register((Disposable)((Disposable)xDebugSession2.getConsoleView()), (Disposable)this.disposable);
            this.controller.getReady();
            ConsoleView consoleView = xDebugSession2.getConsoleView();
            Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsoleView(...)");
            this.startTheRequestSequence(consoleView);
            return Promises.resolvedPromise((Object)xDebugSession2.getRunContentDescriptor());
        }

        private final void startTheRequestSequence(ConsoleView consoleView) {
            SqlDebugController.AuxiliaryRequest preparationRequest = this.controller.new SqlDebugController.AuxiliaryRequest(this.transactionOwner);
            if (this.executingRequest == null) {
                consoleView.print("Cannot find script to execute.", ConsoleViewContentType.LOG_ERROR_OUTPUT);
                this.close();
                return;
            }
            DataProducer dataProducer = this.transactionOwner.getMessageBus().getDataProducer();
            preparationRequest.getPromise().onSuccess(arg_0 -> Runner.startTheRequestSequence$lambda$2(arg_0 -> Runner.startTheRequestSequence$lambda$1(dataProducer, this, arg_0), arg_0));
            preparationRequest.getPromise().onError(arg_0 -> Runner.startTheRequestSequence$lambda$4(arg_0 -> Runner.startTheRequestSequence$lambda$3(this, arg_0), arg_0));
            this.executingRequest.getPromise().onProcessed(arg_0 -> Runner.startTheRequestSequence$lambda$6(arg_0 -> Runner.startTheRequestSequence$lambda$5(this, arg_0), arg_0));
            dataProducer.processRequest((GridDataRequest)preparationRequest);
        }

        private final void close() {
            if (this.getOnFinish() != null) {
                Function0<Unit> function0 = this.getOnFinish();
                Intrinsics.checkNotNull(function0);
                Disposer.dispose(() -> Runner.close$lambda$7(function0));
            }
            this.controller.close();
        }

        private static final void disposable$lambda$0(RangeMarker $marker) {
            block0: {
                RangeMarker rangeMarker = $marker;
                if (rangeMarker == null) break block0;
                rangeMarker.dispose();
            }
        }

        private static final Unit startTheRequestSequence$lambda$1(DataProducer $dataProducer, Runner this$0, Void it) {
            $dataProducer.processRequest(this$0.executingRequest);
            return Unit.INSTANCE;
        }

        private static final void startTheRequestSequence$lambda$2(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Unit startTheRequestSequence$lambda$3(Runner this$0, Throwable it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.close();
            return Unit.INSTANCE;
        }

        private static final void startTheRequestSequence$lambda$4(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Unit startTheRequestSequence$lambda$5(Runner this$0, Void it) {
            this$0.close();
            return Unit.INSTANCE;
        }

        private static final void startTheRequestSequence$lambda$6(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final void close$lambda$7(Function0 $tmp0) {
            $tmp0.invoke();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/debugger/SqlDebugSessionRunner$Runner$MyAdapter;", "Lcom/intellij/database/datagrid/DataAuditor;", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/database/debugger/SqlDebugSessionRunner$Runner;)V", "isApplicable", "", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "beforeStatement", "", "afterStatement", "dispose", "intellij.database.impl"})
        private final class MyAdapter
        implements DataAuditor,
        Disposable {
            private final boolean isApplicable(DataRequest.Context context) {
                return context.request == Runner.this.executingRequest;
            }

            public void beforeStatement(@NotNull DataRequest.Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (this.isApplicable(context)) {
                    Runner.this.controller.debugBegin();
                }
            }

            public void afterStatement(@NotNull DataRequest.Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (this.isApplicable(context)) {
                    Runner.this.controller.debugEnd();
                }
            }

            public void dispose() {
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/debugger/SqlDebugSessionRunner$SqlDebugAvailability;", "", "visible", "", "enabled", "<init>", "(Ljava/lang/String;IZZ)V", "DEBUGGER_ABSENT", "DEBUGGER_INAPPLICABLE", "DEBUGGER_DISABLED", "DEBUGGER_CONSOLE_BUSY", "DEBUGGER_ENABLED", "intellij.database.impl"})
    public static final class SqlDebugAvailability
    extends Enum<SqlDebugAvailability> {
        @JvmField
        public final boolean visible;
        @JvmField
        public final boolean enabled;
        public static final /* enum */ SqlDebugAvailability DEBUGGER_ABSENT = new SqlDebugAvailability(false, false);
        public static final /* enum */ SqlDebugAvailability DEBUGGER_INAPPLICABLE = new SqlDebugAvailability(true, false);
        public static final /* enum */ SqlDebugAvailability DEBUGGER_DISABLED = new SqlDebugAvailability(true, false);
        public static final /* enum */ SqlDebugAvailability DEBUGGER_CONSOLE_BUSY = new SqlDebugAvailability(true, false);
        public static final /* enum */ SqlDebugAvailability DEBUGGER_ENABLED = new SqlDebugAvailability(true, true);
        private static final /* synthetic */ SqlDebugAvailability[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SqlDebugAvailability(boolean visible, boolean enabled) {
            this.visible = visible;
            this.enabled = enabled;
        }

        public static SqlDebugAvailability[] values() {
            return (SqlDebugAvailability[])$VALUES.clone();
        }

        public static SqlDebugAvailability valueOf(String value) {
            return Enum.valueOf(SqlDebugAvailability.class, value);
        }

        @NotNull
        public static EnumEntries<SqlDebugAvailability> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sqlDebugAvailabilityArray = new SqlDebugAvailability[]{SqlDebugAvailability.DEBUGGER_ABSENT, SqlDebugAvailability.DEBUGGER_INAPPLICABLE, SqlDebugAvailability.DEBUGGER_DISABLED, SqlDebugAvailability.DEBUGGER_CONSOLE_BUSY, SqlDebugAvailability.DEBUGGER_ENABLED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

