/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow.types;

import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DataType;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeReference;
import com.intellij.database.types.DasTypeSystem;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.dataflow.SqlDfaCardinality;
import com.intellij.sql.inspections.dataflow.SqlDfaColumn;
import com.intellij.sql.inspections.dataflow.SqlDfaNullability;
import com.intellij.sql.inspections.dataflow.SqlDfaPsiUtilKt;
import com.intellij.sql.inspections.dataflow.SqlPsiRangeSetUtilKt;
import com.intellij.sql.inspections.dataflow.types.SqlDfBigIntConstantType;
import com.intellij.sql.inspections.dataflow.types.SqlDfBigIntRangeType;
import com.intellij.sql.inspections.dataflow.types.SqlDfBigIntType;
import com.intellij.sql.inspections.dataflow.types.SqlDfBooleanConstantType;
import com.intellij.sql.inspections.dataflow.types.SqlDfBooleanType;
import com.intellij.sql.inspections.dataflow.types.SqlDfConstantType;
import com.intellij.sql.inspections.dataflow.types.SqlDfDoubleConstantType;
import com.intellij.sql.inspections.dataflow.types.SqlDfDoubleType;
import com.intellij.sql.inspections.dataflow.types.SqlDfFloatingPointType;
import com.intellij.sql.inspections.dataflow.types.SqlDfIntConstantType;
import com.intellij.sql.inspections.dataflow.types.SqlDfIntRangeType;
import com.intellij.sql.inspections.dataflow.types.SqlDfIntType;
import com.intellij.sql.inspections.dataflow.types.SqlDfIntegralType;
import com.intellij.sql.inspections.dataflow.types.SqlDfNullConstantType;
import com.intellij.sql.inspections.dataflow.types.SqlDfNumericConstantType;
import com.intellij.sql.inspections.dataflow.types.SqlDfNumericType;
import com.intellij.sql.inspections.dataflow.types.SqlDfRealConstantType;
import com.intellij.sql.inspections.dataflow.types.SqlDfRealType;
import com.intellij.sql.inspections.dataflow.types.SqlDfTableType;
import com.intellij.sql.inspections.dataflow.types.SqlDfTextConstantType;
import com.intellij.sql.inspections.dataflow.types.SqlDfTextType;
import com.intellij.sql.inspections.dataflow.types.SqlDfType;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlTableType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0098\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\u0012\u0010\t\u001a\u00020\b*\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\n\u001a\u00020\b*\u00020\b\u001a\n\u0010\u000b\u001a\u00020\b*\u00020\b\u001a\n\u0010\f\u001a\u00020\b*\u00020\b\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\b\u001a\n\u0010\u000f\u001a\u00020\u000e*\u00020\b\u001a\n\u0010\u0010\u001a\u00020\u000e*\u00020\b\u001a\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u000e\u001a\u000e\u00105\u001a\u00020\b2\u0006\u00106\u001a\u000207\u001a\u0018\u00105\u001a\u00020\b2\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000107\u001a\u000e\u00109\u001a\u00020\b2\u0006\u00106\u001a\u000207\u001a\u000e\u0010:\u001a\u00020;2\u0006\u0010!\u001a\u00020<\u001a\u000e\u0010C\u001a\u00020\b2\u0006\u00106\u001a\u000207\u001a\u0018\u0010C\u001a\u00020\b2\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000107\u001a \u00106\u001a\u00020\b2\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u0001072\u0006\u0010D\u001a\u00020E\u001a\u000e\u0010F\u001a\u00020G2\u0006\u0010!\u001a\u00020H\u001a\u0016\u0010I\u001a\u00020\b2\u0006\u00106\u001a\u0002072\u0006\u0010D\u001a\u00020E\u001a\u000e\u0010J\u001a\u00020K2\u0006\u0010!\u001a\u00020L\u001a\u000e\u0010M\u001a\u00020N2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010R\u001a\u00020S2\u0006\u0010!\u001a\u00020T\u001a\u000e\u0010U\u001a\u00020V2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010Z\u001a\u00020[2\u0006\u0010!\u001a\u00020\\\u001a\u000e\u0010]\u001a\u00020^2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010b\u001a\u00020c2\u0006\u0010!\u001a\u00020d\u001a\u000e\u0010i\u001a\u00020f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020o\u001a\u001c\u0010j\u001a\u00020k2\f\u0010p\u001a\b\u0012\u0004\u0012\u00020r0q2\u0006\u0010s\u001a\u00020t\u001a\u0014\u0010j\u001a\u00020k2\f\u0010p\u001a\b\u0012\u0004\u0012\u00020r0q\u001a\u0018\u0010x\u001a\u0004\u0018\u00010\b2\u0006\u0010l\u001a\u00020y2\u0006\u0010z\u001a\u00020{\u001a\u0018\u0010|\u001a\u0004\u0018\u00010\b2\u0006\u0010l\u001a\u00020y2\u0006\u0010z\u001a\u00020{\u001a\u0018\u0010}\u001a\u0004\u0018\u00010\b2\u0006\u0010l\u001a\u00020y2\u0006\u0010z\u001a\u00020{\u001a\"\u0010~\u001a\u00020\b2\b\u0010l\u001a\u0004\u0018\u00010\u007f2\u0006\u0010n\u001a\u00020o2\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u000f\u0010\u0080\u0001\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0013\u0010\u0081\u0001\u001a\u00020\b2\n\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u0001\u001a\u0016\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u0016*\u00030\u0084\u00012\u0006\u0010n\u001a\u00020o\u001a\u0016\u0010\u0085\u0001\u001a\u0004\u0018\u00010f*\u00030\u0084\u00012\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u0086\u0001\u001a\u0004\u0018\u00010V*\u00020N2\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u0016*\u00020^2\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u0087\u0001\u001a\u0004\u0018\u00010N*\u00020^2\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u0086\u0001\u001a\u0004\u0018\u00010V*\u00020^2\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u0085\u0001\u001a\u0004\u0018\u00010f*\u00020^2\u0006\u0010n\u001a\u00020o\u001a\u0016\u0010\u0085\u0001\u001a\u0004\u0018\u00010f*\u00030\u0088\u00012\u0006\u0010n\u001a\u00020o\u001a\u0016\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u0084\u0001*\u00020\u00162\u0006\u0010n\u001a\u00020o\u001a\u0016\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u0088\u0001*\u00020\u00162\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u0085\u0001\u001a\u0004\u0018\u00010f*\u00020\u00162\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u008b\u0001\u001a\u0004\u0018\u00010^*\u00020f2\u0006\u0010n\u001a\u00020o\u001a\u0016\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u0088\u0001*\u00020f2\u0006\u0010n\u001a\u00020o\u001a\u0016\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u0084\u0001*\u00020f2\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u0016*\u00020f2\u0006\u0010n\u001a\u00020o\u001a\u0016\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u0016*\u00030\u0088\u00012\u0006\u0010n\u001a\u00020o\u001a\u0016\u0010\u0086\u0001\u001a\u0004\u0018\u00010V*\u00030\u0088\u00012\u0006\u0010n\u001a\u00020o\u001a\u0016\u0010\u0087\u0001\u001a\u0004\u0018\u00010N*\u00030\u0088\u00012\u0006\u0010n\u001a\u00020o\u001a\u0016\u0010\u008b\u0001\u001a\u0004\u0018\u00010^*\u00030\u0088\u00012\u0006\u0010n\u001a\u00020o\u001a\u0017\u0010\u008c\u0001\u001a\u0005\u0018\u00010\u008d\u0001*\u00030\u008e\u00012\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u0086\u0001\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u0087\u0001\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u008b\u0001\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u008a\u0001\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u008f\u0001\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u008c\u0001\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u0083\u0001\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010n\u001a\u00020o\u001a\u0015\u0010\u0085\u0001\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010n\u001a\u00020o\u001a.\u0010\u0090\u0001\u001a\u0013\u0012\u0006\u0012\u0004\u0018\u00010^\u0012\u0006\u0012\u0004\u0018\u00010^0\u0091\u00012\t\u0010\u0092\u0001\u001a\u0004\u0018\u00010^2\t\u0010\u0093\u0001\u001a\u0004\u0018\u00010^\u001a2\u0010\u0094\u0001\u001a\u0013\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0091\u00012\u0007\u0010\u0093\u0001\u001a\u00020\b2\u0007\u0010\u0092\u0001\u001a\u00020\b2\u0006\u0010n\u001a\u00020o\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0011\u0010\u001e\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001d\"\u0011\u0010\"\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\"\u0011\u0010%\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$\"\u0011\u0010'\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$\"\u0011\u0010)\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010$\"\u0011\u0010+\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010$\"\u0011\u0010-\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010$\"\u0011\u0010/\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010$\"\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\"\u0011\u0010=\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010$\"\u0011\u0010?\u001a\u00020@\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010B\"\u0011\u0010O\u001a\u00020N\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010Q\"\u0011\u0010W\u001a\u00020V\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010Y\"\u0011\u0010_\u001a\u00020^\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010a\"\u0011\u0010e\u001a\u00020f\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010h\"\u0011\u0010u\u001a\u00020k\u00a2\u0006\b\n\u0000\u001a\u0004\bv\u0010w\u00a8\u0006\u0095\u0001"}, d2={"NOT_NULL", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfType;", "getNOT_NULL", "()Lcom/intellij/sql/inspections/dataflow/types/SqlDfType;", "NULLABLE", "getNULLABLE", "nullability", "Lcom/intellij/sql/inspections/dataflow/SqlDfaNullability;", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "setNullability", "dropNullability", "setNullable", "setNotNull", "isNullable", "", "isNull", "isNotNull", "NULL", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfNullConstantType;", "getNULL", "()Lcom/intellij/sql/inspections/dataflow/types/SqlDfNullConstantType;", "BOOLEAN", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfBooleanType;", "getBOOLEAN", "()Lcom/intellij/sql/inspections/dataflow/types/SqlDfBooleanType;", "booleanType", "TRUE", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfBooleanConstantType;", "getTRUE", "()Lcom/intellij/sql/inspections/dataflow/types/SqlDfBooleanConstantType;", "FALSE", "getFALSE", "booleanValue", "value", "BIT", "getBIT", "()Lcom/intellij/codeInspection/dataFlow/types/DfType;", "TINYINT", "getTINYINT", "UNSIGNED_TINYINT", "getUNSIGNED_TINYINT", "SMALLINT", "getSMALLINT", "UNSIGNED_SMALLINT", "getUNSIGNED_SMALLINT", "MEDIUMINT", "getMEDIUMINT", "UNSIGNED_MEDIUMINT", "getUNSIGNED_MEDIUMINT", "INT", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfIntRangeType;", "getINT", "()Lcom/intellij/sql/inspections/dataflow/types/SqlDfIntRangeType;", "intRange", "range", "Lcom/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet;", "wideRange", "intRangeClamped", "intValue", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfIntConstantType;", "", "UNSIGNED_INT", "getUNSIGNED_INT", "BIGINT", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfBigIntRangeType;", "getBIGINT", "()Lcom/intellij/sql/inspections/dataflow/types/SqlDfBigIntRangeType;", "bigintRange", "lrType", "Lcom/intellij/codeInspection/dataFlow/rangeSet/LongRangeType;", "bigintValue", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfBigIntConstantType;", "", "rangeClamped", "realValue", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfRealConstantType;", "", "realType", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfRealType;", "REAL", "getREAL", "()Lcom/intellij/sql/inspections/dataflow/types/SqlDfRealType;", "doubleValue", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfDoubleConstantType;", "", "doubleType", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfDoubleType;", "DOUBLE", "getDOUBLE", "()Lcom/intellij/sql/inspections/dataflow/types/SqlDfDoubleType;", "numericValue", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfNumericConstantType;", "Ljava/math/BigDecimal;", "numericType", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfNumericType;", "NUMERIC", "getNUMERIC", "()Lcom/intellij/sql/inspections/dataflow/types/SqlDfNumericType;", "textValue", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfTextConstantType;", "", "TEXT", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfTextType;", "getTEXT", "()Lcom/intellij/sql/inspections/dataflow/types/SqlDfTextType;", "textType", "tableType", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfTableType;", "type", "Lcom/intellij/sql/psi/SqlTableType;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "columns", "", "Lcom/intellij/sql/inspections/dataflow/SqlDfaColumn;", "cardinality", "Lcom/intellij/sql/inspections/dataflow/SqlDfaCardinality;", "EMPTY_TABLE", "getEMPTY_TABLE", "()Lcom/intellij/sql/inspections/dataflow/types/SqlDfTableType;", "getMySqlType", "Lcom/intellij/database/model/DataType;", "typeSystem", "Lcom/intellij/database/types/DasTypeSystem;", "getPostgresType", "getMicrosoftType", "typedObject", "Lcom/intellij/database/types/DasType;", "unknown", "constant", "", "tryCastToBoolean", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfFloatingPointType;", "tryCastToText", "tryCastToDouble", "tryCastToReal", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfIntegralType;", "tryCastToFloating", "tryCastToIntegral", "tryCastToNumeric", "tryCastToBigInt", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfBigIntType;", "Lcom/intellij/sql/inspections/dataflow/types/SqlDfIntType;", "tryCastToInt", "balanceNumerics", "Lkotlin/Pair;", "left", "right", "balanceTypes", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlDfTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlDfTypes.kt\ncom/intellij/sql/inspections/dataflow/types/SqlDfTypesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,852:1\n1#2:853\n*E\n"})
public final class SqlDfTypesKt {
    @NotNull
    private static final SqlDfType NOT_NULL = new SqlDfType(){
        private final SqlDfaNullability nullability;
        {
            this.nullability = SqlDfaNullability.NOT_NULL;
        }

        public SqlDfaNullability getNullability() {
            return this.nullability;
        }

        public boolean isSuperType(DfType other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return SqlDfTypesKt.isNotNull(other);
        }

        public DfType join(DfType other) {
            DfType dfType;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (Intrinsics.areEqual((Object)other, (Object)DfType.BOTTOM)) {
                dfType = this;
            } else if (Intrinsics.areEqual((Object)other, (Object)DfType.TOP)) {
                dfType = other;
            } else if (SqlDfTypesKt.isNotNull(other)) {
                dfType = this;
            } else if (SqlDfTypesKt.isNullable(other)) {
                dfType = SqlDfTypesKt.getNULLABLE();
            } else {
                DfType dfType2 = DfType.TOP;
                dfType = dfType2;
                Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"TOP");
            }
            return dfType;
        }

        public DfType tryJoinExactly(DfType other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Intrinsics.areEqual((Object)other, (Object)DfType.BOTTOM) ? (DfType)this : (Intrinsics.areEqual((Object)other, (Object)DfType.TOP) ? other : (Intrinsics.areEqual((Object)other, (Object)SqlDfTypesKt.getNULLABLE()) ? other : (Intrinsics.areEqual((Object)other, (Object)SqlDfTypesKt.getNULL()) ? (DfType)SqlDfTypesKt.getNULLABLE() : (SqlDfTypesKt.isNotNull(other) ? (DfType)this : null))));
        }

        public DfType meet(DfType other) {
            DfType dfType;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (Intrinsics.areEqual((Object)other, (Object)DfType.TOP) || Intrinsics.areEqual((Object)other, (Object)SqlDfTypesKt.getNULLABLE())) {
                dfType = this;
            } else if (SqlDfTypesKt.isNotNull(other)) {
                dfType = other;
            } else if (SqlDfTypesKt.nullability(other) == SqlDfaNullability.UNKNOWN) {
                dfType = SqlDfTypesKt.setNullability(other, SqlDfaNullability.NOT_NULL);
            } else {
                DfType dfType2 = DfType.BOTTOM;
                dfType = dfType2;
                Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"BOTTOM");
            }
            return dfType;
        }

        public DfType fromRelation(RelationType relationType) {
            Intrinsics.checkNotNullParameter((Object)relationType, (String)"relationType");
            return this;
        }

        public DfType setNullability(SqlDfaNullability nullability) {
            DfType dfType;
            Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
            switch (NOT_NULL.WhenMappings.$EnumSwitchMapping$0[nullability.ordinal()]) {
                case 1: {
                    dfType = this;
                    break;
                }
                case 2: {
                    dfType = SqlDfTypesKt.getNULLABLE();
                    break;
                }
                case 3: {
                    dfType = SqlDfTypesKt.getNULL();
                    break;
                }
                default: {
                    DfType dfType2 = DfType.TOP;
                    dfType = dfType2;
                    Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"TOP");
                }
            }
            return dfType;
        }

        public SqlDfNullConstantType tryNegate() {
            return SqlDfTypesKt.getNULL();
        }

        public DfType dropNullability() {
            return DfType.TOP;
        }

        public String toString() {
            return this.getNullability() + " " + DfType.TOP;
        }
    };
    @NotNull
    private static final SqlDfType NULLABLE = new SqlDfType(){
        private final SqlDfaNullability nullability;
        {
            this.nullability = SqlDfaNullability.NULLABLE;
        }

        public SqlDfaNullability getNullability() {
            return this.nullability;
        }

        public boolean isSuperType(DfType other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return SqlDfTypesKt.nullability(other) != SqlDfaNullability.UNKNOWN;
        }

        public DfType join(DfType other) {
            DfType dfType;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (Intrinsics.areEqual((Object)other, (Object)DfType.BOTTOM)) {
                dfType = this;
            } else if (Intrinsics.areEqual((Object)other, (Object)DfType.TOP)) {
                dfType = other;
            } else if (SqlDfTypesKt.nullability(other) == SqlDfaNullability.UNKNOWN) {
                DfType dfType2 = DfType.TOP;
                dfType = dfType2;
                Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"TOP");
            } else {
                dfType = this;
            }
            return dfType;
        }

        public DfType tryJoinExactly(DfType other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Intrinsics.areEqual((Object)other, (Object)DfType.BOTTOM) ? (DfType)this : (Intrinsics.areEqual((Object)other, (Object)DfType.TOP) ? other : (SqlDfTypesKt.nullability(other) == SqlDfaNullability.UNKNOWN ? null : (DfType)this));
        }

        public DfType meet(DfType other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Intrinsics.areEqual((Object)other, (Object)DfType.TOP) ? (DfType)this : (SqlDfTypesKt.nullability(other) == SqlDfaNullability.UNKNOWN ? SqlDfTypesKt.setNullability(other, SqlDfaNullability.NULLABLE) : other);
        }

        public DfType fromRelation(RelationType relationType) {
            Intrinsics.checkNotNullParameter((Object)relationType, (String)"relationType");
            return this;
        }

        public DfType tryNegate() {
            return DfType.BOTTOM;
        }

        public DfType setNullability(SqlDfaNullability nullability) {
            DfType dfType;
            Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
            switch (NULLABLE.WhenMappings.$EnumSwitchMapping$0[nullability.ordinal()]) {
                case 1: {
                    dfType = this;
                    break;
                }
                case 2: {
                    dfType = SqlDfTypesKt.getNOT_NULL();
                    break;
                }
                case 3: {
                    dfType = SqlDfTypesKt.getNULL();
                    break;
                }
                default: {
                    DfType dfType2 = DfType.TOP;
                    dfType = dfType2;
                    Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"TOP");
                }
            }
            return dfType;
        }

        public DfType dropNullability() {
            return DfType.TOP;
        }

        public String toString() {
            return this.getNullability() + " " + DfType.TOP;
        }
    };
    @NotNull
    private static final SqlDfNullConstantType NULL = new SqlDfNullConstantType();
    @NotNull
    private static final SqlDfBooleanType BOOLEAN = SqlDfTypesKt.booleanType(SqlDfaNullability.UNKNOWN);
    @NotNull
    private static final SqlDfBooleanConstantType TRUE = new SqlDfBooleanConstantType(true);
    @NotNull
    private static final SqlDfBooleanConstantType FALSE = new SqlDfBooleanConstantType(false);
    @NotNull
    private static final DfType BIT = SqlDfTypesKt.intRange(SqlPsiRangeSetUtilKt.getBIT_RANGE());
    @NotNull
    private static final DfType TINYINT = SqlDfTypesKt.intRange(SqlPsiRangeSetUtilKt.getTINYINT_RANGE());
    @NotNull
    private static final DfType UNSIGNED_TINYINT = SqlDfTypesKt.intRange(SqlPsiRangeSetUtilKt.getUNSIGNED_TINYINT_RANGE());
    @NotNull
    private static final DfType SMALLINT = SqlDfTypesKt.intRange(SqlPsiRangeSetUtilKt.getSMALLINT_RANGE());
    @NotNull
    private static final DfType UNSIGNED_SMALLINT = SqlDfTypesKt.intRange(SqlPsiRangeSetUtilKt.getUNSIGNED_SMALLINT_RANGE());
    @NotNull
    private static final DfType MEDIUMINT = SqlDfTypesKt.intRange(SqlPsiRangeSetUtilKt.getMEDIUMINT_RANGE());
    @NotNull
    private static final DfType UNSIGNED_MEDIUMINT = SqlDfTypesKt.intRange(SqlPsiRangeSetUtilKt.getUNSIGNED_MEDIUMINT_RANGE());
    @NotNull
    private static final SqlDfIntRangeType INT = new SqlDfIntRangeType(SqlPsiRangeSetUtilKt.getINT_RANGE(), null, null, 6, null);
    @NotNull
    private static final DfType UNSIGNED_INT = SqlDfTypesKt.bigintRange(SqlPsiRangeSetUtilKt.getUNSIGNED_INT_RANGE());
    @NotNull
    private static final SqlDfBigIntRangeType BIGINT = new SqlDfBigIntRangeType(SqlPsiRangeSetUtilKt.getBIGINT_RANGE(), null, null, 6, null);
    @NotNull
    private static final SqlDfRealType REAL = SqlDfTypesKt.realType(SqlDfaNullability.UNKNOWN);
    @NotNull
    private static final SqlDfDoubleType DOUBLE = SqlDfTypesKt.doubleType(SqlDfaNullability.UNKNOWN);
    @NotNull
    private static final SqlDfNumericType NUMERIC = SqlDfTypesKt.numericType(SqlDfaNullability.UNKNOWN);
    @NotNull
    private static final SqlDfTextType TEXT = SqlDfTypesKt.textType(SqlDfaNullability.UNKNOWN);
    @NotNull
    private static final SqlDfTableType EMPTY_TABLE = SqlDfTypesKt.tableType(CollectionsKt.emptyList());

    @NotNull
    public static final SqlDfType getNOT_NULL() {
        return NOT_NULL;
    }

    @NotNull
    public static final SqlDfType getNULLABLE() {
        return NULLABLE;
    }

    @NotNull
    public static final SqlDfaNullability nullability(@NotNull DfType $this$nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$nullability, (String)"<this>");
        return $this$nullability instanceof SqlDfType ? ((SqlDfType)$this$nullability).getNullability() : SqlDfaNullability.UNKNOWN;
    }

    @NotNull
    public static final DfType setNullability(@NotNull DfType $this$setNullability, @NotNull SqlDfaNullability nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$setNullability, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
        DfType dfType = $this$setNullability;
        return Intrinsics.areEqual((Object)dfType, (Object)DfType.TOP) ? SqlDfTypesKt.unknown(nullability) : (dfType instanceof SqlDfType ? ((SqlDfType)$this$setNullability).setNullability(nullability) : $this$setNullability);
    }

    @NotNull
    public static final DfType dropNullability(@NotNull DfType $this$dropNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$dropNullability, (String)"<this>");
        return $this$dropNullability instanceof SqlDfType ? ((SqlDfType)$this$dropNullability).dropNullability() : $this$dropNullability;
    }

    @NotNull
    public static final DfType setNullable(@NotNull DfType $this$setNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$setNullable, (String)"<this>");
        return SqlDfTypesKt.setNullability($this$setNullable, SqlDfaNullability.NULLABLE);
    }

    @NotNull
    public static final DfType setNotNull(@NotNull DfType $this$setNotNull) {
        Intrinsics.checkNotNullParameter((Object)$this$setNotNull, (String)"<this>");
        return SqlDfTypesKt.setNullability($this$setNotNull, SqlDfaNullability.NOT_NULL);
    }

    public static final boolean isNullable(@NotNull DfType $this$isNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullable, (String)"<this>");
        return SqlDfTypesKt.isNull($this$isNullable) || SqlDfTypesKt.nullability($this$isNullable) == SqlDfaNullability.NULLABLE;
    }

    public static final boolean isNull(@NotNull DfType $this$isNull) {
        Intrinsics.checkNotNullParameter((Object)$this$isNull, (String)"<this>");
        return SqlDfTypesKt.nullability($this$isNull) == SqlDfaNullability.NULL;
    }

    public static final boolean isNotNull(@NotNull DfType $this$isNotNull) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotNull, (String)"<this>");
        return SqlDfTypesKt.nullability($this$isNotNull) == SqlDfaNullability.NOT_NULL;
    }

    @NotNull
    public static final SqlDfNullConstantType getNULL() {
        return NULL;
    }

    @NotNull
    public static final SqlDfBooleanType getBOOLEAN() {
        return BOOLEAN;
    }

    @NotNull
    public static final SqlDfBooleanType booleanType(@NotNull SqlDfaNullability nullability) {
        Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
        return new SqlDfBooleanType(nullability){
            final /* synthetic */ SqlDfaNullability $nullability;
            {
                this.$nullability = $nullability;
            }

            public SqlDfaNullability getNullability() {
                return this.$nullability;
            }

            public SqlDfBooleanType doSetNullability(SqlDfaNullability nullability) {
                Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
                return SqlDfTypesKt.booleanType(nullability);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                Object object = other;
                if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                    return false;
                }
                Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.sql.inspections.dataflow.types.SqlDfBooleanType");
                SqlDfBooleanType cfr_ignored_0 = (SqlDfBooleanType)other;
                return this.$nullability == ((SqlDfBooleanType)other).getNullability();
            }

            public int hashCode() {
                return 10714871 + this.$nullability.hashCode();
            }

            public String toString() {
                return this.asString();
            }

            public String getTypePresentation() {
                return "boolean";
            }
        };
    }

    @NotNull
    public static final SqlDfBooleanConstantType getTRUE() {
        return TRUE;
    }

    @NotNull
    public static final SqlDfBooleanConstantType getFALSE() {
        return FALSE;
    }

    @NotNull
    public static final SqlDfBooleanConstantType booleanValue(boolean value) {
        return value ? TRUE : FALSE;
    }

    @NotNull
    public static final DfType getBIT() {
        return BIT;
    }

    @NotNull
    public static final DfType getTINYINT() {
        return TINYINT;
    }

    @NotNull
    public static final DfType getUNSIGNED_TINYINT() {
        return UNSIGNED_TINYINT;
    }

    @NotNull
    public static final DfType getSMALLINT() {
        return SMALLINT;
    }

    @NotNull
    public static final DfType getUNSIGNED_SMALLINT() {
        return UNSIGNED_SMALLINT;
    }

    @NotNull
    public static final DfType getMEDIUMINT() {
        return MEDIUMINT;
    }

    @NotNull
    public static final DfType getUNSIGNED_MEDIUMINT() {
        return UNSIGNED_MEDIUMINT;
    }

    @NotNull
    public static final SqlDfIntRangeType getINT() {
        return INT;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final DfType intRange(@NotNull LongRangeSet range) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (Intrinsics.areEqual((Object)range, (Object)SqlPsiRangeSetUtilKt.getINT_RANGE())) {
            return INT;
        }
        if (range.isEmpty()) {
            DfType dfType2 = DfType.BOTTOM;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"BOTTOM");
            return dfType2;
        }
        Object object = range.getConstantValue();
        if (object != null) {
            long it = ((Number)object).longValue();
            boolean bl = false;
            SqlDfIntConstantType sqlDfIntConstantType = SqlDfTypesKt.intValue(Math.toIntExact(it));
            object = sqlDfIntConstantType;
            if (sqlDfIntConstantType != null) {
                dfType = (DfType)object;
                return dfType;
            }
        }
        dfType = new SqlDfIntRangeType(range, null, null, 4, null);
        return dfType;
    }

    @NotNull
    public static final DfType intRange(@NotNull LongRangeSet range, @Nullable LongRangeSet wideRange) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (wideRange == null || Intrinsics.areEqual((Object)wideRange, (Object)range) || wideRange.isEmpty()) {
            return SqlDfTypesKt.intRange(range);
        }
        if (range.isEmpty()) {
            DfType dfType2 = DfType.BOTTOM;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"BOTTOM");
            return dfType2;
        }
        Long l = range.getConstantValue();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            dfType = new SqlDfIntConstantType(Math.toIntExact(it), wideRange);
        } else {
            dfType = new SqlDfIntRangeType(range, wideRange, null, 4, null);
        }
        return dfType;
    }

    @NotNull
    public static final DfType intRangeClamped(@NotNull LongRangeSet range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        LongRangeSet longRangeSet = range.meet(SqlPsiRangeSetUtilKt.getINT_RANGE());
        Intrinsics.checkNotNullExpressionValue((Object)longRangeSet, (String)"meet(...)");
        return SqlDfTypesKt.intRange(longRangeSet);
    }

    @NotNull
    public static final SqlDfIntConstantType intValue(int value) {
        return new SqlDfIntConstantType(value, null, 2, null);
    }

    @NotNull
    public static final DfType getUNSIGNED_INT() {
        return UNSIGNED_INT;
    }

    @NotNull
    public static final SqlDfBigIntRangeType getBIGINT() {
        return BIGINT;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final DfType bigintRange(@NotNull LongRangeSet range) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (Intrinsics.areEqual((Object)range, (Object)SqlPsiRangeSetUtilKt.getBIGINT_RANGE())) {
            return BIGINT;
        }
        if (range.isEmpty()) {
            DfType dfType2 = DfType.BOTTOM;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"BOTTOM");
            return dfType2;
        }
        Object object = range.getConstantValue();
        if (object != null) {
            long it = ((Number)object).longValue();
            boolean bl = false;
            SqlDfBigIntConstantType sqlDfBigIntConstantType = SqlDfTypesKt.bigintValue(it);
            object = sqlDfBigIntConstantType;
            if (sqlDfBigIntConstantType != null) {
                dfType = (DfType)object;
                return dfType;
            }
        }
        dfType = new SqlDfBigIntRangeType(range, null, null, 4, null);
        return dfType;
    }

    @NotNull
    public static final DfType bigintRange(@NotNull LongRangeSet range, @Nullable LongRangeSet wideRange) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (wideRange == null || Intrinsics.areEqual((Object)wideRange, (Object)range) || wideRange.isEmpty()) {
            return SqlDfTypesKt.bigintRange(range);
        }
        if (range.isEmpty()) {
            DfType dfType2 = DfType.BOTTOM;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"BOTTOM");
            return dfType2;
        }
        Long l = range.getConstantValue();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            dfType = new SqlDfBigIntConstantType(it, wideRange);
        } else {
            dfType = new SqlDfBigIntRangeType(range, wideRange, null, 4, null);
        }
        return dfType;
    }

    @NotNull
    public static final DfType range(@NotNull LongRangeSet range, @Nullable LongRangeSet wideRange, @NotNull LongRangeType lrType) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)lrType, (String)"lrType");
        return switch (WhenMappings.$EnumSwitchMapping$0[lrType.ordinal()]) {
            case 1 -> SqlDfTypesKt.intRange(range, wideRange);
            case 2 -> SqlDfTypesKt.bigintRange(range, wideRange);
            default -> throw new IllegalStateException("Unexpected value: " + lrType);
        };
    }

    @NotNull
    public static final SqlDfBigIntConstantType bigintValue(long value) {
        return new SqlDfBigIntConstantType(value, null, 2, null);
    }

    @NotNull
    public static final DfType rangeClamped(@NotNull LongRangeSet range, @NotNull LongRangeType lrType) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)lrType, (String)"lrType");
        return switch (WhenMappings.$EnumSwitchMapping$0[lrType.ordinal()]) {
            case 1 -> SqlDfTypesKt.intRangeClamped(range);
            case 2 -> SqlDfTypesKt.bigintRange(range);
            default -> throw new IllegalStateException("Unexpected value: " + lrType);
        };
    }

    @NotNull
    public static final SqlDfRealConstantType realValue(float value) {
        return new SqlDfRealConstantType(value);
    }

    @NotNull
    public static final SqlDfRealType realType(@NotNull SqlDfaNullability nullability) {
        Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
        return new SqlDfRealType(nullability){
            final /* synthetic */ SqlDfaNullability $nullability;
            {
                this.$nullability = $nullability;
            }

            public SqlDfaNullability getNullability() {
                return this.$nullability;
            }

            public SqlDfRealType doSetNullability(SqlDfaNullability nullability) {
                Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
                return SqlDfTypesKt.realType(nullability);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                Object object = other;
                if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                    return false;
                }
                Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.sql.inspections.dataflow.types.SqlDfRealType");
                SqlDfRealType cfr_ignored_0 = (SqlDfRealType)other;
                return this.$nullability == ((SqlDfRealType)other).getNullability();
            }

            public int hashCode() {
                return 16580722 + this.$nullability.hashCode();
            }

            public String getTypePresentation() {
                return "real";
            }
        };
    }

    @NotNull
    public static final SqlDfRealType getREAL() {
        return REAL;
    }

    @NotNull
    public static final SqlDfDoubleConstantType doubleValue(double value) {
        return new SqlDfDoubleConstantType(value);
    }

    @NotNull
    public static final SqlDfDoubleType doubleType(@NotNull SqlDfaNullability nullability) {
        Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
        return new SqlDfDoubleType(nullability){
            final /* synthetic */ SqlDfaNullability $nullability;
            {
                this.$nullability = $nullability;
            }

            public SqlDfaNullability getNullability() {
                return this.$nullability;
            }

            public SqlDfDoubleType doSetNullability(SqlDfaNullability nullability) {
                Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
                return SqlDfTypesKt.doubleType(nullability);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                Object object = other;
                if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                    return false;
                }
                Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.sql.inspections.dataflow.types.SqlDfDoubleType");
                SqlDfDoubleType cfr_ignored_0 = (SqlDfDoubleType)other;
                return this.$nullability == ((SqlDfDoubleType)other).getNullability();
            }

            public int hashCode() {
                return 26763912 + this.$nullability.hashCode();
            }

            public String toString() {
                return this.asString();
            }

            public String getTypePresentation() {
                return "double";
            }
        };
    }

    @NotNull
    public static final SqlDfDoubleType getDOUBLE() {
        return DOUBLE;
    }

    @NotNull
    public static final SqlDfNumericConstantType numericValue(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new SqlDfNumericConstantType(value);
    }

    @NotNull
    public static final SqlDfNumericType numericType(@NotNull SqlDfaNullability nullability) {
        Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
        return new SqlDfNumericType(nullability){
            final /* synthetic */ SqlDfaNullability $nullability;
            {
                this.$nullability = $nullability;
            }

            public SqlDfaNullability getNullability() {
                return this.$nullability;
            }

            public SqlDfNumericType doSetNullability(SqlDfaNullability nullability) {
                Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
                return SqlDfTypesKt.numericType(nullability);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                Object object = other;
                if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                    return false;
                }
                Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.sql.inspections.dataflow.types.SqlDfNumericType");
                SqlDfNumericType cfr_ignored_0 = (SqlDfNumericType)other;
                return this.$nullability == ((SqlDfNumericType)other).getNullability();
            }

            public int hashCode() {
                return 13130856 + this.$nullability.hashCode();
            }

            public String toString() {
                return this.asString();
            }

            public String getTypePresentation() {
                return "numeric";
            }
        };
    }

    @NotNull
    public static final SqlDfNumericType getNUMERIC() {
        return NUMERIC;
    }

    @NotNull
    public static final SqlDfTextConstantType textValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new SqlDfTextConstantType(value);
    }

    @NotNull
    public static final SqlDfTextType getTEXT() {
        return TEXT;
    }

    @NotNull
    public static final SqlDfTextType textType(@NotNull SqlDfaNullability nullability) {
        Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
        return new SqlDfTextType(nullability){
            final /* synthetic */ SqlDfaNullability $nullability;
            {
                this.$nullability = $nullability;
            }

            public SqlDfaNullability getNullability() {
                return this.$nullability;
            }

            public SqlDfTextType doSetNullability(SqlDfaNullability nullability) {
                Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
                return SqlDfTypesKt.textType(nullability);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                Object object = other;
                if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                    return false;
                }
                Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.sql.inspections.dataflow.types.SqlDfTextType");
                SqlDfTextType cfr_ignored_0 = (SqlDfTextType)other;
                return this.$nullability == ((SqlDfTextType)other).getNullability();
            }

            public int hashCode() {
                return 10715491 + this.$nullability.hashCode();
            }

            public String toString() {
                return this.asString();
            }

            public String getTypePresentation() {
                return "text";
            }
        };
    }

    @NotNull
    public static final SqlDfTableType tableType(@NotNull SqlTableType type, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        List columns = new ArrayList();
        int n = type.getColumnCount();
        for (int i2 = 0; i2 < n; ++i2) {
            PsiElement columnElement;
            Intrinsics.checkNotNullExpressionValue((Object)type.getColumnElement(i2), (String)"getColumnElement(...)");
            DasType columnType = type.getColumnDasType(i2);
            DfType dfaType = SqlDfTypesKt.typedObject(columnType, dialect, SqlDfaNullability.Companion.getElementNullability(columnElement));
            columns.add(new SqlDfaColumn(columnElement, dfaType));
        }
        return SqlDfTypesKt.tableType(columns);
    }

    @NotNull
    public static final SqlDfTableType tableType(@NotNull List<SqlDfaColumn> columns, @NotNull SqlDfaCardinality cardinality) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)((Object)cardinality), (String)"cardinality");
        return new SqlDfTableType(columns, cardinality){
            private final List<SqlDfaColumn> columns;
            private final SqlDfaCardinality cardinality;
            final /* synthetic */ List<SqlDfaColumn> $columns;
            final /* synthetic */ SqlDfaCardinality $cardinality;
            {
                this.$columns = $columns;
                this.$cardinality = $cardinality;
                this.columns = $columns;
                this.cardinality = $cardinality;
            }

            public List<SqlDfaColumn> getColumns() {
                return this.columns;
            }

            public SqlDfaCardinality getCardinality() {
                return this.cardinality;
            }

            public SqlDfTableType setCardinality(SqlDfaCardinality cardinality) {
                Intrinsics.checkNotNullParameter((Object)((Object)cardinality), (String)"cardinality");
                return SqlDfTypesKt.tableType(this.$columns, cardinality);
            }

            /*
             * WARNING - void declaration
             */
            public SqlDfTableType setNullability(List<? extends PsiElement> columns, SqlDfaNullability nullability) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(columns, (String)"columns");
                Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
                Iterable $this$map$iv = this.getColumns();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SqlDfaColumn sqlDfaColumn = (SqlDfaColumn)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(columns.contains(it.getElement()) ? it.setNullability(nullability) : it);
                }
                return SqlDfTypesKt.tableType((List)destination$iv$iv, this.$cardinality);
            }

            /*
             * WARNING - void declaration
             */
            public SqlDfTableType subtract(List<? extends PsiElement> elements) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                Iterable $this$mapNotNull$iv = elements;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    SqlDfaColumn it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    PsiElement it = (PsiElement)element$iv$iv;
                    boolean bl2 = false;
                    if (this.getColumn(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return SqlDfTypesKt.tableType((List)destination$iv$iv);
            }

            public SqlDfTableType add(SqlDfTableType other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                return Intrinsics.areEqual((Object)this, (Object)SqlDfTypesKt.getEMPTY_TABLE()) ? other : (Intrinsics.areEqual((Object)other, (Object)SqlDfTypesKt.getEMPTY_TABLE()) ? (SqlDfTableType)this : SqlDfTypesKt.tableType(CollectionsKt.plus((Collection)this.getColumns(), (Iterable)other.getColumns()), this.$cardinality.union(other.getCardinality())));
            }

            public String toString() {
                String presentationText = this.$cardinality != SqlDfaCardinality.UNKNOWN ? this.$cardinality + " " : "";
                return presentationText + CollectionsKt.joinToString$default((Iterable)this.$columns, (CharSequence)", ", (CharSequence)"{", (CharSequence)"}", (int)0, null, tableType.1::toString$lambda$2, (int)24, null);
            }

            private static final CharSequence toString$lambda$2(SqlDfaColumn it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.toString();
            }
        };
    }

    @NotNull
    public static final SqlDfTableType tableType(@NotNull List<SqlDfaColumn> columns) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        return SqlDfTypesKt.tableType(columns, SqlDfaCardinality.UNKNOWN);
    }

    @NotNull
    public static final SqlDfTableType getEMPTY_TABLE() {
        return EMPTY_TABLE;
    }

    @Nullable
    public static final DfType getMySqlType(@NotNull DataType type, @NotNull DasTypeSystem typeSystem) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)typeSystem, (String)"typeSystem");
        return switch (typeSystem.getNormalizedTypeName(type.typeName)) {
            case "bit" -> {
                if (type.size == -1) {
                    yield BIT;
                }
                yield SqlDfTypesKt.intRange(SqlPsiRangeSetUtilKt.getRangeByBits(type.size));
            }
            case "tinyint" -> {
                if (Intrinsics.areEqual((Object)type.suffix, (Object)"unsigned")) {
                    yield UNSIGNED_TINYINT;
                }
                yield TINYINT;
            }
            case "smallint" -> {
                if (Intrinsics.areEqual((Object)type.suffix, (Object)"unsigned")) {
                    yield UNSIGNED_SMALLINT;
                }
                yield SMALLINT;
            }
            case "mediumint" -> {
                if (Intrinsics.areEqual((Object)type.suffix, (Object)"unsigned")) {
                    yield UNSIGNED_MEDIUMINT;
                }
                yield MEDIUMINT;
            }
            case "int" -> {
                if (Intrinsics.areEqual((Object)type.suffix, (Object)"unsigned")) {
                    yield UNSIGNED_INT;
                }
                yield INT;
            }
            case "bigint" -> {
                if (Intrinsics.areEqual((Object)type.suffix, (Object)"unsigned")) {
                    yield DfType.TOP;
                }
                yield BIGINT;
            }
            case "double" -> DOUBLE;
            case "float" -> type.size > 25 ? (SqlDfFloatingPointType)DOUBLE : (SqlDfFloatingPointType)REAL;
            case "decimal" -> NUMERIC;
            default -> null;
        };
    }

    @Nullable
    public static final DfType getPostgresType(@NotNull DataType type, @NotNull DasTypeSystem typeSystem) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)typeSystem, (String)"typeSystem");
        return switch (typeSystem.getNormalizedTypeName(type.typeName)) {
            case "boolean" -> BOOLEAN;
            case "smallint", "smallserial" -> SMALLINT;
            case "serial", "integer" -> INT;
            case "bigserial", "bigint" -> BIGINT;
            case "real" -> REAL;
            case "float" -> {
                int var3_3 = type.size;
                yield (1 <= var3_3 ? var3_3 < 25 : false) ? (SqlDfFloatingPointType)REAL : (SqlDfFloatingPointType)DOUBLE;
            }
            case "double precision" -> DOUBLE;
            case "money", "numeric" -> NUMERIC;
            default -> null;
        };
    }

    @Nullable
    public static final DfType getMicrosoftType(@NotNull DataType type, @NotNull DasTypeSystem typeSystem) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)typeSystem, (String)"typeSystem");
        return switch (typeSystem.getNormalizedTypeName(type.typeName)) {
            case "bit" -> BIT;
            case "tinyint" -> UNSIGNED_TINYINT;
            case "smallint" -> SMALLINT;
            case "mediumint" -> MEDIUMINT;
            case "int" -> INT;
            case "bigint" -> BIGINT;
            case "real" -> REAL;
            case "float" -> {
                int var3_3 = type.size;
                yield (1 <= var3_3 ? var3_3 < 25 : false) ? (SqlDfFloatingPointType)REAL : (SqlDfFloatingPointType)DOUBLE;
            }
            case "money", "numeric", "smallmoney" -> NUMERIC;
            default -> null;
        };
    }

    @NotNull
    public static final DfType typedObject(@Nullable DasType type, @NotNull SqlLanguageDialectEx dialect, @NotNull SqlDfaNullability nullability) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
        if (type == null || Intrinsics.areEqual((Object)type, DasTypeSystemBase.UNKNOWN)) {
            dfType = SqlDfTypesKt.unknown(nullability);
        } else if (nullability == SqlDfaNullability.NULL) {
            dfType = NULL;
        } else if (type instanceof SqlTableType) {
            dfType = SqlDfTypesKt.tableType((SqlTableType)type, dialect);
        } else if (DasTypeUtilsKt.is(type, DasTypeCategory.STRING)) {
            dfType = TEXT.setNullability(nullability);
        } else if (type instanceof DasBuiltinType || type instanceof DasTypeReference) {
            DfType dfType2;
            DataType dataType = type.toDataType();
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
            DataType dataType2 = dataType;
            DasTypeSystemBase dasTypeSystemBase = dialect.getTypeSystem();
            Intrinsics.checkNotNullExpressionValue((Object)dasTypeSystemBase, (String)"getTypeSystem(...)");
            DasTypeSystemBase typeSystem = dasTypeSystemBase;
            Dbms dbms = dialect.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            if ((dbms2.isPostgres() ? SqlDfTypesKt.getPostgresType(dataType2, typeSystem) : (dbms2.isMysql() ? SqlDfTypesKt.getMySqlType(dataType2, typeSystem) : (dfType2 = dbms2.isMicrosoft() ? SqlDfTypesKt.getMicrosoftType(dataType2, typeSystem) : DfType.TOP))) == null) {
                dfType2 = DfType.TOP;
            }
            DfType result2 = dfType2;
            Intrinsics.checkNotNull((Object)result2);
            dfType = SqlDfTypesKt.setNullability(result2, nullability);
        } else {
            dfType = SqlDfTypesKt.unknown(nullability);
        }
        return dfType;
    }

    public static /* synthetic */ DfType typedObject$default(DasType dasType, SqlLanguageDialectEx sqlLanguageDialectEx, SqlDfaNullability sqlDfaNullability, int n, Object object) {
        if ((n & 4) != 0) {
            sqlDfaNullability = SqlDfaNullability.UNKNOWN;
        }
        return SqlDfTypesKt.typedObject(dasType, sqlLanguageDialectEx, sqlDfaNullability);
    }

    @NotNull
    public static final DfType unknown(@NotNull SqlDfaNullability nullability) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
        switch (WhenMappings.$EnumSwitchMapping$1[nullability.ordinal()]) {
            case 1: {
                dfType = NULL;
                break;
            }
            case 2: {
                dfType = NULLABLE;
                break;
            }
            case 3: {
                dfType = NOT_NULL;
                break;
            }
            default: {
                DfType dfType2 = DfType.TOP;
                dfType = dfType2;
                Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"TOP");
            }
        }
        return dfType;
    }

    @NotNull
    public static final DfType constant(@Nullable Object constant) {
        DfType dfType;
        Object object = constant;
        if (object == null) {
            dfType = NULL;
        } else if (object instanceof Boolean) {
            dfType = SqlDfTypesKt.booleanValue((Boolean)constant);
        } else if (object instanceof Integer || object instanceof Short || object instanceof Byte) {
            Intrinsics.checkNotNull((Object)constant, (String)"null cannot be cast to non-null type kotlin.Int");
            dfType = SqlDfTypesKt.intValue((Integer)constant);
        } else {
            dfType = object instanceof Long ? (DfType)SqlDfTypesKt.bigintValue(((Number)constant).longValue()) : (object instanceof Float ? (DfType)SqlDfTypesKt.realValue(((Number)constant).floatValue()) : (object instanceof Double ? (DfType)SqlDfTypesKt.doubleValue(((Number)constant).doubleValue()) : (object instanceof BigDecimal ? (DfType)SqlDfTypesKt.numericValue((BigDecimal)constant) : (object instanceof String ? (DfType)SqlDfTypesKt.textValue((String)constant) : (DfType)NOT_NULL))));
        }
        return dfType;
    }

    @Nullable
    public static final SqlDfBooleanType tryCastToBoolean(@NotNull SqlDfFloatingPointType $this$tryCastToBoolean, @NotNull SqlLanguageDialectEx dialect) {
        SqlDfBooleanType sqlDfBooleanType;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToBoolean, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isMysql()) {
            SqlDfFloatingPointType sqlDfFloatingPointType = $this$tryCastToBoolean;
            if (sqlDfFloatingPointType instanceof SqlDfRealConstantType) {
                sqlDfBooleanType = SqlDfTypesKt.booleanValue(!Intrinsics.areEqual((Float)((Float)((SqlDfRealConstantType)$this$tryCastToBoolean).getValue()), (float)0.0f));
            } else if (sqlDfFloatingPointType instanceof SqlDfDoubleConstantType) {
                sqlDfBooleanType = SqlDfTypesKt.booleanValue(!Intrinsics.areEqual((Double)((Double)((SqlDfDoubleConstantType)$this$tryCastToBoolean).getValue()), (double)0.0));
            } else {
                DfType dfType = BOOLEAN.setNullability($this$tryCastToBoolean.getNullability());
                Intrinsics.checkNotNull((Object)dfType, (String)"null cannot be cast to non-null type com.intellij.sql.inspections.dataflow.types.SqlDfBooleanType");
                sqlDfBooleanType = (SqlDfBooleanType)dfType;
            }
        } else {
            sqlDfBooleanType = null;
        }
        return sqlDfBooleanType;
    }

    @Nullable
    public static final SqlDfTextType tryCastToText(@NotNull SqlDfFloatingPointType $this$tryCastToText, @NotNull SqlLanguageDialectEx dialect) {
        SqlDfTextType sqlDfTextType;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isPostgres() || dbms2.isMicrosoft() || dbms2.isMysql()) {
            if ($this$tryCastToText instanceof SqlDfConstantType) {
                sqlDfTextType = null;
            } else {
                DfType dfType = TEXT.setNullability($this$tryCastToText.getNullability());
                Intrinsics.checkNotNull((Object)dfType, (String)"null cannot be cast to non-null type com.intellij.sql.inspections.dataflow.types.SqlDfTextType");
                sqlDfTextType = (SqlDfTextType)dfType;
            }
        } else {
            sqlDfTextType = null;
        }
        return sqlDfTextType;
    }

    @Nullable
    public static final SqlDfDoubleType tryCastToDouble(@NotNull SqlDfRealType $this$tryCastToDouble, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToDouble, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isMysql() || dbms2.isPostgres() || dbms2.isMicrosoft()) {
            return $this$tryCastToDouble instanceof SqlDfRealConstantType ? null : SqlDfTypesKt.doubleType($this$tryCastToDouble.getNullability());
        }
        return null;
    }

    @Nullable
    public static final SqlDfBooleanType tryCastToBoolean(@NotNull SqlDfNumericType $this$tryCastToBoolean, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToBoolean, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isMysql()) {
            SqlDfBooleanType sqlDfBooleanType;
            if ($this$tryCastToBoolean instanceof SqlDfNumericConstantType) {
                sqlDfBooleanType = SqlDfTypesKt.booleanValue(!Intrinsics.areEqual((Object)((SqlDfNumericConstantType)$this$tryCastToBoolean).getValue(), (Object)BigDecimal.ZERO));
            } else {
                DfType dfType = BOOLEAN.setNullability($this$tryCastToBoolean.getNullability());
                Intrinsics.checkNotNull((Object)dfType, (String)"null cannot be cast to non-null type com.intellij.sql.inspections.dataflow.types.SqlDfBooleanType");
                sqlDfBooleanType = (SqlDfBooleanType)dfType;
            }
            return sqlDfBooleanType;
        }
        return null;
    }

    @Nullable
    public static final SqlDfRealType tryCastToReal(@NotNull SqlDfNumericType $this$tryCastToReal, @NotNull SqlLanguageDialectEx dialect) {
        SqlDfRealType sqlDfRealType;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToReal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isMysql() || dbms2.isPostgres() || dbms2.isMicrosoft()) {
            if ($this$tryCastToReal instanceof SqlDfNumericConstantType) {
                try {
                    return SqlDfTypesKt.realValue(((BigDecimal)((SqlDfNumericConstantType)$this$tryCastToReal).getValue()).shortValueExact());
                }
                catch (ArithmeticException e) {
                    return null;
                }
            }
            sqlDfRealType = SqlDfTypesKt.realType($this$tryCastToReal.getNullability());
        } else {
            sqlDfRealType = null;
        }
        return sqlDfRealType;
    }

    @Nullable
    public static final SqlDfDoubleType tryCastToDouble(@NotNull SqlDfNumericType $this$tryCastToDouble, @NotNull SqlLanguageDialectEx dialect) {
        SqlDfDoubleType sqlDfDoubleType;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToDouble, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isMysql() || dbms2.isPostgres() || dbms2.isMicrosoft()) {
            if ($this$tryCastToDouble instanceof SqlDfNumericConstantType) {
                try {
                    return SqlDfTypesKt.doubleValue(((BigDecimal)((SqlDfNumericConstantType)$this$tryCastToDouble).getValue()).intValueExact());
                }
                catch (ArithmeticException e) {
                    return null;
                }
            }
            sqlDfDoubleType = SqlDfTypesKt.doubleType($this$tryCastToDouble.getNullability());
        } else {
            sqlDfDoubleType = null;
        }
        return sqlDfDoubleType;
    }

    @Nullable
    public static final SqlDfTextType tryCastToText(@NotNull SqlDfNumericType $this$tryCastToText, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        return dbms2.isMysql() || dbms2.isPostgres() || dbms2.isMicrosoft() ? ($this$tryCastToText instanceof SqlDfNumericConstantType ? null : SqlDfTypesKt.textType($this$tryCastToText.getNullability())) : null;
    }

    @Nullable
    public static final SqlDfTextType tryCastToText(@NotNull SqlDfIntegralType $this$tryCastToText, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        return dbms2.isMysql() || dbms2.isPostgres() || dbms2.isMicrosoft() ? ($this$tryCastToText instanceof SqlDfConstantType ? (SqlDfTextType)SqlDfTypesKt.textValue(String.valueOf(((SqlDfConstantType)((Object)$this$tryCastToText)).getValue())) : SqlDfTypesKt.textType($this$tryCastToText.getNullability())) : null;
    }

    @Nullable
    public static final SqlDfFloatingPointType tryCastToFloating(@NotNull SqlDfBooleanType $this$tryCastToFloating, @NotNull SqlLanguageDialectEx dialect) {
        SqlDfFloatingPointType sqlDfFloatingPointType;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToFloating, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isMysql()) {
            SqlDfRealType sqlDfRealType;
            if ($this$tryCastToFloating instanceof SqlDfBooleanConstantType) {
                Object object = ((SqlDfBooleanConstantType)$this$tryCastToFloating).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                sqlDfRealType = SqlDfTypesKt.realValue(SqlUtilFun.toInt((Boolean)object));
            } else {
                sqlDfRealType = SqlDfTypesKt.realType($this$tryCastToFloating.getNullability());
            }
            sqlDfFloatingPointType = sqlDfRealType;
        } else {
            sqlDfFloatingPointType = null;
        }
        return sqlDfFloatingPointType;
    }

    @Nullable
    public static final SqlDfIntegralType tryCastToIntegral(@NotNull SqlDfBooleanType $this$tryCastToIntegral, @NotNull SqlLanguageDialectEx dialect) {
        SqlDfIntegralType sqlDfIntegralType;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToIntegral, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isMysql()) {
            SqlDfIntType sqlDfIntType;
            if ($this$tryCastToIntegral instanceof SqlDfBooleanConstantType) {
                Object object = ((SqlDfBooleanConstantType)$this$tryCastToIntegral).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                sqlDfIntType = SqlDfTypesKt.intValue(SqlUtilFun.toInt((Boolean)object));
            } else {
                DfType dfType = SqlDfTypesKt.setNullability(BIT, $this$tryCastToIntegral.getNullability());
                Intrinsics.checkNotNull((Object)dfType, (String)"null cannot be cast to non-null type com.intellij.sql.inspections.dataflow.types.SqlDfIntType");
                sqlDfIntType = (SqlDfIntType)dfType;
            }
            sqlDfIntegralType = sqlDfIntType;
        } else {
            sqlDfIntegralType = null;
        }
        return sqlDfIntegralType;
    }

    @Nullable
    public static final SqlDfTextType tryCastToText(@NotNull SqlDfBooleanType $this$tryCastToText, @NotNull SqlLanguageDialectEx dialect) {
        SqlDfTextType sqlDfTextType;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isPostgres()) {
            sqlDfTextType = $this$tryCastToText instanceof SqlDfBooleanConstantType ? (SqlDfTextType)SqlDfTypesKt.textValue(((Boolean)((SqlDfBooleanConstantType)$this$tryCastToText).getValue()).toString()) : SqlDfTypesKt.textType($this$tryCastToText.getNullability());
        } else if (dbms2.isMysql()) {
            if ($this$tryCastToText instanceof SqlDfBooleanConstantType) {
                Object object = ((SqlDfBooleanConstantType)$this$tryCastToText).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                sqlDfTextType = SqlDfTypesKt.textValue(String.valueOf(SqlUtilFun.toInt((Boolean)object)));
            } else {
                sqlDfTextType = SqlDfTypesKt.textType($this$tryCastToText.getNullability());
            }
        } else {
            sqlDfTextType = null;
        }
        return sqlDfTextType;
    }

    @Nullable
    public static final SqlDfNumericType tryCastToNumeric(@NotNull SqlDfTextType $this$tryCastToNumeric, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToNumeric, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isPostgres() || dbms2.isMicrosoft()) {
            Object object = $this$tryCastToNumeric instanceof SqlDfTextConstantType ? (SqlDfTextConstantType)$this$tryCastToNumeric : null;
            if (object == null || (object = (String)object.getValue()) == null) {
                return null;
            }
            Object constant = object;
            DfType dfType = SqlDfTypesKt.constant(SqlDfaPsiUtilKt.parseNumeric((String)constant));
            return dfType instanceof SqlDfNumericType ? (SqlDfNumericType)dfType : null;
        }
        return null;
    }

    @Nullable
    public static final SqlDfIntegralType tryCastToIntegral(@NotNull SqlDfTextType $this$tryCastToIntegral, @NotNull SqlLanguageDialectEx dialect) {
        SqlDfIntegralType sqlDfIntegralType;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToIntegral, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isPostgres() || dbms2.isMicrosoft()) {
            DfType dfType;
            Object object = $this$tryCastToIntegral instanceof SqlDfTextConstantType ? (SqlDfTextConstantType)$this$tryCastToIntegral : null;
            if (object == null || (object = (String)object.getValue()) == null) {
                return null;
            }
            Object constant = object;
            Number number = SqlDfaPsiUtilKt.parseInt((String)constant);
            if (number == null) {
                number = SqlDfaPsiUtilKt.parseBigInt((String)constant);
            }
            sqlDfIntegralType = (dfType = SqlDfTypesKt.constant(number)) instanceof SqlDfIntegralType ? (SqlDfIntegralType)dfType : null;
        } else {
            sqlDfIntegralType = null;
        }
        return sqlDfIntegralType;
    }

    @Nullable
    public static final SqlDfFloatingPointType tryCastToFloating(@NotNull SqlDfTextType $this$tryCastToFloating, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToFloating, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isPostgres() || dbms2.isMicrosoft()) {
            DfType dfType;
            Object object = $this$tryCastToFloating instanceof SqlDfTextConstantType ? (SqlDfTextConstantType)$this$tryCastToFloating : null;
            if (object == null || (object = (String)object.getValue()) == null) {
                return null;
            }
            Object constant = object;
            Number number = SqlDfaPsiUtilKt.parseReal((String)constant);
            if (number == null) {
                number = SqlDfaPsiUtilKt.parseDouble((String)constant);
            }
            return (dfType = SqlDfTypesKt.constant(number)) instanceof SqlDfFloatingPointType ? (SqlDfFloatingPointType)dfType : null;
        }
        if (dbms2.isMysql()) {
            Object object = $this$tryCastToFloating instanceof SqlDfTextConstantType ? (SqlDfTextConstantType)$this$tryCastToFloating : null;
            if (object == null || (object = (String)object.getValue()) == null) {
                return SqlDfTypesKt.doubleType($this$tryCastToFloating.getNullability());
            }
            Object constant = object;
            DfType dfType = SqlDfTypesKt.constant(SqlDfaPsiUtilKt.parseDouble((String)constant));
            SqlDfFloatingPointType sqlDfFloatingPointType = dfType instanceof SqlDfFloatingPointType ? (SqlDfFloatingPointType)dfType : null;
            if (sqlDfFloatingPointType == null) {
                sqlDfFloatingPointType = SqlDfTypesKt.doubleValue(0.0);
            }
            return sqlDfFloatingPointType;
        }
        return null;
    }

    @Nullable
    public static final SqlDfBooleanType tryCastToBoolean(@NotNull SqlDfTextType $this$tryCastToBoolean, @NotNull SqlLanguageDialectEx dialect) {
        SqlDfBooleanType sqlDfBooleanType;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToBoolean, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isPostgres()) {
            Boolean value;
            Object object = $this$tryCastToBoolean instanceof SqlDfTextConstantType ? (SqlDfTextConstantType)$this$tryCastToBoolean : null;
            if (object == null || (object = (String)object.getValue()) == null) {
                return null;
            }
            Object constant = object;
            Comparable<Boolean> comparable = SqlDfaPsiUtilKt.parseBoolean((String)constant);
            if (comparable == null) {
                comparable = SqlDfaPsiUtilKt.parseInt((String)constant);
            }
            return (value = comparable) instanceof Boolean ? (SqlDfBooleanType)SqlDfTypesKt.booleanValue(value) : (Intrinsics.areEqual((Object)value, (Object)0) || Intrinsics.areEqual((Object)value, (Object)1) ? (SqlDfBooleanType)SqlDfTypesKt.booleanValue(Intrinsics.areEqual((Object)value, (Object)1)) : null);
        }
        if (dbms2.isMysql()) {
            SqlDfFloatingPointType sqlDfFloatingPointType = SqlDfTypesKt.tryCastToFloating($this$tryCastToBoolean, dialect);
            sqlDfBooleanType = sqlDfFloatingPointType != null ? SqlDfTypesKt.tryCastToBoolean(sqlDfFloatingPointType, dialect) : null;
        } else {
            sqlDfBooleanType = null;
        }
        return sqlDfBooleanType;
    }

    @Nullable
    public static final SqlDfBooleanType tryCastToBoolean(@NotNull SqlDfIntegralType $this$tryCastToBoolean, @NotNull SqlLanguageDialectEx dialect) {
        SqlDfBooleanType sqlDfBooleanType;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToBoolean, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isMysql()) {
            SqlDfIntegralType sqlDfIntegralType = $this$tryCastToBoolean;
            if (sqlDfIntegralType instanceof SqlDfIntConstantType) {
                Integer n = (Integer)((SqlDfIntConstantType)$this$tryCastToBoolean).getValue();
                sqlDfBooleanType = SqlDfTypesKt.booleanValue(n == null || n != 0);
            } else if (sqlDfIntegralType instanceof SqlDfBigIntConstantType) {
                Long l = (Long)((SqlDfBigIntConstantType)$this$tryCastToBoolean).getValue();
                long l2 = 0L;
                sqlDfBooleanType = SqlDfTypesKt.booleanValue(l == null || l != l2);
            } else {
                DfType dfType = BOOLEAN.setNullability($this$tryCastToBoolean.getNullability());
                Intrinsics.checkNotNull((Object)dfType, (String)"null cannot be cast to non-null type com.intellij.sql.inspections.dataflow.types.SqlDfBooleanType");
                sqlDfBooleanType = (SqlDfBooleanType)dfType;
            }
        } else {
            sqlDfBooleanType = null;
        }
        return sqlDfBooleanType;
    }

    @Nullable
    public static final SqlDfDoubleType tryCastToDouble(@NotNull SqlDfIntegralType $this$tryCastToDouble, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToDouble, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isMysql() || dbms2.isPostgres() || dbms2.isMicrosoft()) {
            Object object;
            return $this$tryCastToDouble instanceof SqlDfConstantType ? (SqlDfDoubleType)(Intrinsics.areEqual((Object)(object = ((SqlDfConstantType)((Object)$this$tryCastToDouble)).getValue()), (Object)0L) || Intrinsics.areEqual((Object)object, (Object)0) ? SqlDfTypesKt.doubleValue(0.0) : (Intrinsics.areEqual((Object)object, (Object)1L) || Intrinsics.areEqual((Object)object, (Object)1) ? SqlDfTypesKt.doubleValue(1.0) : null)) : SqlDfTypesKt.doubleType($this$tryCastToDouble.getNullability());
        }
        return null;
    }

    @Nullable
    public static final SqlDfRealType tryCastToReal(@NotNull SqlDfIntegralType $this$tryCastToReal, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToReal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isMysql() || dbms2.isPostgres() || dbms2.isMicrosoft()) {
            Object object;
            return $this$tryCastToReal instanceof SqlDfConstantType ? (SqlDfRealType)(Intrinsics.areEqual((Object)(object = ((SqlDfConstantType)((Object)$this$tryCastToReal)).getValue()), (Object)0L) || Intrinsics.areEqual((Object)object, (Object)0) ? SqlDfTypesKt.realValue(0.0f) : (Intrinsics.areEqual((Object)object, (Object)1L) || Intrinsics.areEqual((Object)object, (Object)1) ? SqlDfTypesKt.realValue(1.0f) : null)) : SqlDfTypesKt.realType($this$tryCastToReal.getNullability());
        }
        return null;
    }

    @Nullable
    public static final SqlDfNumericType tryCastToNumeric(@NotNull SqlDfIntegralType $this$tryCastToNumeric, @NotNull SqlLanguageDialectEx dialect) {
        SqlDfNumericType sqlDfNumericType;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToNumeric, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isMysql() || dbms2.isPostgres() || dbms2.isMicrosoft()) {
            SqlDfIntegralType sqlDfIntegralType = $this$tryCastToNumeric;
            if (sqlDfIntegralType instanceof SqlDfIntConstantType) {
                BigDecimal bigDecimal = BigDecimal.valueOf(((Number)((SqlDfIntConstantType)$this$tryCastToNumeric).getValue()).intValue());
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
                sqlDfNumericType = SqlDfTypesKt.numericValue(bigDecimal);
            } else if (sqlDfIntegralType instanceof SqlDfBigIntConstantType) {
                BigDecimal bigDecimal = BigDecimal.valueOf(((Number)((SqlDfBigIntConstantType)$this$tryCastToNumeric).getValue()).longValue());
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
                sqlDfNumericType = SqlDfTypesKt.numericValue(bigDecimal);
            } else {
                sqlDfNumericType = SqlDfTypesKt.numericType($this$tryCastToNumeric.getNullability());
            }
        } else {
            sqlDfNumericType = null;
        }
        return sqlDfNumericType;
    }

    @Nullable
    public static final SqlDfBigIntType tryCastToBigInt(@NotNull SqlDfIntType $this$tryCastToBigInt, @NotNull SqlLanguageDialectEx dialect) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToBigInt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        return dbms2.isMysql() || dbms2.isPostgres() || dbms2.isMicrosoft() ? ($this$tryCastToBigInt instanceof SqlDfIntConstantType ? (SqlDfBigIntType)SqlDfTypesKt.bigintValue(((Number)((SqlDfIntConstantType)$this$tryCastToBigInt).getValue()).intValue()) : ((dfType = SqlDfTypesKt.setNullability(SqlDfTypesKt.bigintRange($this$tryCastToBigInt.getRange(), $this$tryCastToBigInt.getWideRange()), $this$tryCastToBigInt.getNullability())) instanceof SqlDfBigIntType ? (SqlDfBigIntType)dfType : null)) : null;
    }

    @Nullable
    public static final DfType tryCastToDouble(@NotNull DfType $this$tryCastToDouble, @NotNull SqlLanguageDialectEx dialect) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToDouble, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        if ($this$tryCastToDouble instanceof SqlDfDoubleType || SqlDfTypesKt.isNull($this$tryCastToDouble)) {
            return $this$tryCastToDouble;
        }
        DfType dfType = $this$tryCastToDouble;
        if (dfType instanceof SqlDfRealType) {
            object = SqlDfTypesKt.tryCastToDouble((SqlDfRealType)$this$tryCastToDouble, dialect);
        } else if (dfType instanceof SqlDfNumericType) {
            object = SqlDfTypesKt.tryCastToDouble((SqlDfNumericType)$this$tryCastToDouble, dialect);
        } else if (dfType instanceof SqlDfIntegralType) {
            object = SqlDfTypesKt.tryCastToDouble((SqlDfIntegralType)$this$tryCastToDouble, dialect);
        } else if (dfType instanceof SqlDfBooleanType) {
            SqlDfIntegralType sqlDfIntegralType = SqlDfTypesKt.tryCastToIntegral((SqlDfBooleanType)$this$tryCastToDouble, dialect);
            object = sqlDfIntegralType != null ? SqlDfTypesKt.tryCastToDouble(sqlDfIntegralType, dialect) : null;
        } else if (dfType instanceof SqlDfTextType) {
            SqlDfFloatingPointType sqlDfFloatingPointType = SqlDfTypesKt.tryCastToFloating((SqlDfTextType)$this$tryCastToDouble, dialect);
            object = sqlDfFloatingPointType != null ? SqlDfTypesKt.tryCastToDouble(sqlDfFloatingPointType, dialect) : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final DfType tryCastToReal(@NotNull DfType $this$tryCastToReal, @NotNull SqlLanguageDialectEx dialect) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToReal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        if ($this$tryCastToReal instanceof SqlDfRealType || SqlDfTypesKt.isNull($this$tryCastToReal)) {
            return $this$tryCastToReal;
        }
        DfType dfType = $this$tryCastToReal;
        if (dfType instanceof SqlDfNumericType) {
            object = SqlDfTypesKt.tryCastToReal((SqlDfNumericType)$this$tryCastToReal, dialect);
        } else if (dfType instanceof SqlDfIntegralType) {
            object = SqlDfTypesKt.tryCastToReal((SqlDfIntegralType)$this$tryCastToReal, dialect);
        } else if (dfType instanceof SqlDfBooleanType) {
            SqlDfIntegralType sqlDfIntegralType = SqlDfTypesKt.tryCastToIntegral((SqlDfBooleanType)$this$tryCastToReal, dialect);
            object = sqlDfIntegralType != null ? SqlDfTypesKt.tryCastToReal(sqlDfIntegralType, dialect) : null;
        } else if (dfType instanceof SqlDfTextType) {
            SqlDfFloatingPointType sqlDfFloatingPointType = SqlDfTypesKt.tryCastToFloating((SqlDfTextType)$this$tryCastToReal, dialect);
            object = sqlDfFloatingPointType != null ? SqlDfTypesKt.tryCastToReal(sqlDfFloatingPointType, dialect) : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final DfType tryCastToNumeric(@NotNull DfType $this$tryCastToNumeric, @NotNull SqlLanguageDialectEx dialect) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToNumeric, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        if ($this$tryCastToNumeric instanceof SqlDfNumericType || SqlDfTypesKt.isNull($this$tryCastToNumeric)) {
            return $this$tryCastToNumeric;
        }
        DfType dfType2 = $this$tryCastToNumeric;
        if (dfType2 instanceof SqlDfIntegralType) {
            dfType = SqlDfTypesKt.tryCastToNumeric((SqlDfIntegralType)$this$tryCastToNumeric, dialect);
        } else if (dfType2 instanceof SqlDfTextType) {
            dfType = SqlDfTypesKt.tryCastToNumeric((SqlDfTextType)$this$tryCastToNumeric, dialect);
        } else if (dfType2 instanceof SqlDfBooleanType) {
            SqlDfIntegralType sqlDfIntegralType = SqlDfTypesKt.tryCastToIntegral((SqlDfBooleanType)$this$tryCastToNumeric, dialect);
            dfType = sqlDfIntegralType != null ? SqlDfTypesKt.tryCastToNumeric(sqlDfIntegralType, dialect) : null;
        } else {
            dfType = null;
        }
        return dfType;
    }

    @Nullable
    public static final DfType tryCastToIntegral(@NotNull DfType $this$tryCastToIntegral, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToIntegral, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        if ($this$tryCastToIntegral instanceof SqlDfIntegralType || SqlDfTypesKt.isNull($this$tryCastToIntegral)) {
            return $this$tryCastToIntegral;
        }
        DfType dfType = $this$tryCastToIntegral;
        return dfType instanceof SqlDfBooleanType ? (DfType)SqlDfTypesKt.tryCastToIntegral((SqlDfBooleanType)$this$tryCastToIntegral, dialect) : (dfType instanceof SqlDfTextType ? (DfType)SqlDfTypesKt.tryCastToIntegral((SqlDfTextType)$this$tryCastToIntegral, dialect) : null);
    }

    @Nullable
    public static final DfType tryCastToInt(@NotNull DfType $this$tryCastToInt, @NotNull SqlLanguageDialectEx dialect) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToInt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        if ($this$tryCastToInt instanceof SqlDfIntType || SqlDfTypesKt.isNull($this$tryCastToInt)) {
            return $this$tryCastToInt;
        }
        DfType dfType = $this$tryCastToInt;
        if (dfType instanceof SqlDfTextType || dfType instanceof SqlDfBooleanType) {
            DfType dfType2 = SqlDfTypesKt.tryCastToIntegral($this$tryCastToInt, dialect);
            object = dfType2 != null ? SqlDfTypesKt.tryCastToInt(dfType2, dialect) : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final DfType tryCastToBigInt(@NotNull DfType $this$tryCastToBigInt, @NotNull SqlLanguageDialectEx dialect) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToBigInt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        if ($this$tryCastToBigInt instanceof SqlDfBigIntType || SqlDfTypesKt.isNull($this$tryCastToBigInt)) {
            return $this$tryCastToBigInt;
        }
        DfType dfType = $this$tryCastToBigInt;
        if (dfType instanceof SqlDfIntType) {
            object = SqlDfTypesKt.tryCastToBigInt((SqlDfIntType)$this$tryCastToBigInt, dialect);
        } else if (dfType instanceof SqlDfTextType || dfType instanceof SqlDfBooleanType) {
            DfType dfType2 = SqlDfTypesKt.tryCastToIntegral($this$tryCastToBigInt, dialect);
            object = dfType2 != null ? SqlDfTypesKt.tryCastToBigInt(dfType2, dialect) : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final DfType tryCastToBoolean(@NotNull DfType $this$tryCastToBoolean, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToBoolean, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        if ($this$tryCastToBoolean instanceof SqlDfBooleanType || SqlDfTypesKt.isNull($this$tryCastToBoolean)) {
            return $this$tryCastToBoolean;
        }
        DfType dfType = $this$tryCastToBoolean;
        return dfType instanceof SqlDfFloatingPointType ? (DfType)SqlDfTypesKt.tryCastToBoolean((SqlDfFloatingPointType)$this$tryCastToBoolean, dialect) : (dfType instanceof SqlDfNumericType ? (DfType)SqlDfTypesKt.tryCastToBoolean((SqlDfNumericType)$this$tryCastToBoolean, dialect) : (dfType instanceof SqlDfIntegralType ? (DfType)SqlDfTypesKt.tryCastToBoolean((SqlDfIntegralType)$this$tryCastToBoolean, dialect) : (dfType instanceof SqlDfTextType ? (DfType)SqlDfTypesKt.tryCastToBoolean((SqlDfTextType)$this$tryCastToBoolean, dialect) : null)));
    }

    @Nullable
    public static final DfType tryCastToText(@NotNull DfType $this$tryCastToText, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)$this$tryCastToText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        if ($this$tryCastToText instanceof SqlDfTextType || SqlDfTypesKt.isNull($this$tryCastToText)) {
            return $this$tryCastToText;
        }
        DfType dfType = $this$tryCastToText;
        return dfType instanceof SqlDfFloatingPointType ? (DfType)SqlDfTypesKt.tryCastToText((SqlDfFloatingPointType)$this$tryCastToText, dialect) : (dfType instanceof SqlDfNumericType ? (DfType)SqlDfTypesKt.tryCastToText((SqlDfNumericType)$this$tryCastToText, dialect) : (dfType instanceof SqlDfIntegralType ? (DfType)SqlDfTypesKt.tryCastToText((SqlDfIntegralType)$this$tryCastToText, dialect) : (dfType instanceof SqlDfBooleanType ? (DfType)SqlDfTypesKt.tryCastToText((SqlDfBooleanType)$this$tryCastToText, dialect) : null)));
    }

    @NotNull
    public static final Pair<SqlDfNumericType, SqlDfNumericType> balanceNumerics(@Nullable SqlDfNumericType left, @Nullable SqlDfNumericType right) {
        if (!(left instanceof SqlDfNumericConstantType) || !(right instanceof SqlDfNumericConstantType)) {
            return TuplesKt.to((Object)left, (Object)right);
        }
        try {
            int leftExactIntValue = ((BigDecimal)((SqlDfNumericConstantType)left).getValue()).intValueExact();
            int rightExactIntValue = ((BigDecimal)((SqlDfNumericConstantType)right).getValue()).intValueExact();
            return TuplesKt.to((Object)SqlDfTypesKt.numericValue(new BigDecimal(leftExactIntValue)), (Object)SqlDfTypesKt.numericValue(new BigDecimal(rightExactIntValue)));
        }
        catch (ArithmeticException e) {
            return TuplesKt.to((Object)left, (Object)right);
        }
    }

    @NotNull
    public static final Pair<DfType, DfType> balanceTypes(@NotNull DfType right, @NotNull DfType left, @NotNull SqlLanguageDialectEx dialect) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        if (Intrinsics.areEqual((Object)right, (Object)NULL) || Intrinsics.areEqual((Object)left, (Object)NULL)) {
            pair = TuplesKt.to((Object)right, (Object)left);
        } else if (Intrinsics.areEqual((Object)right, (Object)DfType.TOP) || Intrinsics.areEqual((Object)left, (Object)DfType.TOP)) {
            pair = TuplesKt.to((Object)right, (Object)left);
        } else if (right instanceof SqlDfTextType && left instanceof SqlDfTextType) {
            pair = TuplesKt.to((Object)right, (Object)left);
        } else if ((right instanceof SqlDfTextType || left instanceof SqlDfTextType) && dialect.getDbms().isMysql()) {
            pair = TuplesKt.to((Object)SqlDfTypesKt.tryCastToDouble(right, dialect), (Object)SqlDfTypesKt.tryCastToDouble(left, dialect));
        } else if (right instanceof SqlDfDoubleType || left instanceof SqlDfDoubleType) {
            pair = TuplesKt.to((Object)SqlDfTypesKt.tryCastToDouble(right, dialect), (Object)SqlDfTypesKt.tryCastToDouble(left, dialect));
        } else if (right instanceof SqlDfRealType || left instanceof SqlDfRealType) {
            pair = TuplesKt.to((Object)SqlDfTypesKt.tryCastToReal(right, dialect), (Object)SqlDfTypesKt.tryCastToReal(left, dialect));
        } else if (right instanceof SqlDfNumericType || left instanceof SqlDfNumericType) {
            DfType dfType = SqlDfTypesKt.tryCastToNumeric(right, dialect);
            SqlDfNumericType sqlDfNumericType = dfType instanceof SqlDfNumericType ? (SqlDfNumericType)dfType : null;
            dfType = SqlDfTypesKt.tryCastToNumeric(left, dialect);
            pair = SqlDfTypesKt.balanceNumerics(sqlDfNumericType, dfType instanceof SqlDfNumericType ? (SqlDfNumericType)dfType : null);
        } else {
            pair = right instanceof SqlDfBigIntType || left instanceof SqlDfBigIntType ? TuplesKt.to((Object)SqlDfTypesKt.tryCastToBigInt(right, dialect), (Object)SqlDfTypesKt.tryCastToBigInt(left, dialect)) : (right instanceof SqlDfIntType || left instanceof SqlDfIntType ? TuplesKt.to((Object)SqlDfTypesKt.tryCastToInt(right, dialect), (Object)SqlDfTypesKt.tryCastToInt(left, dialect)) : (right instanceof SqlDfBooleanType || left instanceof SqlDfBooleanType ? TuplesKt.to((Object)SqlDfTypesKt.tryCastToBoolean(right, dialect), (Object)SqlDfTypesKt.tryCastToBoolean(left, dialect)) : TuplesKt.to(null, null)));
        }
        return pair;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LongRangeType.values().length];
            try {
                nArray[LongRangeType.INT32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LongRangeType.INT64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SqlDfaNullability.values().length];
            try {
                nArray[SqlDfaNullability.NULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlDfaNullability.NULLABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlDfaNullability.NOT_NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

