/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.annotation.VisibleForTesting;
import androidx.compose.foundation.text.Handle;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionManager;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.unit.IntSize;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\b\u0010\t\u001a*\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a*\u0010\u000f\u001a\u00020\u00012\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0001\u001a\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0000\u001a\u001e\u0010\u001a\u001a\u00020\u001b*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0003H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H 0\u0011\"\u0004\b\u0000\u0010 *\b\u0012\u0004\u0012\u0002H 0\u0011H\u0002\u001a\f\u0010!\u001a\u00020\u0001*\u00020\u0016H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\""}, d2={"invertedInfiniteRect", "Landroidx/compose/ui/geometry/Rect;", "calculateSelectionMagnifierCenterAndroid", "Landroidx/compose/ui/geometry/Offset;", "manager", "Landroidx/compose/foundation/text/selection/SelectionManager;", "magnifierSize", "Landroidx/compose/ui/unit/IntSize;", "calculateSelectionMagnifierCenterAndroid-O0kMr_c", "(Landroidx/compose/foundation/text/selection/SelectionManager;J)J", "getMagnifierCenter", "anchor", "Landroidx/compose/foundation/text/selection/Selection$AnchorInfo;", "getMagnifierCenter-JVtK1S4", "(Landroidx/compose/foundation/text/selection/SelectionManager;JLandroidx/compose/foundation/text/selection/Selection$AnchorInfo;)J", "getSelectedRegionRect", "selectableSubSelectionPairs", "", "Lkotlin/Pair;", "Landroidx/compose/foundation/text/selection/Selectable;", "Landroidx/compose/foundation/text/selection/Selection;", "containerCoordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "merge", "lhs", "rhs", "containsInclusive", "", "offset", "containsInclusive-Uv8p0NA", "(Landroidx/compose/ui/geometry/Rect;J)Z", "firstAndLast", "T", "visibleBounds", "foundation"})
@SourceDebugExtension(value={"SMAP\nSelectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionManager.kt\nandroidx/compose/foundation/text/selection/SelectionManagerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 6 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 7 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n*L\n1#1,1110:1\n34#2,4:1111\n39#2:1135\n30#3:1115\n30#3:1119\n30#3:1141\n53#4,3:1116\n53#4,3:1120\n60#4:1124\n70#4:1127\n60#4:1130\n70#4:1133\n60#4:1137\n85#4:1140\n53#4,3:1142\n60#4:1146\n70#4:1149\n65#5:1123\n69#5:1126\n65#5:1129\n69#5:1132\n65#5:1136\n65#5:1145\n69#5:1148\n22#6:1125\n22#6:1128\n22#6:1131\n22#6:1134\n22#6:1138\n22#6:1147\n54#7:1139\n*S KotlinDebug\n*F\n+ 1 SelectionManager.kt\nandroidx/compose/foundation/text/selection/SelectionManagerKt\n*L\n981#1:1111,4\n981#1:1135\n1004#1:1115\n1005#1:1119\n1092#1:1141\n1004#1:1116,3\n1005#1:1120,3\n1011#1:1124\n1012#1:1127\n1013#1:1130\n1014#1:1133\n1048#1:1137\n1080#1:1140\n1092#1:1142,3\n1106#1:1146\n1106#1:1149\n1011#1:1123\n1012#1:1126\n1013#1:1129\n1014#1:1132\n1048#1:1136\n1106#1:1145\n1106#1:1148\n1011#1:1125\n1012#1:1128\n1013#1:1131\n1014#1:1134\n1048#1:1138\n1106#1:1147\n1080#1:1139\n*E\n"})
public final class SelectionManagerKt {
    @NotNull
    private static final Rect invertedInfiniteRect = new Rect(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);

    @Nullable
    public static final Selection merge(@Nullable Selection lhs, @Nullable Selection rhs) {
        Selection selection = lhs;
        if (selection == null || (selection = selection.merge(rhs)) == null) {
            selection = rhs;
        }
        return selection;
    }

    private static final <T> List<T> firstAndLast(List<? extends T> $this$firstAndLast) {
        List list2;
        switch ($this$firstAndLast.size()) {
            case 0: 
            case 1: {
                list2 = $this$firstAndLast;
                break;
            }
            default: {
                Object[] objectArray = new Object[]{CollectionsKt.first($this$firstAndLast), CollectionsKt.last($this$firstAndLast)};
                list2 = CollectionsKt.listOf((Object[])objectArray);
            }
        }
        return list2;
    }

    @VisibleForTesting
    @NotNull
    public static final Rect getSelectedRegionRect(@NotNull List<? extends Pair<? extends Selectable, Selection>> selectableSubSelectionPairs, @NotNull LayoutCoordinates containerCoordinates) {
        Intrinsics.checkNotNullParameter(selectableSubSelectionPairs, (String)"selectableSubSelectionPairs");
        Intrinsics.checkNotNullParameter((Object)containerCoordinates, (String)"containerCoordinates");
        if (selectableSubSelectionPairs.isEmpty()) {
            return invertedInfiniteRect;
        }
        Rect rect = invertedInfiniteRect;
        float containerLeft = 0.0f;
        containerLeft = rect.component1();
        float containerTop = 0.0f;
        containerTop = rect.component2();
        float containerRight = 0.0f;
        containerRight = rect.component3();
        float containerBottom = 0.0f;
        containerBottom = rect.component4();
        List<? extends Pair<? extends Selectable, Selection>> $this$fastForEach$iv = selectableSubSelectionPairs;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            LayoutCoordinates localCoordinates;
            Object object;
            Object object2;
            int maxOffset;
            int endOffset;
            Pair<? extends Selectable, Selection> item$iv;
            Pair<? extends Selectable, Selection> pair = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            Selectable selectable2 = (Selectable)pair.component1();
            Selection subSelection = (Selection)pair.component2();
            int startOffset = subSelection.getStart().getOffset();
            if (startOffset == (endOffset = subSelection.getEnd().getOffset()) || selectable2.getLayoutCoordinates() == null) continue;
            int minOffset = Math.min(startOffset, endOffset);
            if (minOffset == (maxOffset = Math.max(startOffset, endOffset)) - 1) {
                object2 = new int[]{minOffset};
                object = object2;
            } else {
                object2 = new int[]{minOffset, maxOffset - 1};
                object = object2;
            }
            int[] offsets = object;
            object2 = invertedInfiniteRect;
            float left = object2.component1();
            float top = object2.component2();
            float right = object2.component3();
            float bottom = object2.component4();
            for (int i : offsets) {
                Rect rect2 = selectable2.getBoundingBox(i);
                left = Math.min(left, rect2.getLeft());
                top = Math.min(top, rect2.getTop());
                right = Math.max(right, rect2.getRight());
                bottom = Math.max(bottom, rect2.getBottom());
            }
            boolean $i$f$Offset = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits(left);
            long v2$iv$iv = Float.floatToRawIntBits(top);
            long localTopLeft = Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
            boolean $i$f$Offset2 = false;
            boolean $i$f$packFloats2 = false;
            long v1$iv$iv2 = Float.floatToRawIntBits(right);
            long v2$iv$iv2 = Float.floatToRawIntBits(bottom);
            long localBottomRight = Offset.constructor-impl(v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL);
            long containerTopLeft = containerCoordinates.localPositionOf-R5De75A(localCoordinates, localTopLeft);
            long containerBottomRight = containerCoordinates.localPositionOf-R5De75A(localCoordinates, localBottomRight);
            float f = containerLeft;
            boolean $i$f$getX-impl22 = false;
            long value$iv$iv = containerTopLeft;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            float $i$f$getX-impl22 = Float.intBitsToFloat(bits$iv$iv$iv);
            containerLeft = Math.min(f, $i$f$getX-impl22);
            f = containerTop;
            boolean $i$f$getY-impl22 = false;
            value$iv$iv = containerTopLeft;
            boolean $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            float $i$f$getY-impl22 = Float.intBitsToFloat(bits$iv$iv$iv);
            containerTop = Math.min(f, $i$f$getY-impl22);
            f = containerRight;
            boolean $i$f$getX-impl32 = false;
            value$iv$iv = containerBottomRight;
            $i$f$unpackFloat1 = false;
            bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            $i$f$floatFromBits = false;
            float $i$f$getX-impl32 = Float.intBitsToFloat(bits$iv$iv$iv);
            containerRight = Math.max(f, $i$f$getX-impl32);
            f = containerBottom;
            boolean bl2 = false;
            value$iv$iv = containerBottomRight;
            $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            float f2 = Float.intBitsToFloat(bits$iv$iv$iv);
            containerBottom = Math.max(f, f2);
        }
        return new Rect(containerLeft, containerTop, containerRight, containerBottom);
    }

    public static final long calculateSelectionMagnifierCenterAndroid-O0kMr_c(@NotNull SelectionManager manager, long magnifierSize) {
        long l;
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Selection selection = manager.getSelection();
        if (selection == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Selection selection2 = selection;
        Handle handle = manager.getDraggingHandle();
        switch (handle == null ? -1 : WhenMappings.$EnumSwitchMapping$0[handle.ordinal()]) {
            case -1: {
                return Offset.Companion.getUnspecified-F1C5BW0();
            }
            case 1: {
                l = SelectionManagerKt.getMagnifierCenter-JVtK1S4(manager, magnifierSize, selection2.getStart());
                break;
            }
            case 2: {
                l = SelectionManagerKt.getMagnifierCenter-JVtK1S4(manager, magnifierSize, selection2.getEnd());
                break;
            }
            case 3: {
                throw new IllegalStateException("SelectionContainer does not support cursor".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return l;
    }

    private static final long getMagnifierCenter-JVtK1S4(SelectionManager manager, long magnifierSize, Selection.AnchorInfo anchor) {
        float lineCenterY;
        float textConstrainedX;
        float f;
        Selectable selectable2 = manager.getAnchorSelectable$foundation(anchor);
        if (selectable2 == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Selectable selectable3 = selectable2;
        LayoutCoordinates layoutCoordinates = manager.getContainerLayoutCoordinates();
        if (layoutCoordinates == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        LayoutCoordinates containerCoordinates = layoutCoordinates;
        LayoutCoordinates layoutCoordinates2 = selectable3.getLayoutCoordinates();
        if (layoutCoordinates2 == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        LayoutCoordinates selectableCoordinates = layoutCoordinates2;
        int offset2 = anchor.getOffset();
        if (offset2 > selectable3.getLastVisibleOffset()) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Offset offset3 = manager.getCurrentDragPosition-_m7T9-E();
        Intrinsics.checkNotNull((Object)offset3);
        long localDragPosition = selectableCoordinates.localPositionOf-R5De75A(containerCoordinates, offset3.unbox-impl());
        boolean bl = false;
        long value$iv$iv = localDragPosition;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float dragX = Float.intBitsToFloat(bits$iv$iv$iv);
        long lineRange = selectable3.getRangeOfLineContaining--jx7JFs(offset2);
        if (TextRange.getCollapsed-impl(lineRange)) {
            f = selectable3.getLineLeft(offset2);
        } else {
            float lineStartX = selectable3.getLineLeft(TextRange.getStart-impl(lineRange));
            float lineEndX = selectable3.getLineRight(TextRange.getEnd-impl(lineRange) - 1);
            float minX = Math.min(lineStartX, lineEndX);
            float maxX = Math.max(lineStartX, lineEndX);
            f = textConstrainedX = RangesKt.coerceIn((float)dragX, (float)minX, (float)maxX);
        }
        if (textConstrainedX == -1.0f) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        if (!IntSize.equals-impl0(magnifierSize, IntSize.Companion.getZero-YbymL2g())) {
            boolean bl2 = false;
            long value$iv$iv2 = magnifierSize;
            boolean $i$f$unpackInt1 = false;
            if (Math.abs(dragX - textConstrainedX) > (float)((int)(value$iv$iv2 >> 32) / 2)) {
                return Offset.Companion.getUnspecified-F1C5BW0();
            }
        }
        if ((lineCenterY = selectable3.getCenterYForOffset(offset2)) == -1.0f) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits(textConstrainedX);
        long v2$iv$iv = Float.floatToRawIntBits(lineCenterY);
        return containerCoordinates.localPositionOf-R5De75A(selectableCoordinates, Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
    }

    @NotNull
    public static final Rect visibleBounds(@NotNull LayoutCoordinates $this$visibleBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$visibleBounds, (String)"<this>");
        Rect boundsInWindow = LayoutCoordinatesKt.boundsInWindow($this$visibleBounds);
        return RectKt.Rect-0a9Yr6o($this$visibleBounds.windowToLocal-MK-Hz9U(boundsInWindow.getTopLeft-F1C5BW0()), $this$visibleBounds.windowToLocal-MK-Hz9U(boundsInWindow.getBottomRight-F1C5BW0()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean containsInclusive-Uv8p0NA(@NotNull Rect $this$containsInclusive_u2dUv8p0NA, long offset2) {
        Intrinsics.checkNotNullParameter((Object)$this$containsInclusive_u2dUv8p0NA, (String)"$this$containsInclusive");
        float f = $this$containsInclusive_u2dUv8p0NA.getLeft();
        float f2 = $this$containsInclusive_u2dUv8p0NA.getRight();
        boolean bl = false;
        long value$iv$iv = offset2;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float f3 = Float.intBitsToFloat(bits$iv$iv$iv);
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        f = $this$containsInclusive_u2dUv8p0NA.getTop();
        f2 = $this$containsInclusive_u2dUv8p0NA.getBottom();
        boolean bl3 = false;
        value$iv$iv = offset2;
        boolean $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        f3 = Float.intBitsToFloat(bits$iv$iv$iv);
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        return true;
    }

    public static final /* synthetic */ List access$firstAndLast(List $receiver) {
        return SelectionManagerKt.firstAndLast($receiver);
    }

    public static final /* synthetic */ Rect access$getInvertedInfiniteRect$p() {
        return invertedInfiniteRect;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Handle.values().length];
            try {
                nArray[Handle.SelectionStart.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Handle.SelectionEnd.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Handle.Cursor.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

