/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.usages;

import com.intellij.find.usages.api.PsiUsage;
import com.intellij.find.usages.api.Usage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.impl.usages.LspSearchTarget;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceContext;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/lsp/impl/usages/LspReferencesQuery;", "Lcom/intellij/util/AbstractQuery;", "Lcom/intellij/find/usages/api/Usage;", "searchTarget", "Lcom/intellij/platform/lsp/impl/usages/LspSearchTarget;", "LspReferencesQuery", "(Lcom/intellij/platform/lsp/impl/usages/LspSearchTarget;)V", "processResults", "", "consumer", "Lcom/intellij/util/Processor;", "intellij.platform.lsp.impl"})
final class LspReferencesQuery
extends AbstractQuery<Usage> {
    @NotNull
    private final LspSearchTarget searchTarget;

    public LspReferencesQuery(@NotNull LspSearchTarget searchTarget) {
        Intrinsics.checkNotNullParameter((Object)searchTarget, (String)"searchTarget");
        this.searchTarget = searchTarget;
    }

    protected boolean processResults(@NotNull Processor<? super Usage> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        for (LspServer lspServer : this.searchTarget.getLspServers()) {
            TextDocumentIdentifier textDocumentIdentifier = lspServer.getDocumentIdentifier(this.searchTarget.getFile());
            ReferenceContext referenceContext = new ReferenceContext(true);
            ReferenceParams referenceParams = new ReferenceParams(textDocumentIdentifier, this.searchTarget.getPosition(), referenceContext);
            List list = (List)lspServer.sendRequestSync(60000, arg_0 -> LspReferencesQuery.f(referenceParams, arg_0));
            Collection collection = list;
            if (collection == null || collection.isEmpty()) continue;
            ReadAction.run(() -> LspReferencesQuery.f(lspServer, list, consumer));
        }
        return true;
    }

    private static final CompletableFuture f(ReferenceParams referenceParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        CompletableFuture completableFuture = languageServer.getTextDocumentService().references(referenceParams);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"references(...)");
        return completableFuture;
    }

    private static final void f(LspServer lspServer, List list, Processor processor) {
        PsiManager psiManager = PsiManager.getInstance((Project)lspServer.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        for (Location location : list) {
            TextRange textRange;
            PsiFile psiFile;
            VirtualFile virtualFile;
            LspServerDescriptor lspServerDescriptor = lspServer.getDescriptor();
            String string = location.getUri();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
            if (lspServerDescriptor.findFileByUri(string) == null || psiManager2.findFile(virtualFile) == null) continue;
            Document document = psiFile.getFileDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
            Range range = location.getRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getRange(...)");
            if (Lsp4jUtilKt.getRangeInDocument(document, range) == null) continue;
            processor.process((Object)PsiUsage.Companion.textUsage(psiFile, textRange));
        }
    }
}

