/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.openapi.util.TextRange;
import com.intellij.webcore.formatter.SpacingStrategy;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeBlock
implements Block {
    private final List<Block> myChildBlocks;
    private final Indent myIndent;
    private final SpacingStrategy mySpacingStrategy;
    private final TextRange myTextRange;

    public CompositeBlock(@NotNull List<Block> childBlocks, @NotNull SpacingStrategy spacingStrategy, @Nullable Indent indent) {
        if (childBlocks == null) {
            CompositeBlock.f(0);
        }
        if (spacingStrategy == null) {
            CompositeBlock.f(1);
        }
        this.myChildBlocks = childBlocks;
        this.myIndent = indent;
        assert (!childBlocks.isEmpty()) : "Attempt to create a composite block with no children";
        this.mySpacingStrategy = spacingStrategy;
        this.myTextRange = this.f();
    }

    @NotNull
    private TextRange f() {
        int n10 = Integer.MAX_VALUE;
        int n11 = -1;
        for (Block block : this.myChildBlocks) {
            n10 = Math.min(n10, block.getTextRange().getStartOffset());
            n11 = Math.max(n11, block.getTextRange().getEndOffset());
        }
        return new TextRange(n10, n11);
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            CompositeBlock.f(2);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = this.myChildBlocks;
        if (list == null) {
            CompositeBlock.f(3);
        }
        return list;
    }

    @Nullable
    public Wrap getWrap() {
        return null;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return null;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            CompositeBlock.f(4);
        }
        return this.mySpacingStrategy.getSpacing(child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(null, null);
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return false;
    }

    private static /* synthetic */ void f(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n10) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childBlocks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spacingStrategy";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/formatter/CompositeBlock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/formatter/CompositeBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n10) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

