/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.components.DiagramNodeContainer;
import com.intellij.diagram.components.DiagramNodeDeferredIconsEvaluator;
import com.intellij.diagram.components.DiagramNodeQuickDocHintManager;
import com.intellij.diagram.components.ScalableIconWrapper;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class DiagramNodeHeaderComponent
extends CellRendererPanel {
    @NotNull
    private final MyQuickDocHintManager myQuickDocHintManager;

    public DiagramNodeHeaderComponent(@NotNull DiagramBuilder builder, @NotNull DiagramNode<?> node) {
        if (builder == null) {
            DiagramNodeHeaderComponent.$$$reportNull$$$0(0);
        }
        if (node == null) {
            DiagramNodeHeaderComponent.$$$reportNull$$$0(1);
        }
        this.myQuickDocHintManager = new MyQuickDocHintManager(node, builder);
        this.setFocusable(false);
        this.setOpaque(true);
        this.setLayout(new BoxLayout((Container)((Object)this), 2));
        this.add(Box.createHorizontalGlue());
        this.add((Component)this.createLabel(node));
        this.setupMouseListeners();
    }

    protected void setupMouseListeners() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                DiagramNodeHeaderComponent.this.myQuickDocHintManager.onMouseMoved(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diagram/components/DiagramNodeHeaderComponent$1", "mouseMoved"));
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                DiagramNodeHeaderComponent.this.myQuickDocHintManager.onMouseExited(e);
            }
        });
        for (Component child : this.getComponents()) {
            child.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(@NotNull MouseEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    DiagramNodeHeaderComponent.redispatchEventToParent(e);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diagram/components/DiagramNodeHeaderComponent$3", "mouseMoved"));
                }
            });
            child.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    Point point = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), (Component)((Object)DiagramNodeHeaderComponent.this));
                    if (!DiagramNodeHeaderComponent.this.isInsideHeader(point)) {
                        DiagramNodeHeaderComponent.redispatchEventToParent(e);
                    }
                }
            });
        }
    }

    private static void redispatchEventToParent(@NotNull MouseEvent e) {
        if (e == null) {
            DiagramNodeHeaderComponent.$$$reportNull$$$0(2);
        }
        Component source = e.getComponent();
        MouseEvent parentEvent = SwingUtilities.convertMouseEvent(source, e, source.getParent());
        source.getParent().dispatchEvent(parentEvent);
    }

    private boolean isInsideHeader(@NotNull Point point) {
        if (point == null) {
            DiagramNodeHeaderComponent.$$$reportNull$$$0(3);
        }
        Dimension size = this.getSize();
        return 0 <= point.x && (double)point.x <= size.getWidth() + 3.0 && 0 <= point.y && (double)point.y <= size.getHeight();
    }

    @NotNull
    protected DiagramNodeContainer getContainerComponent() {
        DiagramNodeContainer diagramNodeContainer = Objects.requireNonNull((DiagramNodeContainer)((Object)ComponentUtil.getParentOfType(DiagramNodeContainer.class, (Component)((Object)this))));
        if (diagramNodeContainer == null) {
            DiagramNodeHeaderComponent.$$$reportNull$$$0(4);
        }
        return diagramNodeContainer;
    }

    @NotNull
    protected SimpleColoredComponent createLabel(@NotNull DiagramNode<?> node) {
        if (node == null) {
            DiagramNodeHeaderComponent.$$$reportNull$$$0(5);
        }
        SimpleColoredComponent label = new SimpleColoredComponent();
        Icon icon = DiagramNodeDeferredIconsEvaluator.getInstance().registerEvaluationOrGetReadyIcon(node, evaluatedIcon -> {
            label.setIcon(ScalableIconWrapper.wrap(evaluatedIcon, __ -> this.getContainerComponent().invalidateRenderCacheForCurrentRealizer()));
            this.getContainerComponent().invalidateRenderCacheForCurrentRealizer();
        });
        label.setBorder(JBUI.Borders.empty((int)3));
        label.setIpad((Insets)JBUI.insets((int)0, (int)4));
        label.setIcon(ScalableIconWrapper.wrap(icon, __ -> this.getContainerComponent().invalidateRenderCacheForCurrentRealizer()));
        SimpleColoredText presentableName = node.getPresentableTitle();
        if (presentableName != null) {
            presentableName.appendToComponent((ColoredTextContainer)label);
        }
        label.setOpaque(true);
        label.setIconOpaque(true);
        SimpleColoredComponent simpleColoredComponent = label;
        if (simpleColoredComponent == null) {
            DiagramNodeHeaderComponent.$$$reportNull$$$0(6);
        }
        return simpleColoredComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/components/DiagramNodeHeaderComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/components/DiagramNodeHeaderComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "redispatchEventToParent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInsideHeader";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }

    protected class MyQuickDocHintManager
    extends DiagramNodeQuickDocHintManager {
        MyQuickDocHintManager(@NotNull DiagramNode<?> node, DiagramBuilder builder) {
            if (node == null) {
                MyQuickDocHintManager.$$$reportNull$$$0(0);
            }
            if (builder == null) {
                MyQuickDocHintManager.$$$reportNull$$$0(1);
            }
            super(node, builder);
        }

        @Override
        protected Object getDocOwnerFor(@NotNull MouseEvent event) {
            if (event == null) {
                MyQuickDocHintManager.$$$reportNull$$$0(2);
            }
            Point eventPoint = event.getComponent() instanceof DiagramNodeHeaderComponent ? event.getPoint() : (event.getComponent() == this.getBuilder().getView().getCanvasComponent() ? this.convertCanvasPointToThisComponentPoint(event.getPoint()) : this.convertChildPointToThisComponentPoint(event.getPoint(), event.getComponent()));
            DiagramElementManager<?> elementManager = this.getBuilder().getProvider().getElementManager();
            return DiagramNodeHeaderComponent.this.isInsideHeader(eventPoint) ? elementManager.getElementDocOwner(this.getNode().getIdentifyingElement(), this.getBuilder()) : null;
        }

        @Override
        @NotNull
        protected Rectangle getDocOwnerBounds(Object docOwner) {
            Dimension size = DiagramNodeHeaderComponent.this.getSize();
            return new Rectangle(0, 0, size.width + 3, size.height);
        }

        @NotNull
        private Point convertChildPointToThisComponentPoint(@NotNull Point childPoint, @NotNull Component childComponent) {
            if (childPoint == null) {
                MyQuickDocHintManager.$$$reportNull$$$0(3);
            }
            if (childComponent == null) {
                MyQuickDocHintManager.$$$reportNull$$$0(4);
            }
            Point point = SwingUtilities.convertPoint(childComponent, childPoint, (Component)((Object)DiagramNodeHeaderComponent.this));
            if (point == null) {
                MyQuickDocHintManager.$$$reportNull$$$0(5);
            }
            return point;
        }

        @NotNull
        private Point convertCanvasPointToThisComponentPoint(@NotNull Point canvasPoint) {
            if (canvasPoint == null) {
                MyQuickDocHintManager.$$$reportNull$$$0(6);
            }
            Point nodeCanvasCoords = GraphCanvasLocationService.getInstance().getNodeCoordinatesOnCanvas(Objects.requireNonNull(this.getBuilder().getNode(this.getNode())), this.getBuilder().getGraphBuilder());
            double zoom = this.getBuilder().getView().getZoom();
            return new Point((int)((double)(canvasPoint.x - nodeCanvasCoords.x) / zoom), (int)((double)(canvasPoint.y - nodeCanvasCoords.y) / zoom));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childPoint";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childComponent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/components/DiagramNodeHeaderComponent$MyQuickDocHintManager";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "canvasPoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/components/DiagramNodeHeaderComponent$MyQuickDocHintManager";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertChildPointToThisComponentPoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDocOwnerFor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "convertChildPointToThisComponentPoint";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "convertCanvasPointToThisComponentPoint";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

