/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices.nestjs;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.microservices.nestjs.NestJSController;
import com.intellij.javascript.microservices.nestjs.NestJSEndpointsKt;
import com.intellij.javascript.microservices.nestjs.NestJSMapping;
import com.intellij.javascript.microservices.nestjs.NestJSUrlTargetInfo;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import icons.JavaScriptCoreIcons;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00132\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/microservices/nestjs/NestJSEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsUrlTargetProvider;", "Lcom/intellij/javascript/microservices/nestjs/NestJSController;", "Lcom/intellij/javascript/microservices/nestjs/NestJSMapping;", "<init>", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "project", "Lcom/intellij/openapi/project/Project;", "getEndpointGroups", "", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpoints", "group", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "endpoint", "isValidEndpoint", "", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.langInjection"})
@SourceDebugExtension(value={"SMAP\nNestJSEndpointsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NestJSEndpointsProvider.kt\ncom/intellij/javascript/microservices/nestjs/NestJSEndpointsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class NestJSEndpointsProvider
implements EndpointsUrlTargetProvider<NestJSController, NestJSMapping> {
    @NotNull
    private final EndpointType endpointType = EndpointTypes.HTTP_SERVER_TYPE;
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("NestJS", "NestJS", AllIcons.FileTypes.JavaScript);

    @NotNull
    public EndpointType getEndpointType() {
        return this.endpointType;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return NestJSEndpointsKt.hasNestJS(project) ? EndpointsProvider.Status.HAS_ENDPOINTS : EndpointsProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public Iterable<NestJSController> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        if (!NestJSEndpointsKt.hasNestJS(project)) {
            return CollectionsKt.emptyList();
        }
        return NestJSEndpointsKt.getNestJSControllers(project);
    }

    @NotNull
    public Iterable<NestJSMapping> getEndpoints(@NotNull NestJSController group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return NestJSEndpointsKt.getNestJSMappings(group);
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull NestJSController group, @NotNull NestJSMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        String it = endpoint.getPath();
        boolean bl = false;
        Object endpointPath = StringsKt.startsWith$default((CharSequence)it, (char)'/', (boolean)false, (int)2, null) ? it : "/" + it;
        Icon icon = endpoint.isTypeScript() ? JavaScriptCoreIcons.FileTypes.TypeScriptFile : AllIcons.FileTypes.JavaScript;
        Intrinsics.checkNotNull((Object)icon);
        Icon icon2 = icon;
        return (ItemPresentation)new HttpMethodPresentation((String)endpointPath, CollectionsKt.toList((Iterable)endpoint.getHttpMethods()), group.getName(), icon2, null, 16, null);
    }

    public boolean isValidEndpoint(@NotNull NestJSController group, @NotNull NestJSMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        PsiElement psiElement = endpoint.getDeclaration().getElement();
        return psiElement != null ? psiElement.isValid() : false;
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ModificationTracker modificationTracker = PsiManager.getInstance((Project)project).getModificationTracker().forLanguage((Language)JavascriptLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"forLanguage(...)");
        return modificationTracker;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull NestJSController group, @NotNull NestJSMapping endpoint) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Object object = endpoint.toUrlTargetInfo$intellij_javascript_langInjection();
        if (object != null) {
            NestJSUrlTargetInfo p0 = object;
            boolean bl = false;
            List list = CollectionsKt.listOf((Object)p0);
            object = list;
            if (list != null) {
                iterable = (Iterable)object;
                return iterable;
            }
        }
        iterable = CollectionsKt.emptyList();
        return iterable;
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull NestJSController group, @NotNull NestJSMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.getDeclaration().getElement();
    }
}

