/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpDependency;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpFile;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspace;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspaceList;
import com.intellij.javascript.nodejs.library.yarn.pnp.model.YarnPnpInfo;
import com.intellij.webcore.util.JsonUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 %2\u00020\u0001:\u0003#$%B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J0\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0000H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010!\u001a\u00060\u0016R\u00020\u00002\u0006\u0010\"\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeReader;", "", "pnpFile", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpFile;", "libraryNameProvider", "Lkotlin/Function1;", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpFile;Lkotlin/jvm/functions/Function1;)V", "read", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspaceList;", "jsonWithLocalPaths", "convertRawToModel", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependency;", "rawDeps", "", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeReader$RawDependency;", "info", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpInfo;", "rawWorkspaces", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeReader$RawWorkspaces;", "parseRawDependencies", "nodesArray", "Lcom/google/gson/JsonArray;", "toIntList", "Lit/unimi/dsi/fastutil/ints/IntList;", "intArray", "getId", "", "obj", "Lcom/google/gson/JsonObject;", "parseRawWorkspaces", "workspacesArray", "RawWorkspaces", "RawDependency", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nYarnPnpDependencyTreeReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YarnPnpDependencyTreeReader.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1563#2:129\n1634#2,3:130\n*S KotlinDebug\n*F\n+ 1 YarnPnpDependencyTreeReader.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeReader\n*L\n84#1:129\n84#1:130,3\n*E\n"})
public final class YarnPnpDependencyTreeReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final YarnPnpFile pnpFile;
    @NotNull
    private final Function1<String, String> libraryNameProvider;
    @NotNull
    public static final String REQUIREABLE_LOCATION = "requireableLocation";
    @NotNull
    public static final String RESOLVED_VIRTUAL_REQUIREABLE_LOCATION = "resolvedVirtualRequireableLocation";
    @NotNull
    public static final String LOCATION = "location";

    public YarnPnpDependencyTreeReader(@NotNull YarnPnpFile pnpFile, @NotNull Function1<? super String, String> libraryNameProvider) {
        Intrinsics.checkNotNullParameter((Object)pnpFile, (String)"pnpFile");
        Intrinsics.checkNotNullParameter(libraryNameProvider, (String)"libraryNameProvider");
        this.pnpFile = pnpFile;
        this.libraryNameProvider = libraryNameProvider;
    }

    @NotNull
    public final YarnPnpWorkspaceList read(@NotNull String jsonWithLocalPaths) {
        Intrinsics.checkNotNullParameter((Object)jsonWithLocalPaths, (String)"jsonWithLocalPaths");
        JsonObject rootObject = JsonParser.parseString((String)jsonWithLocalPaths).getAsJsonObject();
        JsonObject jsonObject = rootObject.getAsJsonObject("environment");
        Intrinsics.checkNotNull((Object)jsonObject);
        JsonObject environmentObject = jsonObject;
        YarnPnpInfo info = new YarnPnpInfo(JsonUtil.getChildAsBoolean((JsonObject)environmentObject, (String)"pnp.resolveVirtual", (boolean)false));
        JsonObject jsonObject2 = rootObject.getAsJsonObject("dependencyTree");
        Intrinsics.checkNotNull((Object)jsonObject2);
        JsonObject dependencyTreeObject = jsonObject2;
        JsonArray jsonArray = dependencyTreeObject.getAsJsonArray("nodes");
        Intrinsics.checkNotNull((Object)jsonArray);
        JsonArray nodesArray = jsonArray;
        List<RawDependency> rawDeps = this.parseRawDependencies(nodesArray);
        JsonArray jsonArray2 = dependencyTreeObject.getAsJsonArray("workspaces");
        Intrinsics.checkNotNull((Object)jsonArray2);
        RawWorkspaces rawWorkspaces = this.parseRawWorkspaces(jsonArray2);
        Int2ObjectMap<YarnPnpDependency> id2DepMap = this.convertRawToModel(rawDeps, info, rawWorkspaces);
        List<YarnPnpWorkspace> workspaces = rawWorkspaces.toModel(id2DepMap);
        Collection collection = id2DepMap.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
        return new YarnPnpWorkspaceList(jsonWithLocalPaths, workspaces, CollectionsKt.toList((Iterable)collection));
    }

    private final Int2ObjectMap<YarnPnpDependency> convertRawToModel(List<RawDependency> rawDeps, YarnPnpInfo info, RawWorkspaces rawWorkspaces) {
        Set<String> workspaceLocations = rawWorkspaces.buildWorkspaceLocations(rawDeps);
        Int2ObjectOpenHashMap result2 = YarnPnpDependencyTreeReader.Companion.map2mapById(rawDeps, arg_0 -> YarnPnpDependencyTreeReader.convertRawToModel$lambda$0(info, workspaceLocations, arg_0));
        for (RawDependency rawDependency : rawDeps) {
            List<YarnPnpDependency> childDeps = rawDependency.getDependencies().intStream().mapToObj(arg_0 -> YarnPnpDependencyTreeReader.convertRawToModel$lambda$1(result2, arg_0)).collect(Collectors.toList());
            Object object = result2.get(rawDependency.getId());
            Intrinsics.checkNotNull((Object)object);
            YarnPnpDependency modelDependency = (YarnPnpDependency)object;
            Intrinsics.checkNotNull(childDeps);
            modelDependency.setChildren(childDeps);
        }
        return (Int2ObjectMap)result2;
    }

    private final List<RawDependency> parseRawDependencies(JsonArray nodesArray) {
        List rawDependencies = new ArrayList(nodesArray.size());
        Iterator iterator = nodesArray.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String requireableLocation;
            String name;
            JsonElement nodeElement = (JsonElement)iterator2.next();
            Intrinsics.checkNotNull((Object)nodeElement, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
            JsonObject nodeObject = (JsonObject)nodeElement;
            int id = this.getId(nodeObject);
            Intrinsics.checkNotNull((Object)JsonUtil.getChildAsString((JsonObject)nodeObject, (String)"name"));
            Intrinsics.checkNotNull((Object)JsonUtil.getChildAsString((JsonObject)nodeObject, (String)REQUIREABLE_LOCATION));
            String resolvedVirtualRequireableLocation = JsonUtil.getChildAsString((JsonObject)nodeObject, (String)RESOLVED_VIRTUAL_REQUIREABLE_LOCATION);
            JsonArray jsonArray = nodeObject.getAsJsonArray("dependencies");
            Intrinsics.checkNotNull((Object)jsonArray);
            IntList dependencies = this.toIntList(jsonArray);
            rawDependencies.add(new RawDependency(id, name, requireableLocation, resolvedVirtualRequireableLocation, dependencies));
        }
        return rawDependencies;
    }

    private final IntList toIntList(JsonArray intArray) {
        IntList result2 = (IntList)new IntArrayList(intArray.size());
        Iterator iterator = intArray.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            JsonElement element2 = (JsonElement)iterator2.next();
            if (element2 instanceof JsonPrimitive && ((JsonPrimitive)element2).isNumber()) {
                result2.add(((JsonPrimitive)element2).getAsInt());
                continue;
            }
            throw new RuntimeException("Not an integer " + element2);
        }
        return result2;
    }

    private final int getId(JsonObject obj) {
        int id = JsonUtil.getChildAsInteger((JsonObject)obj, (String)"id", (int)-1);
        if (id < 0) {
            throw new RuntimeException("Incorrect id: " + obj.get("id"));
        }
        return id;
    }

    /*
     * WARNING - void declaration
     */
    private final RawWorkspaces parseRawWorkspaces(JsonArray workspacesArray) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = (Iterable)workspacesArray;
        YarnPnpDependencyTreeReader yarnPnpDependencyTreeReader = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonElement jsonElement2 = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsonObject jsonObject = it.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
            collection.add(this.getId(jsonObject));
        }
        List list = (List)destination$iv$iv;
        YarnPnpDependencyTreeReader yarnPnpDependencyTreeReader2 = yarnPnpDependencyTreeReader;
        return yarnPnpDependencyTreeReader2.new RawWorkspaces(list);
    }

    private static final YarnPnpDependency convertRawToModel$lambda$0(YarnPnpInfo $info, Set $workspaceLocations, RawDependency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toModel($info, $workspaceLocations);
    }

    private static final YarnPnpDependency convertRawToModel$lambda$1(Int2ObjectOpenHashMap $result, int it) {
        Object object = $result.get(it);
        Intrinsics.checkNotNull((Object)object);
        return (YarnPnpDependency)object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\n0\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeReader$Companion;", "", "<init>", "()V", "REQUIREABLE_LOCATION", "", "RESOLVED_VIRTUAL_REQUIREABLE_LOCATION", "LOCATION", "map2mapById", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "T", "rawDeps", "", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeReader$RawDependency;", "valueProvider", "Lkotlin/Function1;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> Int2ObjectOpenHashMap<T> map2mapById(Collection<RawDependency> rawDeps, Function1<? super RawDependency, ? extends T> valueProvider) {
            Int2ObjectOpenHashMap int2ObjectOpenHashMap;
            Int2ObjectOpenHashMap it = int2ObjectOpenHashMap = new Int2ObjectOpenHashMap(rawDeps.size());
            boolean bl = false;
            for (RawDependency rawDep : rawDeps) {
                ((Map)it).put(rawDep.getId(), valueProvider.invoke((Object)rawDep));
            }
            return int2ObjectOpenHashMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeReader$RawDependency;", "", "id", "", "name", "", "requireableLocation", "resolvedVirtualRequireableLocation", "dependencies", "Lit/unimi/dsi/fastutil/ints/IntList;", "<init>", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lit/unimi/dsi/fastutil/ints/IntList;)V", "getId", "()I", "getDependencies", "()Lit/unimi/dsi/fastutil/ints/IntList;", "location", "getLocation", "()Ljava/lang/String;", "toModel", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependency;", "info", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpInfo;", "workspaceLocations", "", "intellij.javascript.impl"})
    private static final class RawDependency {
        private final int id;
        @NotNull
        private final String name;
        @NotNull
        private final String requireableLocation;
        @Nullable
        private final String resolvedVirtualRequireableLocation;
        @NotNull
        private final IntList dependencies;

        public RawDependency(int id, @NotNull String name, @NotNull String requireableLocation, @Nullable String resolvedVirtualRequireableLocation, @NotNull IntList dependencies) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)requireableLocation, (String)YarnPnpDependencyTreeReader.REQUIREABLE_LOCATION);
            Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
            this.id = id;
            this.name = name;
            this.requireableLocation = requireableLocation;
            this.resolvedVirtualRequireableLocation = resolvedVirtualRequireableLocation;
            this.dependencies = dependencies;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final IntList getDependencies() {
            return this.dependencies;
        }

        @NotNull
        public final String getLocation() {
            String string = this.resolvedVirtualRequireableLocation;
            if (string == null) {
                string = this.requireableLocation;
            }
            return string;
        }

        @NotNull
        public final YarnPnpDependency toModel(@NotNull YarnPnpInfo info, @NotNull Set<String> workspaceLocations) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter(workspaceLocations, (String)"workspaceLocations");
            return new YarnPnpDependency(this.name, this.requireableLocation, this.resolvedVirtualRequireableLocation, info, workspaceLocations.contains(this.getLocation()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeReader$RawWorkspaces;", "", "workspaceDependencyIds", "", "", "<init>", "(Lcom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeReader;Ljava/util/List;)V", "getWorkspaceDependencyIds", "()Ljava/util/List;", "toModel", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspace;", "id2DepMap", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependency;", "buildWorkspaceLocations", "", "", "rawDeps", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeReader$RawDependency;", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nYarnPnpDependencyTreeReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YarnPnpDependencyTreeReader.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeReader$RawWorkspaces\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1563#2:129\n1634#2,3:130\n1634#2,3:133\n*S KotlinDebug\n*F\n+ 1 YarnPnpDependencyTreeReader.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeReader$RawWorkspaces\n*L\n89#1:129\n89#1:130,3\n97#1:133,3\n*E\n"})
    private final class RawWorkspaces {
        @NotNull
        private final List<Integer> workspaceDependencyIds;

        public RawWorkspaces(List<Integer> workspaceDependencyIds) {
            Intrinsics.checkNotNullParameter(workspaceDependencyIds, (String)"workspaceDependencyIds");
            this.workspaceDependencyIds = workspaceDependencyIds;
        }

        @NotNull
        public final List<Integer> getWorkspaceDependencyIds() {
            return this.workspaceDependencyIds;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<YarnPnpWorkspace> toModel(@NotNull Int2ObjectMap<YarnPnpDependency> id2DepMap) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(id2DepMap, (String)"id2DepMap");
            Iterable iterable = this.workspaceDependencyIds;
            YarnPnpDependencyTreeReader yarnPnpDependencyTreeReader = YarnPnpDependencyTreeReader.this;
            boolean $i$f$map = false;
            void var5_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = id2DepMap.get((int)it);
                Intrinsics.checkNotNull((Object)object);
                YarnPnpDependency workspaceDependency = (YarnPnpDependency)object;
                collection.add(new YarnPnpWorkspace(yarnPnpDependencyTreeReader.pnpFile, workspaceDependency, (String)yarnPnpDependencyTreeReader.libraryNameProvider.invoke((Object)workspaceDependency.getLocation())));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> buildWorkspaceLocations(@NotNull List<RawDependency> rawDeps) {
            void $this$mapTo$iv;
            Intrinsics.checkNotNullParameter(rawDeps, (String)"rawDeps");
            Int2ObjectOpenHashMap rawDepByIdMap = Companion.map2mapById(rawDeps, RawWorkspaces::buildWorkspaceLocations$lambda$1);
            Iterable iterable = this.workspaceDependencyIds;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                int n = ((Number)item$iv).intValue();
                Collection collection = destination$iv;
                boolean bl = false;
                Object object = rawDepByIdMap.get((int)it);
                Intrinsics.checkNotNull((Object)object);
                collection.add(((RawDependency)object).getLocation());
            }
            return (Set)destination$iv;
        }

        private static final RawDependency buildWorkspaceLocations$lambda$1(RawDependency it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it;
        }
    }
}

