/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public final class JSNonStrictModeUsedInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSNonStrictModeUsedInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSNonStrictModeUsedInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSFile(@NotNull JSFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file) == null) {
                    this.checkHasUseStrict(file, "File");
                }
            }

            @Override
            public void visitJSEmbeddedContent(@NotNull JSEmbeddedContent embeddedContent) {
                if (embeddedContent == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.checkHasUseStrict(embeddedContent, "Script");
            }

            private void checkHasUseStrict(JSExecutionScope executionScope, @NotNull String element2) {
                DialectOptionHolder dialect;
                if (element2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((dialect = DialectDetector.dialectOfElement(executionScope)) != null && dialect.isJavaScript() && !dialect.isECMA6 && !JSResolveUtil.hasUseStrictPragma(executionScope)) {
                    LocalQuickFix fix = JSFixFactory.getInstance().insertUseStrict(executionScope);
                    holder.registerProblem((PsiElement)executionScope, JavaScriptBundle.message("js.strict.mode.inspection.error", element2), new LocalQuickFix[]{fix});
                }
            }

            @Override
            public void visitJSExpressionStatement(@NotNull JSExpressionStatement node) {
                JSExecutionScope executionScope;
                if (node == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (JSPsiImplUtils.isUseStrictStatement((PsiElement)node) && (executionScope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)node, JSExecutionScope.class)) != null && !(executionScope instanceof PsiFile) && JSResolveUtil.isEcmaScript5(executionScope.getParent())) {
                    LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix("js.strict.mode.remove.pragma", (PsiElement)node);
                    holder.registerProblem((PsiElement)node, JavaScriptBundle.message("js.strict.mode.inspection.redundant.pragma", new Object[0]), new LocalQuickFix[]{fix});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "embeddedContent";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSNonStrictModeUsedInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSEmbeddedContent";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkHasUseStrict";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSExpressionStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSNonStrictModeUsedInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

