/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerRegistryConfigurable;
import com.intellij.docker.registry.DockerRegistryConfiguration;
import com.intellij.docker.registry.DockerRegistryManager;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.util.ListenerUiUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\tR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/intellij/docker/registry/RegistrySelectionEditor;", "", "registries", "", "Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "defaultRegistry", "<init>", "(Ljava/util/List;Lcom/intellij/docker/registry/DockerRegistryConfiguration;)V", "myServerSelectionListener", "Ljava/lang/Runnable;", "myComboBoxModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "Lcom/intellij/docker/registry/RegistrySelectionEditor$AccountItem;", "myIsAccountEditable", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "selectedAccount", "getSelectedAccount", "()Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "addRegistrySelectionEditor", "", "Lcom/intellij/ui/dsl/builder/Panel;", "project", "Lcom/intellij/openapi/project/Project;", "setAccountSelectionListener", "listener", "AccountItem", "intellij.clouds.docker"})
final class RegistrySelectionEditor {
    @Nullable
    private Runnable myServerSelectionListener;
    @NotNull
    private final CollectionComboBoxModel<AccountItem> myComboBoxModel;
    @NotNull
    private final AtomicBooleanProperty myIsAccountEditable;

    public RegistrySelectionEditor(@NotNull List<? extends DockerRegistryConfiguration> registries, @Nullable DockerRegistryConfiguration defaultRegistry) {
        Intrinsics.checkNotNullParameter(registries, (String)"registries");
        this.myComboBoxModel = new CollectionComboBoxModel();
        this.myIsAccountEditable = new AtomicBooleanProperty(false);
        AccountItem defaultItem = null;
        for (DockerRegistryConfiguration dockerRegistryConfiguration : registries) {
            AccountItem item = new AccountItem(dockerRegistryConfiguration);
            this.myComboBoxModel.add((Object)item);
            if (dockerRegistryConfiguration != defaultRegistry) continue;
            defaultItem = item;
        }
        if (defaultItem == null) {
            defaultItem = new AccountItem(null);
            this.myComboBoxModel.add((Object)defaultItem);
            this.myIsAccountEditable.set(false);
        } else {
            this.myIsAccountEditable.set(true);
        }
        ListenerUiUtil.whenListChanged$default((ListModel)((ListModel)this.myComboBoxModel), null, arg_0 -> RegistrySelectionEditor._init_$lambda$0(this, arg_0), (int)1, null);
        this.myComboBoxModel.setSelectedItem((Object)defaultItem);
    }

    @Nullable
    public final DockerRegistryConfiguration getSelectedAccount() {
        AccountItem accountItem = (AccountItem)this.myComboBoxModel.getSelected();
        return accountItem != null ? accountItem.getAccount() : null;
    }

    public final void addRegistrySelectionEditor(@NotNull Panel $this$addRegistrySelectionEditor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$addRegistrySelectionEditor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = DockerBundle.message((String)"configurable.PushImageConfigurable.registry.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$addRegistrySelectionEditor.row(string, arg_0 -> RegistrySelectionEditor.addRegistrySelectionEditor$lambda$5(this, project, arg_0));
    }

    public final void setAccountSelectionListener(@NotNull Runnable listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myServerSelectionListener = listener2;
    }

    private static final Unit _init_$lambda$0(RegistrySelectionEditor this$0, ListDataEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.myIsAccountEditable.set(this$0.getSelectedAccount() != null);
        return Unit.INSTANCE;
    }

    private static final void addRegistrySelectionEditor$lambda$5$lambda$2$lambda$1(RegistrySelectionEditor this$0, ActionEvent it) {
        block0: {
            Runnable runnable = this$0.myServerSelectionListener;
            if (runnable == null) break block0;
            runnable.run();
        }
    }

    private static final Unit addRegistrySelectionEditor$lambda$5$lambda$2(RegistrySelectionEditor this$0, ComboBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addActionListener(arg_0 -> RegistrySelectionEditor.addRegistrySelectionEditor$lambda$5$lambda$2$lambda$1(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit addRegistrySelectionEditor$lambda$5$lambda$3(Project $project, RegistrySelectionEditor this$0, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ShowSettingsUtil showSettingsUtil = ShowSettingsUtil.getInstance();
            DockerRegistryConfiguration dockerRegistryConfiguration = this$0.getSelectedAccount();
            Intrinsics.checkNotNull((Object)((Object)dockerRegistryConfiguration));
            showSettingsUtil.editConfigurable($project, (Configurable)new DockerRegistryConfigurable(dockerRegistryConfiguration, null, false));
            this$0.myComboBoxModel.update();
            Runnable runnable = this$0.myServerSelectionListener;
            if (runnable == null) break block0;
            runnable.run();
        }
        return Unit.INSTANCE;
    }

    private static final Unit addRegistrySelectionEditor$lambda$5$lambda$4(Project $project, RegistrySelectionEditor this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DockerRegistryConfiguration newAccount = new DockerRegistryConfiguration().withName(DockerRegistryManager.generateUniqueRegistryName());
        Intrinsics.checkNotNull((Object)((Object)newAccount));
        DockerRegistryConfigurable configurable = new DockerRegistryConfigurable(newAccount, null, true);
        if (new SingleConfigurableEditor($project, (Configurable)configurable, ShowSettingsUtilImpl.Companion.createDimensionKey((Configurable)configurable), false).showAndGet()) {
            newAccount.setName(configurable.getDisplayName());
            DockerRegistryManager.getInstance().addRegistry(newAccount);
            AccountItem newAccountItem = new AccountItem(newAccount);
            this$0.myComboBoxModel.add((Object)newAccountItem);
            this$0.myComboBoxModel.setSelectedItem((Object)newAccountItem);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addRegistrySelectionEditor$lambda$5(RegistrySelectionEditor this$0, Project $project, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)this$0.myComboBoxModel), null, (int)2, null).resizableColumn().align(Align.FILL).applyToComponent(arg_0 -> RegistrySelectionEditor.addRegistrySelectionEditor$lambda$5$lambda$2(this$0, arg_0)).gap(RightGap.SMALL);
        String string = DockerBundle.message((String)"DockerAbstractDashboardTab.action.edit.hint", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.button(string, arg_0 -> RegistrySelectionEditor.addRegistrySelectionEditor$lambda$5$lambda$3($project, this$0, arg_0)).gap(RightGap.SMALL).visibleIf((ObservableProperty)this$0.myIsAccountEditable);
        String string2 = DockerBundle.message((String)"DockerAbstractDashboardTab.action.add", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$row.button(string2, arg_0 -> RegistrySelectionEditor.addRegistrySelectionEditor$lambda$5$lambda$4($project, this$0, arg_0)).gap(RightGap.SMALL);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/registry/RegistrySelectionEditor$AccountItem;", "", "account", "Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "<init>", "(Lcom/intellij/docker/registry/DockerRegistryConfiguration;)V", "getAccount", "()Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "toString", "", "intellij.clouds.docker"})
    private static final class AccountItem {
        @Nullable
        private final DockerRegistryConfiguration account;

        public AccountItem(@Nullable DockerRegistryConfiguration account) {
            this.account = account;
        }

        @Nullable
        public final DockerRegistryConfiguration getAccount() {
            return this.account;
        }

        @NotNull
        public String toString() {
            Object object = this.account;
            if (object == null || (object = object.getName()) == null) {
                String string = DockerBundle.message((String)"RegistrySelectionEditor.default.registry", (Object[])new Object[0]);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            }
            return object;
        }
    }
}

