/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.powerfuldataviewer.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.python.scientific.powerfuldataviewer.DataViewerNotificationGroup;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.array.AbstractDataViewTable;
import com.jetbrains.python.debugger.containerview.PyDataViewerCommunityPanel;
import com.jetbrains.python.debugger.pydev.dataviewer.DataViewerCommandBuilder;
import com.jetbrains.python.debugger.pydev.dataviewer.DataViewerCommandResult;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/scientific/powerfuldataviewer/actions/ExportTableAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "tryExport", "table", "Lcom/jetbrains/python/debugger/array/AbstractDataViewTable;", "filepath", "Ljava/io/File;", "Companion", "intellij.python.scientific"})
public final class ExportTableAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String[] EXPORT_EXTENSIONS;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        AbstractDataViewTable table = (AbstractDataViewTable)e.getData(PyDataViewerCommunityPanel.Companion.getPY_DATA_VIEWER_COMMUNITY_PANEL_KEY());
        AbstractDataViewTable abstractDataViewTable = table;
        e.getPresentation().setEnabled((abstractDataViewTable != null ? abstractDataViewTable.getDebugValue() : null) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        FileSaverDescriptor fileSaverDescriptor;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        AbstractDataViewTable abstractDataViewTable = (AbstractDataViewTable)e.getData(PyDataViewerCommunityPanel.Companion.getPY_DATA_VIEWER_COMMUNITY_PANEL_KEY());
        if (abstractDataViewTable == null) {
            return;
        }
        AbstractDataViewTable table = abstractDataViewTable;
        FileSaverDescriptor $this$actionPerformed_u24lambda_u240 = fileSaverDescriptor = new FileSaverDescriptor(PyBundle.message((String)"debugger.dataViewer.action.export.name", (Object[])new Object[0]), PyBundle.message((String)"debugger.dataViewer.action.export.dialog.description", (Object[])new Object[0]));
        boolean bl = false;
        String[] stringArray = EXPORT_EXTENSIONS;
        $this$actionPerformed_u24lambda_u240.withExtensionFilter(PyBundle.message((String)"debugger.dataViewer.action.export.dialog.label", (Object[])new Object[0]), Arrays.copyOf(stringArray, stringArray.length));
        FileSaverDescriptor descriptor = fileSaverDescriptor;
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, (Component)table);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
        FileSaverDialog saver = fileSaverDialog;
        VirtualFileWrapper target = saver.save(table.getVariableName());
        if (target != null) {
            File file = target.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            this.tryExport(table, file);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final void tryExport(AbstractDataViewTable table, File filepath) {
        PyDebugValue pyDebugValue = table.getDebugValue();
        if (pyDebugValue == null) {
            return;
        }
        PyDebugValue debugValue = pyDebugValue;
        DataViewerCommandBuilder dataViewerCommandBuilder = DataViewerCommandBuilder.initExportCommand((PyDebugValue)debugValue, (File)filepath);
        Intrinsics.checkNotNullExpressionValue((Object)dataViewerCommandBuilder, (String)"initExportCommand(...)");
        DataViewerCommandBuilder builder = dataViewerCommandBuilder;
        ApplicationManager.getApplication().executeOnPooledThread(() -> ExportTableAction.tryExport$lambda$3(debugValue, builder, this, filepath));
    }

    private static final void tryExport$lambda$3$lambda$1(File $filepath) {
        Object[] objectArray = new Object[]{$filepath};
        DataViewerNotificationGroup.getInstance().showNotification(PyBundle.message((String)"debugger.dataViewer.export.error.title", (Object[])new Object[0]), PyBundle.message((String)"debugger.dataViewer.export.error.invalid.filepath", (Object[])new Object[0]), PyBundle.message((String)"debugger.dataViewer.export.error.invalid.filepath.content", (Object[])objectArray));
    }

    private static final void tryExport$lambda$3$lambda$2(File $filepath, DataViewerCommandResult $result) {
        Object[] objectArray = new Object[]{$filepath, $result.getLog()};
        DataViewerNotificationGroup.getInstance().showNotification(PyBundle.message((String)"debugger.dataViewer.export.error.title", (Object[])new Object[0]), PyBundle.message((String)"debugger.dataViewer.export.error.unhandled", (Object[])new Object[0]), PyBundle.message((String)"debugger.dataViewer.export.error.unhandled.content", (Object[])objectArray));
    }

    private static final void tryExport$lambda$3(PyDebugValue $debugValue, DataViewerCommandBuilder $builder, ExportTableAction this$0, File $filepath) {
        try {
            DataViewerCommandResult result = $debugValue.getFrameAccessor().executeDataViewerCommand($builder);
            if (result.isSuccess()) {
                return;
            }
            Runnable invokeLaterTask = result.getErrorType() == DataViewerCommandResult.ResultType.FILE_NOT_FOUND_ERROR ? () -> ExportTableAction.tryExport$lambda$3$lambda$1($filepath) : () -> ExportTableAction.tryExport$lambda$3$lambda$2($filepath, result);
            ApplicationManager.getApplication().invokeLater(invokeLaterTask);
        }
        catch (PyDebuggerException e) {
            Logger.getInstance(((Object)((Object)this$0)).getClass()).error((Throwable)e);
        }
    }

    static {
        String[] stringArray = new String[]{"csv", "tsv"};
        EXPORT_EXTENSIONS = stringArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/python/scientific/powerfuldataviewer/actions/ExportTableAction$Companion;", "", "<init>", "()V", "EXPORT_EXTENSIONS", "", "", "[Ljava/lang/String;", "intellij.python.scientific"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

