/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh.panels.recentConnections;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.InlineBannerBase;
import com.intellij.ui.JBColor;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SeparatorOrientation;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.api.GatewayConnector;
import com.jetbrains.gateway.impl.GatewayUIService;
import com.jetbrains.gateway.remote.LocalRecentConnectionUiData;
import com.jetbrains.gateway.remote.LocalRecentConnectionsAdapter;
import com.jetbrains.gateway.ssh.HostDeployContext;
import com.jetbrains.gateway.ssh.LocalRecentConnectionsManager;
import com.jetbrains.gateway.ssh.panels.recentConnections.CommonActionsKt;
import com.jetbrains.gateway.ssh.panels.recentConnections.HostPanel;
import com.jetbrains.gateway.ssh.panels.recentConnections.RecentProjectsPanel;
import com.jetbrains.gateway.statistics.GatewayUsagesCollector;
import com.jetbrains.gateway.welcomeScreen.WslPromoPanel;
import com.jetbrains.gateway.welcomeScreen.toolbox.ToolboxPromoPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rd.util.reactive.ViewableList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005:\u0001#BU\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0005H\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/gateway/ssh/panels/recentConnections/RecentProjectsPanel;", "TConfig", "", "THostDeployContext", "Lcom/jetbrains/gateway/ssh/HostDeployContext;", "Ljavax/swing/JPanel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "adapter", "Lcom/jetbrains/gateway/remote/LocalRecentConnectionsAdapter;", "uiData", "Lcom/jetbrains/gateway/remote/LocalRecentConnectionUiData;", "canDisplayToolboxPromo", "", "setContentCallback", "Lkotlin/Function1;", "Ljava/awt/Component;", "", "switchToProjectsTab", "Lkotlin/Function0;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/gateway/remote/LocalRecentConnectionsAdapter;Lcom/jetbrains/gateway/remote/LocalRecentConnectionUiData;ZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "recents", "Lcom/jetbrains/rd/util/reactive/ViewableList;", "Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$RecentConnection;", "searchChanged", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "addPromo", "panel", "Lcom/intellij/ui/InlineBannerBase;", "createSearchField", "createNewProjectAction", "Ljavax/swing/AbstractAction;", "createNewHostAction", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nRecentProjectsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentProjectsPanel.kt\ncom/jetbrains/gateway/ssh/panels/recentConnections/RecentProjectsPanel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,178:1\n14#2:179\n*S KotlinDebug\n*F\n+ 1 RecentProjectsPanel.kt\ncom/jetbrains/gateway/ssh/panels/recentConnections/RecentProjectsPanel\n*L\n51#1:179\n*E\n"})
public final class RecentProjectsPanel<TConfig, THostDeployContext extends HostDeployContext<TConfig>>
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final LocalRecentConnectionsAdapter<TConfig, THostDeployContext> adapter;
    @NotNull
    private final Function1<Component, Unit> setContentCallback;
    @NotNull
    private final Function0<Unit> switchToProjectsTab;
    @NotNull
    private final ViewableList<LocalRecentConnectionsManager.RecentConnection<TConfig>> recents;
    @NotNull
    private final Signal<String> searchChanged;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Color ENABLED_SEPARATOR_FOREGROUND;

    /*
     * WARNING - void declaration
     */
    public RecentProjectsPanel(@NotNull Lifetime lifetime, @NotNull LocalRecentConnectionsAdapter<TConfig, THostDeployContext> adapter, @NotNull LocalRecentConnectionUiData uiData, boolean canDisplayToolboxPromo, @NotNull Function1<? super Component, Unit> setContentCallback, @NotNull Function0<Unit> switchToProjectsTab) {
        void $this$lambda_u243_u24lambda_u242;
        BorderLayoutPanel borderLayoutPanel;
        BorderLayoutPanel borderLayoutPanel2;
        Action[] actionArray;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)uiData, (String)"uiData");
        Intrinsics.checkNotNullParameter(setContentCallback, (String)"setContentCallback");
        Intrinsics.checkNotNullParameter(switchToProjectsTab, (String)"switchToProjectsTab");
        super((LayoutManager)new VerticalFlowLayout(0, 0));
        this.lifetime = lifetime;
        this.adapter = adapter;
        this.setContentCallback = setContentCallback;
        this.switchToProjectsTab = switchToProjectsTab;
        this.recents = this.adapter.getRecentConnectionsManager().getRecents();
        this.searchChanged = new Signal();
        this.setOpaque(false);
        if (canDisplayToolboxPromo) {
            if (Registry.Companion.is("gateway.ssh.welcome.screen.toolbox.promo.enabled")) {
                this.addPromo(new ToolboxPromoPanel(this.lifetime.getCoroutineScope()));
            }
        } else {
            this.addPromo(new WslPromoPanel((Function0<Unit>)((Function0)() -> RecentProjectsPanel._init_$lambda$0(this))));
        }
        Action[] $this$_init__u24lambda_u241 = actionArray = new JLabel(uiData.getPanelHeader());
        boolean bl = false;
        $this$_init__u24lambda_u241.setFont((Font)JBFont.h3().asBold());
        Action[] recentsLabel = actionArray;
        $this$_init__u24lambda_u241 = new Action[]{this.createNewHostAction()};
        JBOptionButton newProjectOrHost = new JBOptionButton((Action)this.createNewProjectAction(), $this$_init__u24lambda_u241);
        BorderLayoutPanel $this$_init__u24lambda_u243 = borderLayoutPanel2 = new BorderLayoutPanel();
        boolean bl2 = false;
        BorderLayoutPanel borderLayoutPanel3 = borderLayoutPanel = new BorderLayoutPanel();
        BorderLayoutPanel borderLayoutPanel4 = $this$_init__u24lambda_u243;
        boolean bl3 = false;
        $this$lambda_u243_u24lambda_u242.addToLeft((Component)recentsLabel);
        $this$lambda_u243_u24lambda_u242.addToRight((Component)newProjectOrHost);
        $this$lambda_u243_u24lambda_u242.setBorder((Border)JBUI.Borders.empty((int)20, (int)24, (int)0, (int)24));
        $this$lambda_u243_u24lambda_u242.setOpaque(false);
        borderLayoutPanel4.addToTop((Component)borderLayoutPanel);
        $this$_init__u24lambda_u243.addToBottom((Component)this.createSearchField());
        $this$_init__u24lambda_u243.setOpaque(false);
        BorderLayoutPanel headerPanel2 = borderLayoutPanel2;
        this.add((Component)headerPanel2);
        this.recents.view(this.lifetime, (arg_0, arg_1, arg_2) -> RecentProjectsPanel._init_$lambda$7(this, arg_0, arg_1, arg_2));
        this.setBackground(WelcomeScreenUIManager.getMainAssociatedComponentBackground());
    }

    private final void addPromo(InlineBannerBase panel2) {
        BorderLayoutPanel borderLayoutPanel;
        BorderLayoutPanel $this$addPromo_u24lambda_u248 = borderLayoutPanel = new BorderLayoutPanel();
        boolean bl = false;
        $this$addPromo_u24lambda_u248.addToCenter((Component)panel2);
        $this$addPromo_u24lambda_u248.setBorder((Border)JBUI.Borders.empty((int)20, (int)24, (int)0, (int)24));
        $this$addPromo_u24lambda_u248.setOpaque(false);
        BorderLayoutPanel promoWithBorders = borderLayoutPanel;
        this.add((Component)promoWithBorders);
    }

    private final JPanel createSearchField() {
        JPanel jPanel;
        SearchTextField searchTextField;
        SearchTextField $this$createSearchField_u24lambda_u249 = searchTextField = new SearchTextField(){
            private final Alarm searchAlarm;
            {
                JBTextField jBTextField;
                this.searchAlarm = new Alarm();
                this.setOpaque(false);
                JBTextField $this$_init__u24lambda_u241 = jBTextField = this.getTextEditor();
                boolean bl = false;
                $this$_init__u24lambda_u241.getEmptyText().setText(GatewayBundle.INSTANCE.message("ssh.search", new Object[0]));
                $this$_init__u24lambda_u241.setBorder((Border)JBUI.Borders.empty((int)8, (int)0));
                $this$_init__u24lambda_u241.setOpaque(false);
                $this$_init__u24lambda_u241.setMaximumSize(new Dimension($this$_init__u24lambda_u241.getWidth(), JBUIScale.scale((int)54)));
                $this$_init__u24lambda_u241.putClientProperty((Object)"StatusVisibleFunction", createSearchField.searchField.1::lambda$1$lambda$0);
            }

            public final Alarm getSearchAlarm() {
                return this.searchAlarm;
            }

            private static final boolean lambda$1$lambda$0(JBTextField it) {
                String string = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return ((CharSequence)string).length() == 0;
            }
        };
        boolean bl = false;
        $this$createSearchField_u24lambda_u249.addDocumentListener((DocumentListener)new DocumentAdapter($this$createSearchField_u24lambda_u249, this){
            final /* synthetic */ createSearchField.searchField.1 $this_apply;
            final /* synthetic */ RecentProjectsPanel<TConfig, THostDeployContext> this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$this_apply.getSearchAlarm().cancelAllRequests();
                this.$this_apply.getSearchAlarm().addRequest(() -> createSearchField.searchField.2.1.textChanged$lambda$0(this.this$0, this.$this_apply), 300);
            }

            private static final void textChanged$lambda$0(RecentProjectsPanel this$0, createSearchField.searchField.1 $this_apply) {
                Signal signal = RecentProjectsPanel.access$getSearchChanged$p(this$0);
                String string = $this_apply.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                signal.fire((Object)string);
            }
        });
        SearchTextField searchField2 = searchTextField;
        JPanel $this$createSearchField_u24lambda_u2410 = jPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        boolean bl2 = false;
        $this$createSearchField_u24lambda_u2410.setOpaque(false);
        $this$createSearchField_u24lambda_u2410.setBorder((Border)JBUI.Borders.empty((int)8, (int)0));
        JPanel searchPanel = jPanel;
        searchPanel.add((Component)new SeparatorComponent(ENABLED_SEPARATOR_FOREGROUND, SeparatorOrientation.HORIZONTAL));
        searchPanel.add((Component)searchField2);
        searchPanel.add((Component)new SeparatorComponent(ENABLED_SEPARATOR_FOREGROUND, SeparatorOrientation.HORIZONTAL));
        return searchPanel;
    }

    private final AbstractAction createNewProjectAction() {
        String string = GatewayBundle.INSTANCE.message("ssh.new.project", new Object[0]);
        return new AbstractAction(this, string){
            final /* synthetic */ RecentProjectsPanel<TConfig, THostDeployContext> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                GatewayUsagesCollector.INSTANCE.onNewProjectClick();
                GatewayConnector gatewayConnector = RecentProjectsPanel.access$getAdapter$p(this.this$0).getGatewayConnector();
                if (gatewayConnector == null) {
                    return;
                }
                GatewayConnector connector = gatewayConnector;
                JComponent component2 = connector.createView(RecentProjectsPanel.access$getLifetime$p(this.this$0)).getComponent();
                RecentProjectsPanel.access$getSetContentCallback$p(this.this$0).invoke((Object)component2);
                GatewayUIService.Companion.getServiceInstance().setLastConnectorId(RecentProjectsPanel.access$getAdapter$p(this.this$0).getRecentConnectionsTabId(), true);
            }
        };
    }

    private final AbstractAction createNewHostAction() {
        String string = GatewayBundle.INSTANCE.message("ssh.new.host", new Object[0]);
        return new AbstractAction(this, string){
            final /* synthetic */ RecentProjectsPanel<TConfig, THostDeployContext> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(ActionEvent e) {
                GatewayUsagesCollector.INSTANCE.onConnectToHostClick();
                CommonActionsKt.navigateToHostSelection(RecentProjectsPanel.access$getLifetime$p(this.this$0), RecentProjectsPanel.access$getAdapter$p(this.this$0), (Function1<? super Component, Unit>)RecentProjectsPanel.access$getSetContentCallback$p(this.this$0));
            }
        };
    }

    private static final Unit _init_$lambda$0(RecentProjectsPanel this$0) {
        this$0.switchToProjectsTab.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$7$lambda$5(SeparatorComponent $separator, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $separator.setVisible(StringsKt.isBlank((CharSequence)it));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$7$lambda$6(HostPanel $hostPanel, RecentProjectsPanel this$0) {
        ThreadingAssertions.assertEventDispatchThread();
        $hostPanel.setVisible(false);
        this$0.remove($hostPanel);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(RecentProjectsPanel this$0, Lifetime hostLifetime, int hostIdx, LocalRecentConnectionsManager.RecentConnection connection) {
        Intrinsics.checkNotNullParameter((Object)hostLifetime, (String)"hostLifetime");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        ThreadingAssertions.assertEventDispatchThread();
        HostPanel hostPanel = new HostPanel(hostLifetime, connection, this$0.adapter, this$0.searchChanged, this$0.setContentCallback);
        this$0.add(hostPanel);
        if (hostIdx != this$0.recents.size() - 1) {
            SeparatorComponent separatorComponent;
            SeparatorComponent $this$lambda_u247_u24lambda_u244 = separatorComponent = new SeparatorComponent(ENABLED_SEPARATOR_FOREGROUND, SeparatorOrientation.HORIZONTAL);
            boolean bl = false;
            $this$lambda_u247_u24lambda_u244.setBorder((Border)JBUI.Borders.empty((int)1, (int)0));
            SeparatorComponent separator = separatorComponent;
            this$0.add((Component)separator);
            this$0.searchChanged.advise(this$0.lifetime, arg_0 -> RecentProjectsPanel.lambda$7$lambda$5(separator, arg_0));
        }
        hostLifetime.onTermination(() -> RecentProjectsPanel.lambda$7$lambda$6(hostPanel, this$0));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ LocalRecentConnectionsAdapter access$getAdapter$p(RecentProjectsPanel $this) {
        return $this.adapter;
    }

    public static final /* synthetic */ Lifetime access$getLifetime$p(RecentProjectsPanel $this) {
        return $this.lifetime;
    }

    public static final /* synthetic */ Function1 access$getSetContentCallback$p(RecentProjectsPanel $this) {
        return $this.setContentCallback;
    }

    public static final /* synthetic */ Signal access$getSearchChanged$p(RecentProjectsPanel $this) {
        return $this.searchChanged;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RecentProjectsPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RecentProjectsPanel.logger = logger;
        JBColor jBColor = JBColor.namedColor((String)"Group.separatorColor", (Color)((Color)new JBColor((Color)Gray.xCD, (Color)Gray.x51)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        ENABLED_SEPARATOR_FOREGROUND = (Color)jBColor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/gateway/ssh/panels/recentConnections/RecentProjectsPanel$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "ENABLED_SEPARATOR_FOREGROUND", "Ljava/awt/Color;", "getENABLED_SEPARATOR_FOREGROUND", "()Ljava/awt/Color;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final Color getENABLED_SEPARATOR_FOREGROUND() {
            return ENABLED_SEPARATOR_FOREGROUND;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

