/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.AsyncDocumentFormattingService;
import com.intellij.formatting.service.AsyncFormattingRequest;
import com.intellij.formatting.service.FormattingService;
import com.intellij.lang.javascript.imports.JSModuleImportOptimizerBase;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierBundle;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierFormattingServiceKt;
import com.intellij.prettierjs.PrettierLanguageService;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.prettierjs.ReformatWithPrettierAction;
import com.intellij.prettierjs.formatting.PrettierFormattingApplier;
import com.intellij.prettierjs.formatting.PrettierFormattingContext;
import com.intellij.prettierjs.formatting.PrettierFormattingContextKt;
import com.intellij.prettierjs.formatting.PrettierRangeKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.CoreCodeStyleUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0014J\b\u0010\u0007\u001a\u00020\u0005H\u0014J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/prettierjs/PrettierFormattingService;", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService;", "<init>", "()V", "getName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getNotificationGroupId", "getFeatures", "", "Lcom/intellij/formatting/service/FormattingService$Feature;", "canFormat", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "createFormattingTask", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService$FormattingTask;", "request", "Lcom/intellij/formatting/service/AsyncFormattingRequest;", "isApplicable", "PrettierFormattingTask", "intellij.prettierJS"})
@SourceDebugExtension(value={"SMAP\nPrettierFormattingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierFormattingService.kt\ncom/intellij/prettierjs/PrettierFormattingService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1#2:159\n*E\n"})
public final class PrettierFormattingService
extends AsyncDocumentFormattingService {
    @NotNull
    protected String getName() {
        return "Prettier";
    }

    @NotNull
    protected String getNotificationGroupId() {
        return "Prettier";
    }

    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        return SetsKt.setOf((Object)FormattingService.Feature.FORMAT_FRAGMENTS);
    }

    public boolean canFormat(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return Registry.Companion.is("prettier.use.async.formatting.service") && this.isApplicable(psiFile) && PrettierUtil.checkNodeAndPackage(psiFile, null, PrettierUtil.NOOP_ERROR_HANDLER);
    }

    @Nullable
    protected AsyncDocumentFormattingService.FormattingTask createFormattingTask(@NotNull AsyncFormattingRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        FormattingContext formattingContext = request.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)formattingContext, (String)"getContext(...)");
        FormattingContext context = formattingContext;
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile psiFile = context.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile file = psiFile;
        VirtualFile virtualFile = context.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        CountDownLatch formatterLatch = new CountDownLatch(1);
        file.putUserData(JSModuleImportOptimizerBase.COUNTDOWN_LATCH_KEY, (Object)formatterLatch);
        return new PrettierFormattingTask(request, file, virtualFile2, project2, formatterLatch);
    }

    private final boolean isApplicable(PsiFile psiFile) {
        Template template;
        TextEditor fileEditor;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PrettierConfiguration prettierConfiguration = PrettierConfiguration.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)prettierConfiguration, (String)"getInstance(...)");
        PrettierConfiguration configuration = prettierConfiguration;
        if (!configuration.isRunOnReformat()) {
            return false;
        }
        FileEditor fileEditor2 = FileEditorManager.getInstance((Project)project2).getSelectedEditor(file);
        TextEditor textEditor = fileEditor = fileEditor2 instanceof TextEditor ? (TextEditor)fileEditor2 : null;
        if (textEditor != null) {
            TextEditor it = textEditor;
            boolean bl = false;
            v4 = TemplateManager.getInstance((Project)project2).getActiveTemplate(it.getEditor());
        } else {
            v4 = template = null;
        }
        if (template != null) {
            return false;
        }
        return PrettierUtil.isFormattingAllowedForFile(project2, file);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0016\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/prettierjs/PrettierFormattingService$PrettierFormattingTask;", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService$FormattingTask;", "request", "Lcom/intellij/formatting/service/AsyncFormattingRequest;", "file", "Lcom/intellij/psi/PsiFile;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "formatterLatch", "Ljava/util/concurrent/CountDownLatch;", "<init>", "(Lcom/intellij/prettierjs/PrettierFormattingService;Lcom/intellij/formatting/service/AsyncFormattingRequest;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Ljava/util/concurrent/CountDownLatch;)V", "cancelled", "", "isRunUnderProgress", "cancel", "run", "", "computeExtendedRanges", "", "Lcom/intellij/openapi/util/TextRange;", "processRangesWithPrettier", "ranges", "moveCursor", "psiFile", "formattingContext", "Lcom/intellij/prettierjs/formatting/PrettierFormattingContext;", "intellij.prettierJS"})
    @SourceDebugExtension(value={"SMAP\nPrettierFormattingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierFormattingService.kt\ncom/intellij/prettierjs/PrettierFormattingService$PrettierFormattingTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1803#2,2:159\n1805#2:162\n1068#2:163\n1#3:161\n*S KotlinDebug\n*F\n+ 1 PrettierFormattingService.kt\ncom/intellij/prettierjs/PrettierFormattingService$PrettierFormattingTask\n*L\n98#1:159,2\n98#1:162\n108#1:163\n*E\n"})
    private final class PrettierFormattingTask
    implements AsyncDocumentFormattingService.FormattingTask {
        @NotNull
        private final AsyncFormattingRequest request;
        @NotNull
        private final PsiFile file;
        @NotNull
        private final VirtualFile virtualFile;
        @NotNull
        private final Project project;
        @NotNull
        private final CountDownLatch formatterLatch;
        private boolean cancelled;

        public PrettierFormattingTask(@NotNull AsyncFormattingRequest request, @NotNull PsiFile file, @NotNull VirtualFile virtualFile, @NotNull Project project, CountDownLatch formatterLatch) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)formatterLatch, (String)"formatterLatch");
            this.request = request;
            this.file = file;
            this.virtualFile = virtualFile;
            this.project = project;
            this.formatterLatch = formatterLatch;
        }

        public boolean isRunUnderProgress() {
            return true;
        }

        public boolean cancel() {
            this.cancelled = true;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                List<TextRange> extendedRanges = this.computeExtendedRanges();
                this.processRangesWithPrettier(extendedRanges);
            }
            catch (Exception e) {
                PrettierFormattingServiceKt.access$getLOG$p().warn("Error during Prettier formatting", (Throwable)e);
            }
            finally {
                this.request.onTextReady(null);
                this.formatterLatch.countDown();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<TextRange> computeExtendedRanges() {
            List sortedRanges;
            List list;
            void $this$fold$iv;
            List extendedRanges = new ArrayList();
            List list2 = this.request.getFormattingRanges();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getFormattingRanges(...)");
            Iterable iterable = list2;
            FormatTextRanges initial$iv = new FormatTextRanges();
            boolean $i$f$fold = false;
            FormatTextRanges accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void range;
                FormatTextRanges formatTextRanges;
                TextRange textRange = (TextRange)element$iv;
                FormatTextRanges acc = accumulator$iv;
                boolean bl = false;
                FormatTextRanges $this$computeExtendedRanges_u24lambda_u241_u24lambda_u240 = formatTextRanges = acc;
                boolean bl2 = false;
                $this$computeExtendedRanges_u24lambda_u241_u24lambda_u240.add((TextRange)range, true);
                accumulator$iv = formatTextRanges;
            }
            FormatTextRanges formatRanges = accumulator$iv;
            ApplicationManager.getApplication().runReadAction(() -> PrettierFormattingTask.computeExtendedRanges$lambda$5(this, formatRanges, extendedRanges));
            Iterable $this$sortedByDescending$iv = extendedRanges;
            boolean $i$f$sortedByDescending = false;
            List it = list = (sortedRanges = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    TextRange it = (TextRange)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getStartOffset());
                    it = (TextRange)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
                }
            }));
            boolean bl = false;
            List list3 = !((Collection)it).isEmpty() ? list : null;
            if (list3 == null) {
                List list4 = this.request.getFormattingRanges();
                list3 = list4;
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getFormattingRanges(...)");
            }
            return list3;
        }

        private final void processRangesWithPrettier(List<? extends TextRange> ranges) {
            Pair pair = (Pair)ActionsKt.runReadAction(() -> PrettierFormattingTask.processRangesWithPrettier$lambda$8(this));
            Document document = (Document)pair.component1();
            Long initialModificationStamp = (Long)pair.component2();
            if (document == null || initialModificationStamp == null) {
                return;
            }
            String string = this.request.getDocumentText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDocumentText(...)");
            String text = string;
            int cursorOffset = -1;
            for (TextRange textRange : ranges) {
                PrettierLanguageService.FormatResult formatted;
                if (ReformatWithPrettierAction.processFileAsFormattingTask(this.file, text, textRange) == null) {
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                if (formatted.result == null) {
                    return;
                }
                cursorOffset = formatted.cursorOffset;
            }
            PrettierFormattingContext formattingContext = PrettierFormattingContextKt.createFormattingContext(document, text, cursorOffset);
            PrettierFormattingApplier prettierFormattingApplier = PrettierFormattingApplier.Companion.from(formattingContext);
            PsiFile[] psiFileArray = new PsiFile[]{this.request.getContext().getContainingFile()};
            WriteCommandAction.writeCommandAction((Project)this.project, (PsiFile[])psiFileArray).withName(PrettierBundle.message("reformat.with.prettier.command.name", new Object[0])).shouldRecordActionForActiveDocument(false).run(() -> PrettierFormattingTask.processRangesWithPrettier$lambda$9(document, initialModificationStamp, this, formattingContext, prettierFormattingApplier));
        }

        private final void moveCursor(PsiFile psiFile, PrettierFormattingContext formattingContext) {
            Editor editor = FileEditorManager.getInstance((Project)psiFile.getProject()).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            Editor editor2 = editor;
            if (!editor2.isDisposed() && Intrinsics.areEqual((Object)editor2.getVirtualFile(), (Object)psiFile.getVirtualFile()) && formattingContext.getCursorOffset() >= 0) {
                editor2.getCaretModel().moveToOffset(formattingContext.getCursorOffset());
            }
        }

        private static final Unit computeExtendedRanges$lambda$5$lambda$3(List $extendedRanges, PrettierFormattingTask this$0, TextRange range) {
            block0: {
                TextRange textRange = range;
                if (textRange == null) break block0;
                TextRange it = textRange;
                boolean bl = false;
                $extendedRanges.add(PrettierRangeKt.extendRange(this$0.file, it));
            }
            return Unit.INSTANCE;
        }

        private static final void computeExtendedRanges$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final void computeExtendedRanges$lambda$5(PrettierFormattingTask this$0, FormatTextRanges $formatRanges, List $extendedRanges) {
            List infos = CoreCodeStyleUtil.getRangeFormatInfoList((PsiFile)this$0.file, (FormattingRangesInfo)((FormattingRangesInfo)$formatRanges));
            CoreCodeStyleUtil.postProcessRanges((List)infos, arg_0 -> PrettierFormattingTask.computeExtendedRanges$lambda$5$lambda$4(arg_0 -> PrettierFormattingTask.computeExtendedRanges$lambda$5$lambda$3($extendedRanges, this$0, arg_0), arg_0));
        }

        private static final Pair processRangesWithPrettier$lambda$8(PrettierFormattingTask this$0) {
            Document document;
            Document document2 = document = FileDocumentManager.getInstance().getDocument(this$0.virtualFile);
            return new Pair((Object)document, (Object)(document2 != null ? Long.valueOf(document2.getModificationStamp()) : null));
        }

        private static final void processRangesWithPrettier$lambda$9(Document $document, Long $initialModificationStamp, PrettierFormattingTask this$0, PrettierFormattingContext $formattingContext, PrettierFormattingApplier $strategy) {
            Long l = $initialModificationStamp;
            if (l != null && $document.getModificationStamp() == l.longValue() && !Intrinsics.areEqual((Object)this$0.request.getDocumentText(), (Object)$formattingContext.getFormattedContent())) {
                Project project = this$0.project;
                VirtualFile virtualFile = this$0.file.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                $strategy.apply(project, virtualFile, $formattingContext);
                this$0.moveCursor(this$0.file, $formattingContext);
            }
        }
    }
}

