/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.connection.VmConnection;

public final class RemoteUrlMappingHelper {
    public static void showSetRemoteUrlDialog(@NotNull JavaScriptDebugProcess<? extends VmConnection<?>> debugProcess, @NotNull VirtualFile file) {
        if (debugProcess == null) {
            RemoteUrlMappingHelper.$$$reportNull$$$0(0);
        }
        if (file == null) {
            RemoteUrlMappingHelper.$$$reportNull$$$0(1);
        }
        Url hostUrl = debugProcess.getCurrentLocationUrl();
        String url = Messages.showInputDialog((Project)debugProcess.getSession().getProject(), (String)JSDebuggerBundle.message("label.text.input.remote.url.for.0", file.getName()), (String)JSDebuggerBundle.message("dialog.title.remote.url", new Object[0]), null, (String)(hostUrl == null ? null : hostUrl.trimParameters().toDecodedForm()), null);
        if (url != null) {
            RemoteUrlMappingHelper.addUrlMapping(debugProcess, file, url);
        }
    }

    private static void addUrlMapping(JavaScriptDebugProcess<? extends VmConnection<?>> debugProcess, VirtualFile file, String url) {
        RunProfile configuration = debugProcess.getSession().getRunProfile();
        if (configuration instanceof JavaScriptDebugConfiguration) {
            List<RemoteUrlMappingBean> mappings = ((JavaScriptDebugConfiguration)configuration).getMappings();
            String filePath = file.getPath();
            Iterator<RemoteUrlMappingBean> iterator = mappings.iterator();
            while (iterator.hasNext()) {
                RemoteUrlMappingBean mapping = iterator.next();
                if (!filePath.equals(mapping.localFilePath)) continue;
                iterator.remove();
            }
            mappings.add(new RemoteUrlMappingBean(filePath, url));
            debugProcess.updateRemoteUrlMappings(mappings);
        }
    }

    public static void showSetLocalPathDialog(@NotNull JavaScriptDebugProcess<? extends VmConnection<?>> debugProcess, @NotNull Url url, boolean allowFiles) {
        if (debugProcess == null) {
            RemoteUrlMappingHelper.$$$reportNull$$$0(2);
        }
        if (url == null) {
            RemoteUrlMappingHelper.$$$reportNull$$$0(3);
        }
        Project project = debugProcess.getSession().getProject();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(allowFiles, true, false, false, false, false).withExtensionFilter(IdeCoreBundle.message((String)"file.chooser.files.label", (Object[])new Object[]{"JS|HTML"}), JsFileUtil.getHtmlAndJavaScriptTypes()).withFileFilter(file -> !index.isExcluded(file)).withTitle(JSDebuggerBundle.message("js.remote.mapper.choose.path.title", new Object[0])).withDescription(JSDebuggerBundle.message("js.remote.mapper.choose.path.description", url)).withRoots(ProjectRootManager.getInstance((Project)project).getContentRoots());
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null, (VirtualFile)debugProcess.findFile(url), file -> RemoteUrlMappingHelper.addUrlMapping(debugProcess, file, url.trimParameters().toDecodedForm()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/debugger/RemoteUrlMappingHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showSetRemoteUrlDialog";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showSetLocalPathDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

