#ifndef MAUSCON_DNS_H
#define MAUSCON_DNS_H

#define DNS_SOFT -1
#define DNS_HARD -2

typedef struct dns_t {
	char *name;
	struct in_addr ip;
    int pref;
    struct dns_t *next;
} dns_t;

	/* sorts it */
int dns_mx P__((const char *domain, dns_t **answer));
int dns_a P__((const char *domain, dns_t **answer));
int dns_txt P__((const char *domain, dns_t **answer));
int dns_ptr P__((struct in_addr *ip, dns_t **answer));

void dns_free_chain P__((dns_t *));



#endif
