/* written mainly to get around the need to include a strtoul.c in
 * the distributions 
 */
#include "config.h"
#include "str2num.h"

int 
str2ulong(const char *s, unsigned long *ul, int base)
{
	unsigned long x=0;
	int len=0;
	if (base==0 && *s=='0') {
		if (s[1]=='x' || s[1]=='X') { base=16;s+=2;}
		else {base=8;s++; if (!*s) *ul=0;return 1; }
	} else if (base==0) base=10;
	/* i assume something about processor behaviour in case of overflow ... */
	/* and, of course, about the character set */
	while (*s) {
		unsigned int c=(unsigned char)*s;
		unsigned long old=x;
		if (c>='0' && c<='9') {
			if (c>7 && base==8) { *ul=x; return len;}
			x*=(unsigned long)base;
			x+=(unsigned long)(c-'0'); 
			if (x<old) return -1;
		} else if (base == 16) {
			int v;
			if (c>='a' && c<='f') v=10+(c-'a');
			else if (c>='A' && c<='F') v=10+(c-'A');
			else { *ul=x; return len;}
			x*=(unsigned long)base;
			x+=(unsigned long)v; 
			if (x<old) return -1;
		} else if (base != 16) { *ul=x;return len;}
		len++;
		s++;
	}
	*ul=x;
	return len;
}
