#include <stdlib.h>
#include <string.h>
#include "strdupsub.h"

char *
strdupsubw (const char *orig, const char *weg, const char *hin, const char *wordchars, size_t * nl,
	char *(*fn)(const char *,const char *))
{
	const char *p;
	char *w;
	char *z;
	size_t l, lorig, lweg, lhin;
	int count;
	const char *start=orig;
	lorig = strlen (orig);
	lweg = strlen (weg);
	lhin = strlen (hin);
	if (!fn) fn=strstr;
	if (!lweg)
		count = 1;
	else {
		for (count = 0, p = orig; ; ) {
			const char *fand;
			fand=(*fn)(p,weg);
			if (!fand)
				break;
			if ((fand==start || !strchr(wordchars,fand[-1])) /* at 1. char or at beginning of word */
			 && (!fand[lweg] || !strchr(wordchars,fand[lweg]))) {
			 	count++;
			}
			p = fand + lweg;
		}
	}
	l = count * (lhin - lweg) + lorig + 1;
	w = z = malloc (l);
	if (!z)
		return 0;
	*nl = l;
	while (lweg) {
		const char *fand;
		if (!(fand = (*fn) (orig, weg))) {
			strcpy (w, orig);
			return z;
		}
		if ((fand==start || !strchr(wordchars,fand[-1])) /* at 1. char or at beginning of word */
		 && (!fand[lweg] || !strchr(wordchars,fand[lweg]))) {
			if (fand != orig) {
				memcpy (w, orig, fand - orig);
				w += fand - orig;
			}
			memcpy (w, hin, lhin);
			w += lhin;
			orig = fand + lweg;
		} else {
			/* XwantedY with X or Y in wordchars. We can safely assume that we can jump to Y */
			memcpy(w,orig,fand-orig+lweg);
			w+=fand-orig+lweg;
			orig = fand + lweg;
		}
	}
	memcpy (w, orig, lorig);
	w += lorig;
	memcpy (w, hin, lhin);
	w[lhin] = 0;
	return z;
}

