#include "timselsysdep.h"
#include <errno.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/socket.h>

#include "nonblock.h"
#include "uosock.h"


/* see http://pobox.com/~djb/docs/connect.html 
 * for a excellent discussion of the problem.
 */
int
uosock_connect(struct sockaddr_in *target, int timeout)
{
	int fd;
	fd_set fds;
	struct timeval tv;
	time_t start;

	fd=socket(AF_INET,SOCK_STREAM,0);
	if (fd==-1) return -1;
	if (timeout > 0 && nonblock(fd,1)==-1) {
		int e=errno;
		close(fd);
		errno=e;
		return -1;
	}
	if (connect(fd,(struct sockaddr *)target,sizeof(*target))==0) {
		nonblock(fd,0);
		return fd; /* well done */
	}
	if (errno!=EINPROGRESS && errno!=EWOULDBLOCK) return -1;
	tv.tv_sec=timeout;
	tv.tv_usec=0;
	start=time(NULL);
	FD_ZERO(&fds);
	/* signal might interrupt us */
	while (1) {
		int ret;
		FD_SET(fd,&fds);
		ret=select(fd+1,0,&fds,0,&tv);
		if (ret==0) {
			/* timed out */
			close(fd);
			errno=ETIMEDOUT;
			return -1;
		} 
		if (ret==-1 && errno!=EINTR) {
			int e=errno;
			close(fd);
			errno=e;
			return -1;
		}
		if (ret>0 && FD_ISSET(fd,&fds)) {
			/* select returns when connect failed or succeeded */
			struct sockaddr_in s_in;
			int len=sizeof(s_in);
			if (0==getpeername(fd,(struct sockaddr *)&s_in,&len)) {
				nonblock(fd,0);
				return fd;
			} else {
				int e;
				read(fd,&len,1);
				e=errno;
				close(fd);
				errno=e;
				return -1;
			}
		}
		/* select garbled our struct tv */
		tv.tv_sec=timeout-(time(NULL)-start);
		if (tv.tv_sec < 1)
			tv.tv_sec=1;
		tv.tv_usec=0;
	}
}
	
