package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScreenSettings invokes the aegis.DescribeScreenSettings API synchronously
// api document: https://help.aliyun.com/api/aegis/describescreensettings.html
func (client *Client) DescribeScreenSettings(request *DescribeScreenSettingsRequest) (response *DescribeScreenSettingsResponse, err error) {
	response = CreateDescribeScreenSettingsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScreenSettingsWithChan invokes the aegis.DescribeScreenSettings API asynchronously
// api document: https://help.aliyun.com/api/aegis/describescreensettings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScreenSettingsWithChan(request *DescribeScreenSettingsRequest) (<-chan *DescribeScreenSettingsResponse, <-chan error) {
	responseChan := make(chan *DescribeScreenSettingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScreenSettings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScreenSettingsWithCallback invokes the aegis.DescribeScreenSettings API asynchronously
// api document: https://help.aliyun.com/api/aegis/describescreensettings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScreenSettingsWithCallback(request *DescribeScreenSettingsRequest, callback func(response *DescribeScreenSettingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScreenSettingsResponse
		var err error
		defer close(result)
		response, err = client.DescribeScreenSettings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScreenSettingsRequest is the request struct for api DescribeScreenSettings
type DescribeScreenSettingsRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeScreenSettingsResponse is the response struct for api DescribeScreenSettings
type DescribeScreenSettingsResponse struct {
	*responses.BaseResponse
	RequestId            string                     `json:"RequestId" xml:"RequestId"`
	SasScreenSettingList []SasScreenSettingListItem `json:"SasScreenSettingList" xml:"SasScreenSettingList"`
}

// CreateDescribeScreenSettingsRequest creates a request to invoke DescribeScreenSettings API
func CreateDescribeScreenSettingsRequest() (request *DescribeScreenSettingsRequest) {
	request = &DescribeScreenSettingsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeScreenSettings", "vipaegis", "openAPI")
	return
}

// CreateDescribeScreenSettingsResponse creates a response to parse from DescribeScreenSettings response
func CreateDescribeScreenSettingsResponse() (response *DescribeScreenSettingsResponse) {
	response = &DescribeScreenSettingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
