package amqp_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteBinding invokes the amqp_open.DeleteBinding API synchronously
// api document: https://help.aliyun.com/api/amqp-open/deletebinding.html
func (client *Client) DeleteBinding(request *DeleteBindingRequest) (response *DeleteBindingResponse, err error) {
	response = CreateDeleteBindingResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteBindingWithChan invokes the amqp_open.DeleteBinding API asynchronously
// api document: https://help.aliyun.com/api/amqp-open/deletebinding.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteBindingWithChan(request *DeleteBindingRequest) (<-chan *DeleteBindingResponse, <-chan error) {
	responseChan := make(chan *DeleteBindingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteBinding(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteBindingWithCallback invokes the amqp_open.DeleteBinding API asynchronously
// api document: https://help.aliyun.com/api/amqp-open/deletebinding.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteBindingWithCallback(request *DeleteBindingRequest, callback func(response *DeleteBindingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteBindingResponse
		var err error
		defer close(result)
		response, err = client.DeleteBinding(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteBindingRequest is the request struct for api DeleteBinding
type DeleteBindingRequest struct {
	*requests.RpcRequest
	DestinationName string `position:"Body" name:"DestinationName"`
	SourceExchange  string `position:"Body" name:"SourceExchange"`
	BindingKey      string `position:"Body" name:"BindingKey"`
	BindingType     string `position:"Body" name:"BindingType"`
	InstanceId      string `position:"Body" name:"InstanceId"`
	VirtualHost     string `position:"Body" name:"VirtualHost"`
}

// DeleteBindingResponse is the response struct for api DeleteBinding
type DeleteBindingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteBindingRequest creates a request to invoke DeleteBinding API
func CreateDeleteBindingRequest() (request *DeleteBindingRequest) {
	request = &DeleteBindingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("amqp-open", "2019-12-12", "DeleteBinding", "onsproxy", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteBindingResponse creates a response to parse from DeleteBinding response
func CreateDeleteBindingResponse() (response *DeleteBindingResponse) {
	response = &DeleteBindingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
