package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OemHeatLine invokes the cloudwf.OemHeatLine API synchronously
// api document: https://help.aliyun.com/api/cloudwf/oemheatline.html
func (client *Client) OemHeatLine(request *OemHeatLineRequest) (response *OemHeatLineResponse, err error) {
	response = CreateOemHeatLineResponse()
	err = client.DoAction(request, response)
	return
}

// OemHeatLineWithChan invokes the cloudwf.OemHeatLine API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemheatline.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemHeatLineWithChan(request *OemHeatLineRequest) (<-chan *OemHeatLineResponse, <-chan error) {
	responseChan := make(chan *OemHeatLineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OemHeatLine(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OemHeatLineWithCallback invokes the cloudwf.OemHeatLine API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemheatline.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemHeatLineWithCallback(request *OemHeatLineRequest, callback func(response *OemHeatLineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OemHeatLineResponse
		var err error
		defer close(result)
		response, err = client.OemHeatLine(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OemHeatLineRequest is the request struct for api OemHeatLine
type OemHeatLineRequest struct {
	*requests.RpcRequest
	Gsid requests.Integer `position:"Query" name:"Gsid"`
}

// OemHeatLineResponse is the response struct for api OemHeatLine
type OemHeatLineResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateOemHeatLineRequest creates a request to invoke OemHeatLine API
func CreateOemHeatLineRequest() (request *OemHeatLineRequest) {
	request = &OemHeatLineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "OemHeatLine", "cloudwf", "openAPI")
	return
}

// CreateOemHeatLineResponse creates a response to parse from OemHeatLine response
func CreateOemHeatLineResponse() (response *OemHeatLineResponse) {
	response = &OemHeatLineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
