package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClustersV1 invokes the cs.DescribeClustersV1 API synchronously
func (client *Client) DescribeClustersV1(request *DescribeClustersV1Request) (response *DescribeClustersV1Response, err error) {
	response = CreateDescribeClustersV1Response()
	err = client.DoAction(request, response)
	return
}

// DescribeClustersV1WithChan invokes the cs.DescribeClustersV1 API asynchronously
func (client *Client) DescribeClustersV1WithChan(request *DescribeClustersV1Request) (<-chan *DescribeClustersV1Response, <-chan error) {
	responseChan := make(chan *DescribeClustersV1Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClustersV1(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClustersV1WithCallback invokes the cs.DescribeClustersV1 API asynchronously
func (client *Client) DescribeClustersV1WithCallback(request *DescribeClustersV1Request, callback func(response *DescribeClustersV1Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClustersV1Response
		var err error
		defer close(result)
		response, err = client.DescribeClustersV1(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClustersV1Request is the request struct for api DescribeClustersV1
type DescribeClustersV1Request struct {
	*requests.RoaRequest
	PageNumber  requests.Integer `position:"Query" name:"page_number"`
	Name        string           `position:"Query" name:"name"`
	ClusterType string           `position:"Query" name:"cluster_type"`
	PageSize    requests.Integer `position:"Query" name:"page_size"`
}

// DescribeClustersV1Response is the response struct for api DescribeClustersV1
type DescribeClustersV1Response struct {
	*responses.BaseResponse
}

// CreateDescribeClustersV1Request creates a request to invoke DescribeClustersV1 API
func CreateDescribeClustersV1Request() (request *DescribeClustersV1Request) {
	request = &DescribeClustersV1Request{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeClustersV1", "/api/v1/clusters", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeClustersV1Response creates a response to parse from DescribeClustersV1 response
func CreateDescribeClustersV1Response() (response *DescribeClustersV1Response) {
	response = &DescribeClustersV1Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
