package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectLungNodule invokes the imageprocess.DetectLungNodule API synchronously
func (client *Client) DetectLungNodule(request *DetectLungNoduleRequest) (response *DetectLungNoduleResponse, err error) {
	response = CreateDetectLungNoduleResponse()
	err = client.DoAction(request, response)
	return
}

// DetectLungNoduleWithChan invokes the imageprocess.DetectLungNodule API asynchronously
func (client *Client) DetectLungNoduleWithChan(request *DetectLungNoduleRequest) (<-chan *DetectLungNoduleResponse, <-chan error) {
	responseChan := make(chan *DetectLungNoduleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectLungNodule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectLungNoduleWithCallback invokes the imageprocess.DetectLungNodule API asynchronously
func (client *Client) DetectLungNoduleWithCallback(request *DetectLungNoduleRequest, callback func(response *DetectLungNoduleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectLungNoduleResponse
		var err error
		defer close(result)
		response, err = client.DetectLungNodule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectLungNoduleRequest is the request struct for api DetectLungNodule
type DetectLungNoduleRequest struct {
	*requests.RpcRequest
	Threshold  requests.Float             `position:"Body" name:"Threshold"`
	OrgName    string                     `position:"Body" name:"OrgName"`
	DataFormat string                     `position:"Body" name:"DataFormat"`
	URLList    *[]DetectLungNoduleURLList `position:"Body" name:"URLList"  type:"Repeated"`
	OrgId      string                     `position:"Body" name:"OrgId"`
	Async      requests.Boolean           `position:"Body" name:"Async"`
}

// DetectLungNoduleURLList is a repeated param struct in DetectLungNoduleRequest
type DetectLungNoduleURLList struct {
	URL string `name:"URL"`
}

// DetectLungNoduleResponse is the response struct for api DetectLungNodule
type DetectLungNoduleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetectLungNoduleRequest creates a request to invoke DetectLungNodule API
func CreateDetectLungNoduleRequest() (request *DetectLungNoduleRequest) {
	request = &DetectLungNoduleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "DetectLungNodule", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectLungNoduleResponse creates a response to parse from DetectLungNodule response
func CreateDetectLungNoduleResponse() (response *DetectLungNoduleResponse) {
	response = &DetectLungNoduleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
