package ledgerdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMembers invokes the ledgerdb.ListMembers API synchronously
// api document: https://help.aliyun.com/api/ledgerdb/listmembers.html
func (client *Client) ListMembers(request *ListMembersRequest) (response *ListMembersResponse, err error) {
	response = CreateListMembersResponse()
	err = client.DoAction(request, response)
	return
}

// ListMembersWithChan invokes the ledgerdb.ListMembers API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/listmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListMembersWithChan(request *ListMembersRequest) (<-chan *ListMembersResponse, <-chan error) {
	responseChan := make(chan *ListMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMembersWithCallback invokes the ledgerdb.ListMembers API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/listmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListMembersWithCallback(request *ListMembersRequest, callback func(response *ListMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMembersResponse
		var err error
		defer close(result)
		response, err = client.ListMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMembersRequest is the request struct for api ListMembers
type ListMembersRequest struct {
	*requests.RpcRequest
	LedgerId   string           `position:"Query" name:"LedgerId"`
	NextToken  string           `position:"Query" name:"NextToken"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
}

// ListMembersResponse is the response struct for api ListMembers
type ListMembersResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	NextToken  string   `json:"NextToken" xml:"NextToken"`
	MaxResults int      `json:"MaxResults" xml:"MaxResults"`
	Members    []Member `json:"Members" xml:"Members"`
}

// CreateListMembersRequest creates a request to invoke ListMembers API
func CreateListMembersRequest() (request *ListMembersRequest) {
	request = &ListMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ledgerdb", "2019-11-22", "ListMembers", "ledgerdb", "openAPI")
	return
}

// CreateListMembersResponse creates a response to parse from ListMembers response
func CreateListMembersResponse() (response *ListMembersResponse) {
	response = &ListMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
