package lubancloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetStyles invokes the lubancloud.GetStyles API synchronously
// api document: https://help.aliyun.com/api/lubancloud/getstyles.html
func (client *Client) GetStyles(request *GetStylesRequest) (response *GetStylesResponse, err error) {
	response = CreateGetStylesResponse()
	err = client.DoAction(request, response)
	return
}

// GetStylesWithChan invokes the lubancloud.GetStyles API asynchronously
// api document: https://help.aliyun.com/api/lubancloud/getstyles.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetStylesWithChan(request *GetStylesRequest) (<-chan *GetStylesResponse, <-chan error) {
	responseChan := make(chan *GetStylesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetStyles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetStylesWithCallback invokes the lubancloud.GetStyles API asynchronously
// api document: https://help.aliyun.com/api/lubancloud/getstyles.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetStylesWithCallback(request *GetStylesRequest, callback func(response *GetStylesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetStylesResponse
		var err error
		defer close(result)
		response, err = client.GetStyles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetStylesRequest is the request struct for api GetStyles
type GetStylesRequest struct {
	*requests.RpcRequest
}

// GetStylesResponse is the response struct for api GetStyles
type GetStylesResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Styles    []Style `json:"Styles" xml:"Styles"`
}

// CreateGetStylesRequest creates a request to invoke GetStyles API
func CreateGetStylesRequest() (request *GetStylesRequest) {
	request = &GetStylesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lubancloud", "2018-05-09", "GetStyles", "luban", "openAPI")
	return
}

// CreateGetStylesResponse creates a response to parse from GetStyles response
func CreateGetStylesResponse() (response *GetStylesResponse) {
	response = &GetStylesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
