package objectdet

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateVehicleRepairPlan invokes the objectdet.GenerateVehicleRepairPlan API synchronously
func (client *Client) GenerateVehicleRepairPlan(request *GenerateVehicleRepairPlanRequest) (response *GenerateVehicleRepairPlanResponse, err error) {
	response = CreateGenerateVehicleRepairPlanResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateVehicleRepairPlanWithChan invokes the objectdet.GenerateVehicleRepairPlan API asynchronously
func (client *Client) GenerateVehicleRepairPlanWithChan(request *GenerateVehicleRepairPlanRequest) (<-chan *GenerateVehicleRepairPlanResponse, <-chan error) {
	responseChan := make(chan *GenerateVehicleRepairPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateVehicleRepairPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateVehicleRepairPlanWithCallback invokes the objectdet.GenerateVehicleRepairPlan API asynchronously
func (client *Client) GenerateVehicleRepairPlanWithCallback(request *GenerateVehicleRepairPlanRequest, callback func(response *GenerateVehicleRepairPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateVehicleRepairPlanResponse
		var err error
		defer close(result)
		response, err = client.GenerateVehicleRepairPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateVehicleRepairPlanRequest is the request struct for api GenerateVehicleRepairPlan
type GenerateVehicleRepairPlanRequest struct {
	*requests.RpcRequest
	DamageImageList *[]GenerateVehicleRepairPlanDamageImageList `position:"Body" name:"DamageImageList"  type:"Repeated"`
}

// GenerateVehicleRepairPlanDamageImageList is a repeated param struct in GenerateVehicleRepairPlanRequest
type GenerateVehicleRepairPlanDamageImageList struct {
	ImageUrl        string `name:"ImageUrl"`
	CreateTimeStamp string `name:"CreateTimeStamp"`
}

// GenerateVehicleRepairPlanResponse is the response struct for api GenerateVehicleRepairPlan
type GenerateVehicleRepairPlanResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	HttpCode     int    `json:"HttpCode" xml:"HttpCode"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateGenerateVehicleRepairPlanRequest creates a request to invoke GenerateVehicleRepairPlan API
func CreateGenerateVehicleRepairPlanRequest() (request *GenerateVehicleRepairPlanRequest) {
	request = &GenerateVehicleRepairPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("objectdet", "2019-12-30", "GenerateVehicleRepairPlan", "objectdet", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGenerateVehicleRepairPlanResponse creates a response to parse from GenerateVehicleRepairPlan response
func CreateGenerateVehicleRepairPlanResponse() (response *GenerateVehicleRepairPlanResponse) {
	response = &GenerateVehicleRepairPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
