package ons

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OnsTopicStatus invokes the ons.OnsTopicStatus API synchronously
func (client *Client) OnsTopicStatus(request *OnsTopicStatusRequest) (response *OnsTopicStatusResponse, err error) {
	response = CreateOnsTopicStatusResponse()
	err = client.DoAction(request, response)
	return
}

// OnsTopicStatusWithChan invokes the ons.OnsTopicStatus API asynchronously
func (client *Client) OnsTopicStatusWithChan(request *OnsTopicStatusRequest) (<-chan *OnsTopicStatusResponse, <-chan error) {
	responseChan := make(chan *OnsTopicStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OnsTopicStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OnsTopicStatusWithCallback invokes the ons.OnsTopicStatus API asynchronously
func (client *Client) OnsTopicStatusWithCallback(request *OnsTopicStatusRequest, callback func(response *OnsTopicStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OnsTopicStatusResponse
		var err error
		defer close(result)
		response, err = client.OnsTopicStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OnsTopicStatusRequest is the request struct for api OnsTopicStatus
type OnsTopicStatusRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	Topic      string `position:"Query" name:"Topic"`
}

// OnsTopicStatusResponse is the response struct for api OnsTopicStatus
type OnsTopicStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	HelpUrl   string `json:"HelpUrl" xml:"HelpUrl"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateOnsTopicStatusRequest creates a request to invoke OnsTopicStatus API
func CreateOnsTopicStatusRequest() (request *OnsTopicStatusRequest) {
	request = &OnsTopicStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ons", "2019-02-14", "OnsTopicStatus", "ons", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOnsTopicStatusResponse creates a response to parse from OnsTopicStatus response
func CreateOnsTopicStatusResponse() (response *OnsTopicStatusResponse) {
	response = &OnsTopicStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
