/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.stubs.DomElementTypeHolder;
import com.intellij.util.xml.stubs.ElementStub;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XIncludeStub
extends ObjectStubBase<ElementStub> {
    private final String myHref;
    private final String myXpointer;
    private volatile CachedValue<DomElement> myCachedValue;

    public XIncludeStub(ElementStub parent, @Nullable String href, @Nullable String xpointer) {
        super((Stub)parent);
        this.myHref = href;
        this.myXpointer = xpointer;
        parent.addChild((Stub)this);
    }

    @NotNull
    public List<? extends Stub> getChildrenStubs() {
        List list2 = Collections.emptyList();
        if (list2 == null) {
            XIncludeStub.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public ObjectStubSerializer<?, Stub> getStubType() {
        return DomElementTypeHolder.XIncludeStub;
    }

    public void resolve(DomInvocationHandler parent, List<DomElement> included, XmlName xmlName) {
        DomElement rootElement;
        XmlFile file = parent.getFile();
        if (this.myCachedValue == null) {
            this.myCachedValue = CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> {
                DomElement result2 = this.computeValue(parent);
                return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            });
        }
        if ((rootElement = (DomElement)this.myCachedValue.getValue()) != null) {
            XIncludeStub.processChildrenWithLocalName(rootElement, xmlName.getLocalName(), (Processor<? super DomElement>)new CommonProcessors.CollectProcessor(included));
        }
    }

    private static void processChildrenWithLocalName(DomElement parent, String localName, Processor<? super DomElement> processor) {
        parent.acceptChildren(element -> {
            if (element.getXmlElementName().equals(localName)) {
                processor.process((Object)element);
            }
        });
    }

    @Nullable
    private DomElement computeValue(DomInvocationHandler parent) {
        Object result2;
        DomFileElement element;
        if (StringUtil.isEmpty((String)this.myHref) || StringUtil.isEmpty((String)this.myXpointer)) {
            return null;
        }
        Matcher matcher = JDOMUtil.XPOINTER_PATTERN.matcher(this.myXpointer);
        if (!matcher.matches()) {
            return null;
        }
        String group = matcher.group(1);
        if (!(matcher = JDOMUtil.CHILDREN_PATTERN.matcher(group)).matches()) {
            return null;
        }
        String tagName = matcher.group(1);
        XmlFile file = parent.getFile();
        PsiFileImpl dummy = (PsiFileImpl)PsiFileFactory.getInstance((Project)file.getProject()).createFileFromText((Language)PlainTextLanguage.INSTANCE, (CharSequence)this.myHref);
        dummy.setOriginalFile((PsiFile)file);
        PsiFileSystemItem fileSystemItem = new FileReferenceSet((PsiElement)dummy).resolve();
        if (fileSystemItem instanceof XmlFile && (element = parent.getManager().getFileElement((XmlFile)fileSystemItem)) != null && tagName.equals((result2 = element.getRootElement()).getXmlElementName())) {
            String subTagName = matcher.group(2);
            if (subTagName != null) {
                CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
                XIncludeStub.processChildrenWithLocalName(result2, subTagName.substring(1), (Processor<? super DomElement>)processor);
                return (DomElement)processor.getFoundValue();
            }
            return result2;
        }
        return null;
    }

    public String toString() {
        return "href=" + this.myHref + " xpointer=" + this.myXpointer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/stubs/XIncludeStub", "getChildrenStubs"));
    }

    static class XIncludeStubSerializer
    implements ObjectStubSerializer<XIncludeStub, ElementStub> {
        XIncludeStubSerializer() {
        }

        @NotNull
        public String getExternalId() {
            return "xml.XIncludeStub";
        }

        public void serialize(@NotNull XIncludeStub stub, @NotNull StubOutputStream dataStream) throws IOException {
            if (stub == null) {
                XIncludeStubSerializer.$$$reportNull$$$0(0);
            }
            if (dataStream == null) {
                XIncludeStubSerializer.$$$reportNull$$$0(1);
            }
            dataStream.writeUTFFast(StringUtil.notNullize((String)stub.myHref));
            dataStream.writeUTFFast(StringUtil.notNullize((String)stub.myXpointer));
        }

        @NotNull
        public XIncludeStub deserialize(@NotNull StubInputStream dataStream, ElementStub parentStub) throws IOException {
            if (dataStream == null) {
                XIncludeStubSerializer.$$$reportNull$$$0(2);
            }
            return new XIncludeStub(parentStub, dataStream.readUTFFast(), dataStream.readUTFFast());
        }

        public void indexStub(@NotNull XIncludeStub stub, @NotNull IndexSink sink) {
            if (stub == null) {
                XIncludeStubSerializer.$$$reportNull$$$0(3);
            }
            if (sink == null) {
                XIncludeStubSerializer.$$$reportNull$$$0(4);
            }
        }

        public String toString() {
            return "XInclude";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stub";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataStream";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/xml/stubs/XIncludeStub$XIncludeStubSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "serialize";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deserialize";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexStub";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

