/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.regex.TextMateRange;
import org.jetbrains.plugins.textmate.regex.TextMateString;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u000e\u001a\u00020\u000bJ\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/textmate/regex/MatchData;", "", "matched", "", "offsets", "", "<init>", "(Z[I)V", "getMatched", "()Z", "count", "", "byteOffset", "Lorg/jetbrains/plugins/textmate/regex/TextMateRange;", "group", "charRange", "textMateString", "Lorg/jetbrains/plugins/textmate/regex/TextMateString;", "equals", "other", "hashCode", "toString", "", "component1", "component2", "copy", "Companion", "intellij.textmate.core"})
public final class MatchData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean matched;
    @NotNull
    private final int[] offsets;
    @NotNull
    private static final MatchData NOT_MATCHED = new MatchData(false, new int[0]);

    public MatchData(boolean matched, @NotNull int[] offsets) {
        Intrinsics.checkNotNullParameter((Object)offsets, (String)"offsets");
        this.matched = matched;
        this.offsets = offsets;
    }

    public final boolean getMatched() {
        return this.matched;
    }

    public final int count() {
        return this.offsets.length / 2;
    }

    @NotNull
    public final TextMateRange byteOffset(int group) {
        int endIndex = group * 2 + 1;
        return new TextMateRange(this.offsets[endIndex - 1], this.offsets[endIndex]);
    }

    public static /* synthetic */ TextMateRange byteOffset$default(MatchData matchData, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return matchData.byteOffset(n);
    }

    @NotNull
    public final TextMateRange charRange(@NotNull TextMateString textMateString, int group) {
        Intrinsics.checkNotNullParameter((Object)textMateString, (String)"textMateString");
        return textMateString.charRangeByByteRange(this.byteOffset(group));
    }

    public static /* synthetic */ TextMateRange charRange$default(MatchData matchData, TextMateString textMateString, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return matchData.charRange(textMateString, n);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        MatchData matchData = (MatchData)other;
        if (this.matched != matchData.matched) {
            return false;
        }
        return Arrays.equals(this.offsets, matchData.offsets);
    }

    public int hashCode() {
        return 31 * (this.matched ? 1 : 0) + Arrays.hashCode(this.offsets);
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.offsets);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "{ matched=" + this.matched + ", offsets=" + string + "}";
    }

    public final boolean component1() {
        return this.matched;
    }

    private final int[] component2() {
        return this.offsets;
    }

    @NotNull
    public final MatchData copy(boolean matched, @NotNull int[] offsets) {
        Intrinsics.checkNotNullParameter((Object)offsets, (String)"offsets");
        return new MatchData(matched, offsets);
    }

    public static /* synthetic */ MatchData copy$default(MatchData matchData, boolean bl, int[] nArray, int n, Object object) {
        if ((n & 1) != 0) {
            bl = matchData.matched;
        }
        if ((n & 2) != 0) {
            nArray = matchData.offsets;
        }
        return matchData.copy(bl, nArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/textmate/regex/MatchData$Companion;", "", "<init>", "()V", "NOT_MATCHED", "Lorg/jetbrains/plugins/textmate/regex/MatchData;", "getNOT_MATCHED", "()Lorg/jetbrains/plugins/textmate/regex/MatchData;", "intellij.textmate.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MatchData getNOT_MATCHED() {
            return NOT_MATCHED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

