/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.remoteEdit.RemoteEditContext;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import com.jetbrains.plugins.webDeployment.remoteEdit.notification.RemoteEditEditorDecorator;
import java.io.IOException;
import java.util.Queue;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteEditRefreshFilesTask
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance(RemoteEditRefreshFilesTask.class);
    protected final ConnectionOwner myConnectionOwner;
    @NotNull
    private final Queue<RemoteVirtualFile> myQueue;
    private volatile boolean myProjectCloseRequested;
    private volatile boolean myFinished;

    public RemoteEditRefreshFilesTask(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, @NotNull @NlsContexts.ProgressTitle String title, @NotNull Queue<RemoteVirtualFile> queue) {
        if (connectionOwner == null) {
            RemoteEditRefreshFilesTask.$$$reportNull$$$0(0);
        }
        if (title == null) {
            RemoteEditRefreshFilesTask.$$$reportNull$$$0(1);
        }
        if (queue == null) {
            RemoteEditRefreshFilesTask.$$$reportNull$$$0(2);
        }
        super(project, title, true, PerformInBackgroundOption.ALWAYS_BACKGROUND);
        this.myConnectionOwner = connectionOwner;
        this.myQueue = queue;
    }

    public boolean isConditionalModal() {
        return true;
    }

    public void run(@NotNull ProgressIndicator pi) {
        if (pi == null) {
            RemoteEditRefreshFilesTask.$$$reportNull$$$0(3);
        }
        this.doRun(pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void doRun(final @NotNull ProgressIndicator pi) {
        if (pi == null) {
            RemoteEditRefreshFilesTask.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(!this.myFinished);
        VetoableProjectManagerListener listener = null;
        if (this.myProject != null) {
            listener = new VetoableProjectManagerListener(){

                public boolean canClose(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (project != RemoteEditRefreshFilesTask.this.myProject) {
                        return true;
                    }
                    String title = WDBundle.message("warning.running.dialog.title", RemoteEditRefreshFilesTask.this.getTitle());
                    String text = WDBundle.message("warning.running.on.project.close", RemoteEditRefreshFilesTask.this.getTitle());
                    int result = Messages.showOkCancelDialog((Project)RemoteEditRefreshFilesTask.this.myProject, (String)text, (String)title, (Icon)Messages.getQuestionIcon());
                    if (result != 0) {
                        return false;
                    }
                    RemoteEditRefreshFilesTask.this.myProjectCloseRequested = true;
                    pi.cancel();
                    return RemoteEditRefreshFilesTask.this.myFinished;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditRefreshFilesTask$1", "canClose"));
                }
            };
            ProjectManager.getInstance().addProjectManagerListener(listener);
        }
        try {
            RemoteVirtualFile next;
            while ((next = this.myQueue.poll()) != null) {
                RemoteConnection connection = next.getClonedConnection();
                try {
                    this.refreshFile(pi, next, connection);
                }
                finally {
                    if (connection == null) continue;
                    connection.release();
                }
            }
            return;
        }
        catch (ProcessCanceledException e) {
            LOG.debug("cancelled");
            return;
        }
        finally {
            this.myFinished = true;
            if (listener != null) {
                ProjectManager.getInstance().removeProjectManagerListener(listener);
            }
            if (this.myProjectCloseRequested && this.myProject != null) {
                ApplicationManager.getApplication().invokeLater(() -> ProjectManager.getInstance().closeAndDispose(this.myProject));
            }
        }
    }

    private void refreshFile(@NotNull ProgressIndicator pi, RemoteVirtualFile next, RemoteConnection connection) {
        if (pi == null) {
            RemoteEditRefreshFilesTask.$$$reportNull$$$0(5);
        }
        pi.setText(WDBundle.message("remote.edit.refreshing.content.of", next.getPath()));
        Deployable serverConfig = next.getServerConfig();
        FileObject dest = next.getDestination();
        RemoteEditContext context = new RemoteEditContext(this.myProject, pi, serverConfig);
        pi.checkCanceled();
        Ref exceptionHolder = Ref.create();
        RemoteContent remoteContent = (RemoteContent)connection.executeServerOperationSilently(() -> {
            try {
                DeploymentPathUtils.refreshRemoteFile(dest, context);
                return new RemoteContent(FileTransferUtil.getContent(dest, pi));
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                exceptionHolder.set((Object)e);
                return null;
            }
        }, pi);
        IOException exception = (IOException)exceptionHolder.get();
        if (exception != null) {
            String message = WDBundle.message("remote.edit.failed.to.refresh.content.of.remote.file.0.from.server.1.n.2", next.getPath(), next.getServerConfig().getName(), exception.getMessage());
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)message, (String)RemoteEditRefreshFilesTask.getMessagesTitle()));
            return;
        }
        pi.checkCanceled();
        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)next);
            if (document == null) {
                return;
            }
            if (this.myProject == null) {
                return;
            }
            document.setText((CharSequence)StringUtil.convertLineSeparators((String)new String(remoteContent.content, next.getCharset())));
            FileDocumentManager.getInstance().saveDocument(document);
            next.updateContent(remoteContent.content);
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
            RemoteEditEditorDecorator.updateDecorators(next);
        }));
        pi.setText("");
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    @NlsContexts.DialogTitle
    private static String getMessagesTitle() {
        return WDBundle.message("remote.edit.remote.file.refresh.messages.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pi";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditRefreshFilesTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doRun";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RemoteContent {
        private final byte[] content;

        private RemoteContent(byte[] content) {
            this.content = content;
        }
    }
}

