/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramFileType;
import com.intellij.diagram.DiagramProvider;
import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.containers.FixedHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UmlVirtualFileSystem
extends DeprecatedVirtualFileSystem {
    @NotNull
    @NonNls
    public static final String PROTOCOL = "uml";
    @NotNull
    @NonNls
    public static final String PROTOCOL_PREFIX = "uml://";
    @NotNull
    @NonNls
    public static final String CHANGES = "uml://$SHOW_CHANGES$/";
    @NotNull
    private final Map<String, VirtualFile> myCache = new FixedHashMap(30);

    public boolean isReadOnly() {
        return false;
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @NotNull
    public VirtualFile findFileByPath(@NotNull String path) {
        VirtualFile file;
        if (path == null) {
            UmlVirtualFileSystem.$$$reportNull$$$0(0);
        }
        if ((file = this.myCache.get(path)) == null) {
            file = new UmlVirtualFile(path);
            this.myCache.put(path, file);
        }
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            UmlVirtualFileSystem.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    public void refresh(boolean asynchronous) {
    }

    public static boolean isInitialized(@Nullable VirtualFile vf) {
        return vf instanceof UmlVirtualFile && ((UmlVirtualFile)vf).isInitialized();
    }

    public static void setInitialized(@Nullable VirtualFile vf) {
        if (vf instanceof UmlVirtualFile) {
            ((UmlVirtualFile)vf).setInitialized(true);
        }
    }

    @NotNull
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            UmlVirtualFileSystem.$$$reportNull$$$0(2);
        }
        VirtualFile virtualFile = this.findFileByPath(path);
        if (virtualFile == null) {
            UmlVirtualFileSystem.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    public static boolean isUmlVirtualFile(@Nullable VirtualFile file) {
        return file instanceof UmlVirtualFile;
    }

    static boolean isShowChangesFile(VirtualFile file) {
        return UmlVirtualFileSystem.isUmlVirtualFile(file) && file.getUrl().startsWith(CHANGES);
    }

    static {
        PluginVerifier.verifyUltimatePlugin();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/UmlVirtualFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/UmlVirtualFileSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileByPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndFindFileByPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    @Presentation(icon="AllIcons.FileTypes.Diagram")
    public class UmlVirtualFile
    extends VirtualFile
    implements VirtualFilePathWrapper,
    VirtualFileWithoutContent {
        @NotNull
        private final String myName;
        @Nullable
        private volatile String myPresentableName;
        @Nullable
        private volatile Project myProject;
        @NotNull
        private final List<DiagramBuilder> myBuilders;
        private volatile boolean myIsInitialized;
        private volatile long myTimestamp;
        @NotNull
        private final AtomicLong myModificationStamp;

        public UmlVirtualFile(String name) {
            if (name == null) {
                UmlVirtualFile.$$$reportNull$$$0(0);
            }
            this.myBuilders = Collections.synchronizedList(new ArrayList());
            this.myIsInitialized = false;
            this.myTimestamp = 0L;
            this.myModificationStamp = new AtomicLong();
            this.myName = name;
            this.updateTimeStamp();
        }

        private void updateTimeStamp() {
            this.myTimestamp = System.currentTimeMillis();
            this.myModificationStamp.incrementAndGet();
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                UmlVirtualFile.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public DiagramProvider getUmlProvider() {
            int ind = this.myName.indexOf(47);
            if (ind == -1) {
                return null;
            }
            return DiagramProvider.findByID(this.myName.substring(0, ind));
        }

        @Nullable
        public String getFQN() {
            int ind = this.myName.indexOf(47);
            if (ind == -1) {
                return null;
            }
            return this.myName.substring(ind + 1);
        }

        @NotNull
        public String getShortName() {
            String presentableName = this.myPresentableName;
            if (presentableName != null) {
                String string = presentableName;
                if (string == null) {
                    UmlVirtualFile.$$$reportNull$$$0(2);
                }
                return string;
            }
            int ind = this.myName.lastIndexOf(46);
            String string = ind < 0 ? this.myName : this.myName.substring(ind + 1);
            if (string == null) {
                UmlVirtualFile.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public VirtualFileSystem getFileSystem() {
            UmlVirtualFileSystem umlVirtualFileSystem = UmlVirtualFileSystem.this;
            if (umlVirtualFileSystem == null) {
                UmlVirtualFile.$$$reportNull$$$0(4);
            }
            return umlVirtualFileSystem;
        }

        @NotNull
        public String getPath() {
            String string = this.getName();
            if (string == null) {
                UmlVirtualFile.$$$reportNull$$$0(5);
            }
            return string;
        }

        public boolean isWritable() {
            return true;
        }

        public boolean isDirectory() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        @Nullable
        public VirtualFile getParent() {
            return null;
        }

        public VirtualFile @NotNull [] getChildren() {
            if (EMPTY_ARRAY == null) {
                UmlVirtualFile.$$$reportNull$$$0(6);
            }
            return EMPTY_ARRAY;
        }

        @NotNull
        public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
            throw new UnsupportedOperationException("getOutputStream is not implemented in : " + String.valueOf(((Object)((Object)this)).getClass()));
        }

        public byte @NotNull [] contentsToByteArray() throws IOException {
            throw new UnsupportedOperationException("contentsToByteArray is not implemented in : " + String.valueOf(((Object)((Object)this)).getClass()));
        }

        public long getTimeStamp() {
            return this.myTimestamp;
        }

        public long getLength() {
            return 0L;
        }

        public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        }

        @NotNull
        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException("getInputStream is not implemented in : " + String.valueOf(((Object)((Object)this)).getClass()));
        }

        public long getModificationStamp() {
            return this.myModificationStamp.get();
        }

        @NotNull
        public String getPresentableName() {
            if (this.getUmlProvider() == null) {
                String string = UmlVirtualFileSystem.isShowChangesFile(this) ? DiagramBundle.message("uml.file.name.for.changes", this.getChangeListName()) : DiagramBundle.message("uml.class.diagram.file.name", this.getShortName());
                if (string == null) {
                    UmlVirtualFile.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = UmlVirtualFileSystem.isShowChangesFile(this) ? DiagramBundle.message("uml.file.name.for.changes", this.getChangeListName()) : this.getShortName();
            if (string == null) {
                UmlVirtualFile.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        private String getChangeListName() {
            String string = this.getPath().substring(UmlVirtualFileSystem.CHANGES.length()).split("/")[1];
            if (string == null) {
                UmlVirtualFile.$$$reportNull$$$0(9);
            }
            return string;
        }

        @NotNull
        public FileType getFileType() {
            DiagramFileType diagramFileType = DiagramFileType.INSTANCE;
            if (diagramFileType == null) {
                UmlVirtualFile.$$$reportNull$$$0(10);
            }
            return diagramFileType;
        }

        public boolean isInitialized() {
            return this.myIsInitialized;
        }

        public void setInitialized(boolean initialized) {
            this.myIsInitialized = initialized;
        }

        public void setPresentableName(@Nullable String presentableName) {
            this.myPresentableName = presentableName;
        }

        @NotNull
        public String getPresentablePath() {
            String string = this.getPresentableName();
            if (string == null) {
                UmlVirtualFile.$$$reportNull$$$0(11);
            }
            return string;
        }

        public boolean enforcePresentableName() {
            return true;
        }

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        public void setProject(@NotNull Project project) {
            if (project == null) {
                UmlVirtualFile.$$$reportNull$$$0(12);
            }
            this.myProject = project;
            Disposer.register((Disposable)this.myProject, this::clearCache);
        }

        @Nullable
        public DiagramBuilder getBuilder() {
            return this.myBuilders.isEmpty() ? null : this.myBuilders.get(this.myBuilders.size() - 1);
        }

        public void addBuilder(final @NotNull DiagramBuilder builder) {
            if (builder == null) {
                UmlVirtualFile.$$$reportNull$$$0(13);
            }
            if (!this.myBuilders.contains(builder)) {
                this.myBuilders.add(builder);
            }
            Disposer.register((Disposable)builder, (Disposable)new Disposable(){

                public void dispose() {
                    UmlVirtualFile.this.myBuilders.remove(builder);
                    if (UmlVirtualFile.this.myBuilders.isEmpty()) {
                        UmlVirtualFile.this.clearCache();
                    }
                }
            });
        }

        public void clearCache() {
            this.myProject = null;
            this.myBuilders.clear();
            this.myIsInitialized = false;
        }

        public boolean equals(Object obj) {
            return obj instanceof UmlVirtualFile && this.myName.equals(((UmlVirtualFile)((Object)obj)).getName());
        }

        public int hashCode() {
            return this.myName.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/UmlVirtualFileSystem$UmlVirtualFile";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/UmlVirtualFileSystem$UmlVirtualFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileSystem";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangeListName";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileType";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentablePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "setProject";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "addBuilder";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
            };
        }
    }
}

