/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.jsx;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTokenType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.jsx.JSXChangeAttributeValueIntention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\tH\u0014\u00a8\u0006\f"}, d2={"Lorg/intellij/idea/lang/javascript/intention/jsx/JSXChangeAttributeQuotesIntention;", "Lorg/intellij/idea/lang/javascript/intention/jsx/JSXChangeAttributeValueIntention;", "<init>", "()V", "getFamilyName", "", "isAcceptableAttributeValueElement", "", "element", "Lcom/intellij/psi/PsiElement;", "getNewAttributeValue", "oldAttribute", "intellij.javascript.intentions"})
final class JSXChangeAttributeQuotesIntention
extends JSXChangeAttributeValueIntention {
    @NotNull
    public String getFamilyName() {
        String string = JSIntentionBundle.message("jsx.attribute.value.wrap.with.braces.family-name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    protected boolean isAcceptableAttributeValueElement(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement firstChild = element.getFirstChild();
        if (firstChild != null && !(firstChild instanceof JSEmbeddedContent)) {
            this.setText(element.getNode().findChildByType(XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) != null ? JSIntentionBundle.message("jsx.attribute.value.wrap.with.braces.display-name", new Object[0]) : JSIntentionBundle.message("jsx.attribute.value.wrap.with.braces.replace.display-name", new Object[0]));
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected String getNewAttributeValue(@NotNull PsiElement oldAttribute) {
        ASTNode delimiter;
        Intrinsics.checkNotNullParameter((Object)oldAttribute, (String)"oldAttribute");
        ASTNode node = oldAttribute.getNode();
        ASTNode value = node.findChildByType(XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN);
        ASTNode aSTNode = delimiter = node.findChildByType(XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER);
        String quotes = aSTNode != null ? aSTNode.getText() : null;
        if (value == null) return "{}";
        String string = value.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() == 0) {
            return "{}";
        }
        boolean bl = false;
        if (bl) {
            return "{}";
        }
        String string2 = "{" + quotes + value.getText() + quotes + "}";
        return string2;
    }
}

